/*
 * Decompiled with CFR 0.152.
 */
package com.diegocarloslima.fgelv.lib;

import android.database.DataSetObserver;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ExpandableListAdapter;
import com.diegocarloslima.fgelv.lib.R;

public class WrapperExpandableListAdapter
extends BaseExpandableListAdapter {
    private final ExpandableListAdapter mWrappedAdapter;
    private final SparseBooleanArray mGroupExpandedMap = new SparseBooleanArray();

    public WrapperExpandableListAdapter(ExpandableListAdapter adapter) {
        this.mWrappedAdapter = adapter;
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mWrappedAdapter.registerDataSetObserver(observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mWrappedAdapter.unregisterDataSetObserver(observer);
    }

    public int getGroupCount() {
        return this.mWrappedAdapter.getGroupCount();
    }

    public int getChildrenCount(int groupPosition) {
        return this.mWrappedAdapter.getChildrenCount(groupPosition);
    }

    public Object getGroup(int groupPosition) {
        return this.mWrappedAdapter.getGroup(groupPosition);
    }

    public Object getChild(int groupPosition, int childPosition) {
        return this.mWrappedAdapter.getChild(groupPosition, childPosition);
    }

    public long getGroupId(int groupPosition) {
        return this.mWrappedAdapter.getGroupId(groupPosition);
    }

    public long getChildId(int groupPosition, int childPosition) {
        return this.mWrappedAdapter.getChildId(groupPosition, childPosition);
    }

    public boolean hasStableIds() {
        return this.mWrappedAdapter.hasStableIds();
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        if (convertView != null) {
            boolean changedVisibility;
            Object tag = convertView.getTag(R.id.fgelv_tag_changed_visibility);
            if (tag instanceof Boolean && (changedVisibility = ((Boolean)tag).booleanValue())) {
                convertView.setVisibility(0);
            }
            convertView.setTag(R.id.fgelv_tag_changed_visibility, null);
        }
        this.mGroupExpandedMap.put(groupPosition, isExpanded);
        return this.mWrappedAdapter.getGroupView(groupPosition, isExpanded, convertView, parent);
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        return this.mWrappedAdapter.getChildView(groupPosition, childPosition, isLastChild, convertView, parent);
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return this.mWrappedAdapter.isChildSelectable(groupPosition, childPosition);
    }

    public boolean areAllItemsEnabled() {
        return this.mWrappedAdapter.areAllItemsEnabled();
    }

    public boolean isEmpty() {
        return this.mWrappedAdapter.isEmpty();
    }

    public void onGroupExpanded(int groupPosition) {
        this.mGroupExpandedMap.put(groupPosition, true);
        this.mWrappedAdapter.onGroupExpanded(groupPosition);
    }

    public void onGroupCollapsed(int groupPosition) {
        this.mGroupExpandedMap.put(groupPosition, false);
        this.mWrappedAdapter.onGroupCollapsed(groupPosition);
    }

    public long getCombinedGroupId(long groupId) {
        return this.mWrappedAdapter.getCombinedGroupId(groupId);
    }

    public long getCombinedChildId(long groupId, long childId) {
        return this.mWrappedAdapter.getCombinedChildId(groupId, childId);
    }

    public boolean isGroupExpanded(int groupPosition) {
        Boolean expanded = this.mGroupExpandedMap.get(groupPosition);
        return expanded != null ? expanded : false;
    }
}

