/*
 * Decompiled with CFR 0.152.
 */
package com.diegocarloslima.fgelv.lib;

import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtils {
    private static final String TAG = ReflectionUtils.class.getName();

    public static Object getFieldValue(Class<?> fieldClass, String fieldName, Object instance) {
        try {
            Field field = fieldClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    public static void setFieldValue(Class<?> fieldClass, String fieldName, Object instance, Object value) {
        try {
            Field field = fieldClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    public static Object invokeMethod(Class<?> methodClass, String methodName, Class<?>[] parameters, Object instance, Object ... arguments) {
        try {
            Method method = methodClass.getDeclaredMethod(methodName, parameters);
            method.setAccessible(true);
            return method.invoke(instance, arguments);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            return null;
        }
    }
}

