/*
 * Decompiled with CFR 0.152.
 */
package com.diegocarloslima.fgelv.lib;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import com.diegocarloslima.fgelv.lib.R;
import com.diegocarloslima.fgelv.lib.ReflectionUtils;
import com.diegocarloslima.fgelv.lib.WrapperExpandableListAdapter;

public class FloatingGroupExpandableListView
extends ExpandableListView {
    private static final int[] EMPTY_STATE_SET = new int[0];
    private static final int[] GROUP_EXPANDED_STATE_SET = new int[]{16842920};
    private static final int[] GROUP_EMPTY_STATE_SET = new int[]{16842921};
    private static final int[] GROUP_EXPANDED_EMPTY_STATE_SET = new int[]{16842920, 16842921};
    private static final int[][] GROUP_STATE_SETS = new int[][]{EMPTY_STATE_SET, GROUP_EXPANDED_STATE_SET, GROUP_EMPTY_STATE_SET, GROUP_EXPANDED_EMPTY_STATE_SET};
    private WrapperExpandableListAdapter mAdapter;
    private DataSetObserver mDataSetObserver;
    private AbsListView.OnScrollListener mOnScrollListener;
    private boolean mFloatingGroupEnabled = true;
    private View mFloatingGroupView;
    private int mFloatingGroupPosition;
    private int mFloatingGroupScrollY;
    private OnScrollFloatingGroupListener mOnScrollFloatingGroupListener;
    private ExpandableListView.OnGroupClickListener mOnGroupClickListener;
    private int mWidthMeasureSpec;
    private Object mViewAttachInfo;
    private boolean mHandledByOnInterceptTouchEvent;
    private boolean mHandledByOnTouchEvent;
    private Runnable mOnClickAction;
    private GestureDetector mGestureDetector;
    private boolean mSelectorEnabled;
    private boolean mShouldPositionSelector;
    private boolean mDrawSelectorOnTop;
    private Drawable mSelector;
    private int mSelectorPosition;
    private final Rect mSelectorRect = new Rect();
    private Runnable mPositionSelectorOnTapAction;
    private Runnable mClearSelectorOnTapAction;
    private final Rect mIndicatorRect = new Rect();

    public FloatingGroupExpandableListView(Context context) {
        super(context);
        this.init();
    }

    public FloatingGroupExpandableListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FloatingGroupExpandableListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        super.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (FloatingGroupExpandableListView.this.mOnScrollListener != null) {
                    FloatingGroupExpandableListView.this.mOnScrollListener.onScrollStateChanged(view, scrollState);
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (FloatingGroupExpandableListView.this.mOnScrollListener != null) {
                    FloatingGroupExpandableListView.this.mOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
                }
                if (FloatingGroupExpandableListView.this.mFloatingGroupEnabled && FloatingGroupExpandableListView.this.mAdapter != null && FloatingGroupExpandableListView.this.mAdapter.getGroupCount() > 0 && visibleItemCount > 0) {
                    FloatingGroupExpandableListView.this.createFloatingGroupView(firstVisibleItem);
                }
            }
        });
        this.mOnClickAction = new Runnable(){

            @Override
            public void run() {
                boolean allowSelection = true;
                if (FloatingGroupExpandableListView.this.mOnGroupClickListener != null) {
                    boolean bl = allowSelection = !FloatingGroupExpandableListView.this.mOnGroupClickListener.onGroupClick((ExpandableListView)FloatingGroupExpandableListView.this, FloatingGroupExpandableListView.this.mFloatingGroupView, FloatingGroupExpandableListView.this.mFloatingGroupPosition, FloatingGroupExpandableListView.this.mAdapter.getGroupId(FloatingGroupExpandableListView.this.mFloatingGroupPosition));
                }
                if (allowSelection) {
                    if (FloatingGroupExpandableListView.this.mAdapter.isGroupExpanded(FloatingGroupExpandableListView.this.mFloatingGroupPosition)) {
                        FloatingGroupExpandableListView.this.collapseGroup(FloatingGroupExpandableListView.this.mFloatingGroupPosition);
                    } else {
                        FloatingGroupExpandableListView.this.expandGroup(FloatingGroupExpandableListView.this.mFloatingGroupPosition);
                    }
                    FloatingGroupExpandableListView.this.setSelectedGroup(FloatingGroupExpandableListView.this.mFloatingGroupPosition);
                }
            }
        };
        this.mPositionSelectorOnTapAction = new Runnable(){

            @Override
            public void run() {
                FloatingGroupExpandableListView.this.positionSelectorOnFloatingGroup();
                FloatingGroupExpandableListView.this.setPressed(true);
                if (FloatingGroupExpandableListView.this.mFloatingGroupView != null) {
                    FloatingGroupExpandableListView.this.mFloatingGroupView.setPressed(true);
                }
            }
        };
        this.mClearSelectorOnTapAction = new Runnable(){

            @Override
            public void run() {
                FloatingGroupExpandableListView.this.setPressed(false);
                if (FloatingGroupExpandableListView.this.mFloatingGroupView != null) {
                    FloatingGroupExpandableListView.this.mFloatingGroupView.setPressed(false);
                }
                FloatingGroupExpandableListView.this.invalidate();
            }
        };
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent e) {
                if (FloatingGroupExpandableListView.this.mFloatingGroupView != null && !FloatingGroupExpandableListView.this.mFloatingGroupView.isLongClickable()) {
                    ExpandableListView.ExpandableListContextMenuInfo contextMenuInfo = new ExpandableListView.ExpandableListContextMenuInfo(FloatingGroupExpandableListView.this.mFloatingGroupView, ExpandableListView.getPackedPositionForGroup((int)FloatingGroupExpandableListView.this.mFloatingGroupPosition), FloatingGroupExpandableListView.this.mAdapter.getGroupId(FloatingGroupExpandableListView.this.mFloatingGroupPosition));
                    ReflectionUtils.setFieldValue(AbsListView.class, "mContextMenuInfo", (Object)FloatingGroupExpandableListView.this, contextMenuInfo);
                    FloatingGroupExpandableListView.this.showContextMenu();
                }
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
            this.mDataSetObserver = null;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidthMeasureSpec = widthMeasureSpec;
    }

    protected void dispatchDraw(Canvas canvas) {
        this.mSelectorPosition = Build.VERSION.SDK_INT >= 14 ? ((Integer)ReflectionUtils.getFieldValue(AbsListView.class, "mSelectorPosition", (Object)this)).intValue() : ((Integer)ReflectionUtils.getFieldValue(AbsListView.class, "mMotionPosition", (Object)this)).intValue();
        this.mSelectorRect.set((Rect)ReflectionUtils.getFieldValue(AbsListView.class, "mSelectorRect", (Object)this));
        if (!this.mDrawSelectorOnTop) {
            this.drawDefaultSelector(canvas);
        }
        super.dispatchDraw(canvas);
        if (this.mFloatingGroupEnabled && this.mFloatingGroupView != null) {
            if (!this.mDrawSelectorOnTop) {
                this.drawFloatingGroupSelector(canvas);
            }
            canvas.save();
            canvas.clipRect(this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
            if (this.mFloatingGroupView.getVisibility() == 0) {
                this.drawChild(canvas, this.mFloatingGroupView, this.getDrawingTime());
            }
            this.drawFloatingGroupIndicator(canvas);
            canvas.restore();
            if (this.mDrawSelectorOnTop) {
                this.drawDefaultSelector(canvas);
                this.drawFloatingGroupSelector(canvas);
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        if (action == 0 || action == 3) {
            this.mHandledByOnInterceptTouchEvent = false;
            this.mHandledByOnTouchEvent = false;
            this.mShouldPositionSelector = false;
        }
        if (!this.mHandledByOnInterceptTouchEvent && !this.mHandledByOnTouchEvent && this.mFloatingGroupView != null) {
            int[] screenCoords = new int[2];
            this.getLocationInWindow(screenCoords);
            RectF floatingGroupRect = new RectF((float)(screenCoords[0] + this.mFloatingGroupView.getLeft()), (float)(screenCoords[1] + this.mFloatingGroupView.getTop()), (float)(screenCoords[0] + this.mFloatingGroupView.getRight()), (float)(screenCoords[1] + this.mFloatingGroupView.getBottom()));
            if (floatingGroupRect.contains(ev.getRawX(), ev.getRawY())) {
                if (this.mSelectorEnabled) {
                    switch (action) {
                        case 0: {
                            this.mShouldPositionSelector = true;
                            this.removeCallbacks(this.mPositionSelectorOnTapAction);
                            this.postDelayed(this.mPositionSelectorOnTapAction, ViewConfiguration.getTapTimeout());
                            break;
                        }
                        case 1: {
                            this.positionSelectorOnFloatingGroup();
                            this.setPressed(true);
                            if (this.mFloatingGroupView != null) {
                                this.mFloatingGroupView.setPressed(true);
                            }
                            this.removeCallbacks(this.mClearSelectorOnTapAction);
                            this.postDelayed(this.mClearSelectorOnTapAction, ViewConfiguration.getPressedStateDuration());
                        }
                    }
                }
                if (this.mFloatingGroupView.dispatchTouchEvent(ev)) {
                    this.mGestureDetector.onTouchEvent(ev);
                    this.onInterceptTouchEvent(ev);
                    return true;
                }
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.mHandledByOnInterceptTouchEvent = super.onInterceptTouchEvent(ev);
        return this.mHandledByOnInterceptTouchEvent;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.mHandledByOnTouchEvent = super.onTouchEvent(ev);
        return this.mHandledByOnTouchEvent;
    }

    public void setSelector(Drawable sel) {
        super.setSelector((Drawable)new ColorDrawable(0));
        if (this.mSelector != null) {
            this.mSelector.setCallback(null);
            this.unscheduleDrawable(this.mSelector);
        }
        this.mSelector = sel;
        this.mSelector.setCallback((Drawable.Callback)this);
    }

    public void setDrawSelectorOnTop(boolean onTop) {
        super.setDrawSelectorOnTop(onTop);
        this.mDrawSelectorOnTop = onTop;
    }

    public void setAdapter(ExpandableListAdapter adapter) {
        if (!(adapter instanceof WrapperExpandableListAdapter)) {
            throw new IllegalArgumentException("The adapter must be an instance of WrapperExpandableListAdapter");
        }
        this.setAdapter((WrapperExpandableListAdapter)adapter);
    }

    public void setAdapter(WrapperExpandableListAdapter adapter) {
        super.setAdapter((ExpandableListAdapter)adapter);
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
            this.mDataSetObserver = null;
        }
        this.mAdapter = adapter;
        if (this.mAdapter != null && this.mDataSetObserver == null) {
            this.mDataSetObserver = new DataSetObserver(){

                public void onChanged() {
                    FloatingGroupExpandableListView.this.mFloatingGroupView = null;
                }

                public void onInvalidated() {
                    FloatingGroupExpandableListView.this.mFloatingGroupView = null;
                }
            };
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
        }
    }

    public void setOnScrollListener(AbsListView.OnScrollListener listener) {
        this.mOnScrollListener = listener;
    }

    public void setOnGroupClickListener(ExpandableListView.OnGroupClickListener onGroupClickListener) {
        super.setOnGroupClickListener(onGroupClickListener);
        this.mOnGroupClickListener = onGroupClickListener;
    }

    public void setFloatingGroupEnabled(boolean floatingGroupEnabled) {
        this.mFloatingGroupEnabled = floatingGroupEnabled;
    }

    public void setOnScrollFloatingGroupListener(OnScrollFloatingGroupListener listener) {
        this.mOnScrollFloatingGroupListener = listener;
    }

    private void createFloatingGroupView(int position) {
        View nextGroupView;
        this.mFloatingGroupView = null;
        this.mFloatingGroupPosition = FloatingGroupExpandableListView.getPackedPositionGroup((long)this.getExpandableListPosition(position));
        for (int i = 0; i < this.getChildCount(); ++i) {
            boolean changedVisibility;
            View child = this.getChildAt(i);
            Object tag = child.getTag(R.id.fgelv_tag_changed_visibility);
            if (!(tag instanceof Boolean) || !(changedVisibility = ((Boolean)tag).booleanValue())) continue;
            child.setVisibility(0);
            child.setTag(R.id.fgelv_tag_changed_visibility, null);
        }
        if (!this.mFloatingGroupEnabled) {
            return;
        }
        int floatingGroupFlatPosition = this.getFlatListPosition(FloatingGroupExpandableListView.getPackedPositionForGroup((int)this.mFloatingGroupPosition));
        int floatingGroupListPosition = floatingGroupFlatPosition - position;
        if (floatingGroupListPosition >= 0 && floatingGroupListPosition < this.getChildCount()) {
            View currentGroupView = this.getChildAt(floatingGroupListPosition);
            if (currentGroupView.getTop() >= this.getPaddingTop()) {
                return;
            }
            if (currentGroupView.getTop() < this.getPaddingTop() && currentGroupView.getVisibility() == 0) {
                currentGroupView.setVisibility(4);
                currentGroupView.setTag(R.id.fgelv_tag_changed_visibility, (Object)true);
            }
        }
        if (this.mFloatingGroupPosition >= 0) {
            this.mFloatingGroupView = this.mAdapter.getGroupView(this.mFloatingGroupPosition, this.mAdapter.isGroupExpanded(this.mFloatingGroupPosition), this.mFloatingGroupView, (ViewGroup)this);
            if (!this.mFloatingGroupView.isClickable()) {
                this.mSelectorEnabled = true;
                this.mFloatingGroupView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        FloatingGroupExpandableListView.this.postDelayed(FloatingGroupExpandableListView.this.mOnClickAction, ViewConfiguration.getPressedStateDuration());
                    }
                });
            } else {
                this.mSelectorEnabled = false;
            }
            this.loadAttachInfo();
            this.setAttachInfo(this.mFloatingGroupView);
        }
        if (this.mFloatingGroupView == null) {
            return;
        }
        AbsListView.LayoutParams params = (AbsListView.LayoutParams)this.mFloatingGroupView.getLayoutParams();
        if (params == null) {
            params = new AbsListView.LayoutParams(-1, -2, 0);
            this.mFloatingGroupView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)this.mWidthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)params.width);
        int paramsHeight = params.height;
        int childHeightSpec = paramsHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)paramsHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.mFloatingGroupView.measure(childWidthSpec, childHeightSpec);
        int floatingGroupScrollY = 0;
        int nextGroupFlatPosition = this.getFlatListPosition(FloatingGroupExpandableListView.getPackedPositionForGroup((int)(this.mFloatingGroupPosition + 1)));
        int nextGroupListPosition = nextGroupFlatPosition - position;
        if (nextGroupListPosition >= 0 && nextGroupListPosition < this.getChildCount() && (nextGroupView = this.getChildAt(nextGroupListPosition)) != null && nextGroupView.getTop() < this.getPaddingTop() + this.mFloatingGroupView.getMeasuredHeight() + this.getDividerHeight()) {
            floatingGroupScrollY = nextGroupView.getTop() - (this.getPaddingTop() + this.mFloatingGroupView.getMeasuredHeight() + this.getDividerHeight());
        }
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop() + floatingGroupScrollY;
        int right = left + this.mFloatingGroupView.getMeasuredWidth();
        int bottom = top + this.mFloatingGroupView.getMeasuredHeight();
        this.mFloatingGroupView.layout(left, top, right, bottom);
        this.mFloatingGroupScrollY = floatingGroupScrollY;
        if (this.mOnScrollFloatingGroupListener != null) {
            this.mOnScrollFloatingGroupListener.onScrollFloatingGroupListener(this.mFloatingGroupView, this.mFloatingGroupScrollY);
        }
    }

    private void loadAttachInfo() {
        if (this.mViewAttachInfo == null) {
            this.mViewAttachInfo = ReflectionUtils.getFieldValue(View.class, "mAttachInfo", (Object)this);
        }
    }

    private void setAttachInfo(View v) {
        if (v == null) {
            return;
        }
        if (this.mViewAttachInfo != null) {
            ReflectionUtils.setFieldValue(View.class, "mAttachInfo", v, this.mViewAttachInfo);
        }
        if (v instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)v;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                this.setAttachInfo(viewGroup.getChildAt(i));
            }
        }
    }

    private void positionSelectorOnFloatingGroup() {
        if (this.mShouldPositionSelector && this.mFloatingGroupView != null) {
            if (Build.VERSION.SDK_INT >= 14) {
                int floatingGroupFlatPosition = this.getFlatListPosition(FloatingGroupExpandableListView.getPackedPositionForGroup((int)this.mFloatingGroupPosition));
                ReflectionUtils.invokeMethod(AbsListView.class, "positionSelector", new Class[]{Integer.TYPE, View.class}, (Object)this, floatingGroupFlatPosition, this.mFloatingGroupView);
            } else {
                ReflectionUtils.invokeMethod(AbsListView.class, "positionSelector", new Class[]{View.class}, (Object)this, this.mFloatingGroupView);
            }
            this.invalidate();
        }
        this.mShouldPositionSelector = false;
        this.removeCallbacks(this.mPositionSelectorOnTapAction);
    }

    private void drawDefaultSelector(Canvas canvas) {
        int selectorListPosition = this.mSelectorPosition - this.getFirstVisiblePosition();
        if (selectorListPosition >= 0 && selectorListPosition < this.getChildCount() && this.mSelectorRect != null && !this.mSelectorRect.isEmpty()) {
            int floatingGroupFlatPosition = this.getFlatListPosition(FloatingGroupExpandableListView.getPackedPositionForGroup((int)this.mFloatingGroupPosition));
            if (this.mFloatingGroupView == null || this.mSelectorPosition != floatingGroupFlatPosition) {
                this.drawSelector(canvas);
            }
        }
    }

    private void drawFloatingGroupSelector(Canvas canvas) {
        int floatingGroupFlatPosition;
        if (this.mSelectorRect != null && !this.mSelectorRect.isEmpty() && this.mSelectorPosition == (floatingGroupFlatPosition = this.getFlatListPosition(FloatingGroupExpandableListView.getPackedPositionForGroup((int)this.mFloatingGroupPosition)))) {
            this.mSelectorRect.set(this.mFloatingGroupView.getLeft(), this.mFloatingGroupView.getTop(), this.mFloatingGroupView.getRight(), this.mFloatingGroupView.getBottom());
            this.drawSelector(canvas);
        }
    }

    private void drawSelector(Canvas canvas) {
        canvas.save();
        canvas.clipRect(this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
        if (this.isPressed()) {
            this.mSelector.setState(this.getDrawableState());
        } else {
            this.mSelector.setState(EMPTY_STATE_SET);
        }
        this.mSelector.setBounds(this.mSelectorRect);
        this.mSelector.draw(canvas);
        canvas.restore();
    }

    private void drawFloatingGroupIndicator(Canvas canvas) {
        Drawable groupIndicator = (Drawable)ReflectionUtils.getFieldValue(ExpandableListView.class, "mGroupIndicator", (Object)this);
        if (groupIndicator != null) {
            int stateSetIndex = (this.mAdapter.isGroupExpanded(this.mFloatingGroupPosition) ? 1 : 0) | (this.mAdapter.getChildrenCount(this.mFloatingGroupPosition) > 0 ? 2 : 0);
            groupIndicator.setState(GROUP_STATE_SETS[stateSetIndex]);
            int indicatorLeft = (Integer)ReflectionUtils.getFieldValue(ExpandableListView.class, "mIndicatorLeft", (Object)this);
            int indicatorRight = (Integer)ReflectionUtils.getFieldValue(ExpandableListView.class, "mIndicatorRight", (Object)this);
            if (Build.VERSION.SDK_INT >= 14) {
                this.mIndicatorRect.set(indicatorLeft + this.getPaddingLeft(), this.mFloatingGroupView.getTop(), indicatorRight + this.getPaddingLeft(), this.mFloatingGroupView.getBottom());
            } else {
                this.mIndicatorRect.set(indicatorLeft, this.mFloatingGroupView.getTop(), indicatorRight, this.mFloatingGroupView.getBottom());
            }
            groupIndicator.setBounds(this.mIndicatorRect);
            groupIndicator.draw(canvas);
        }
    }

    public static interface OnScrollFloatingGroupListener {
        public void onScrollFloatingGroupListener(View var1, int var2);
    }
}

