/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.booster.transform.asm;

import com.didiglobal.booster.annotations.Priority;
import com.didiglobal.booster.kotlinx.IoKt;
import com.didiglobal.booster.transform.TransformContext;
import com.didiglobal.booster.transform.Transformer;
import com.didiglobal.booster.transform.asm.ClassNodeKt;
import com.didiglobal.booster.transform.asm.ClassTransformer;
import com.didiglobal.booster.transform.util.HistogramDiffKt;
import com.google.auto.service.AutoService;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J-\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b*\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/didiglobal/booster/transform/asm/AsmTransformer;", "Lcom/didiglobal/booster/transform/Transformer;", "()V", "classLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/ClassLoader;)V", "transformers", "", "Lcom/didiglobal/booster/transform/asm/ClassTransformer;", "(Ljava/lang/Iterable;Ljava/lang/ClassLoader;)V", "durations", "", "Ljava/time/Duration;", "threadMxBean", "Ljava/lang/management/ThreadMXBean;", "kotlin.jvm.PlatformType", "getTransformers$booster_transform_asm", "()Ljava/lang/Iterable;", "onPostTransform", "", "context", "Lcom/didiglobal/booster/transform/TransformContext;", "onPreTransform", "transform", "", "bytecode", "sumCpuTime", "R", "transformer", "action", "Lkotlin/Function0;", "(Ljava/lang/management/ThreadMXBean;Lcom/didiglobal/booster/transform/asm/ClassTransformer;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "booster-transform-asm"})
@AutoService(value={Transformer.class})
public final class AsmTransformer
implements Transformer {
    private final ThreadMXBean threadMxBean;
    @NotNull
    private final Map<ClassTransformer, Duration> durations;
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final Iterable<ClassTransformer> transformers;

    @NotNull
    public final Iterable<ClassTransformer> getTransformers$booster_transform_asm() {
        return this.transformers;
    }

    public AsmTransformer() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"currentThread().contextClassLoader");
        this(classLoader);
    }

    public AsmTransformer(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        ServiceLoader<ClassTransformer> serviceLoader = ServiceLoader.load(ClassTransformer.class, classLoader);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(ClassTransformer::class.java, classLoader)");
        Iterable $this$sortedBy$iv = serviceLoader;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        this(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                int n;
                boolean bl = false;
                ClassTransformer it = (ClassTransformer)a;
                boolean bl2 = false;
                Priority priority = it.getClass().getAnnotation(Priority.class);
                int n2 = priority == null ? 0 : (n = priority.value());
                it = (ClassTransformer)b;
                Comparable comparable = Integer.valueOf(n2);
                bl2 = false;
                priority = it.getClass().getAnnotation(Priority.class);
                Integer n3 = priority == null ? 0 : (n = priority.value());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n3);
            }
        }), classLoader);
    }

    public /* synthetic */ AsmTransformer(ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"currentThread().contextClassLoader");
            classLoader = classLoader2;
        }
        this(classLoader);
    }

    public AsmTransformer(@NotNull Iterable<? extends ClassTransformer> transformers, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(transformers, (String)"transformers");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.threadMxBean = ManagementFactory.getThreadMXBean();
        boolean bl = false;
        this.durations = new LinkedHashMap();
        this.classLoader = classLoader;
        this.transformers = transformers;
    }

    public /* synthetic */ AsmTransformer(Iterable iterable, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"currentThread().contextClassLoader");
            classLoader = classLoader2;
        }
        this(iterable, classLoader);
    }

    public void onPreTransform(@NotNull TransformContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable<ClassTransformer> $this$forEach$iv = this.transformers;
        boolean $i$f$forEach = false;
        Iterator<ClassTransformer> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            ClassTransformer element$iv;
            ClassTransformer transformer = element$iv = iterator.next();
            boolean bl = false;
            ThreadMXBean threadMXBean = this.threadMxBean;
            Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"this.threadMxBean");
            this.sumCpuTime(threadMXBean, transformer, (Function0)new Function0<Unit>(transformer, context){
                final /* synthetic */ ClassTransformer $transformer;
                final /* synthetic */ TransformContext $context;
                {
                    this.$transformer = $transformer;
                    this.$context = $context;
                    super(0);
                }

                public final void invoke() {
                    this.$transformer.onPreTransform(this.$context);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public byte[] transform(@NotNull TransformContext context, @NotNull byte[] bytecode) {
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bytecode, (String)"bytecode");
        boolean diffEnabled = (Boolean)context.getProperty("booster.transform.diff", (Object)false);
        ClassWriter classWriter = new ClassWriter(1);
        boolean bl = false;
        boolean bl2 = false;
        ClassWriter writer = classWriter;
        boolean bl3 = false;
        Iterable<ClassTransformer> iterable = this.getTransformers$booster_transform_asm();
        ClassNode classNode = new ClassNode();
        boolean bl4 = false;
        boolean bl5 = false;
        ClassNode klass = classNode;
        boolean bl6 = false;
        new ClassReader(bytecode).accept((ClassVisitor)klass, 0);
        boolean $i$f$fold = false;
        ClassNode accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void transformer;
            ClassTransformer classTransformer = (ClassTransformer)element$iv;
            void a = accumulator$iv;
            boolean bl7 = false;
            ThreadMXBean threadMXBean = this.threadMxBean;
            Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"this.threadMxBean");
            accumulator$iv = (ClassNode)this.sumCpuTime(threadMXBean, (ClassTransformer)transformer, (Function0)new Function0<ClassNode>(diffEnabled, (ClassNode)a, (ClassTransformer)transformer, context){
                final /* synthetic */ boolean $diffEnabled;
                final /* synthetic */ ClassNode $a;
                final /* synthetic */ ClassTransformer $transformer;
                final /* synthetic */ TransformContext $context;
                {
                    this.$diffEnabled = $diffEnabled;
                    this.$a = $a;
                    this.$transformer = $transformer;
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final ClassNode invoke() {
                    ClassNode classNode;
                    if (this.$diffEnabled) {
                        String left = ClassNodeKt.textify(this.$a);
                        ClassNode classNode2 = this.$transformer.transform(this.$context, this.$a);
                        ClassTransformer classTransformer = this.$transformer;
                        TransformContext transformContext = this.$context;
                        ClassNode classNode3 = this.$a;
                        boolean bl = false;
                        boolean bl2 = false;
                        ClassNode b = classNode2;
                        boolean bl3 = false;
                        String right = ClassNodeKt.textify(b);
                        String diff = Intrinsics.areEqual((Object)left, (Object)right) ? "" : HistogramDiffKt.diff((String)left, (String)right);
                        CharSequence charSequence = diff;
                        boolean bl4 = false;
                        if (!(charSequence.length() == 0) && !StringsKt.isBlank((CharSequence)diff)) {
                            FilesKt.writeText$default((File)IoKt.touch((File)classTransformer.getReport(transformContext, Intrinsics.stringPlus((String)ClassNodeKt.getClassName(classNode3), (Object)".diff"))), (String)diff, null, (int)2, null);
                        }
                        classNode = classNode2;
                    } else {
                        classNode = this.$transformer.transform(this.$context, this.$a);
                    }
                    return classNode;
                }
            });
        }
        accumulator$iv.accept((ClassVisitor)writer);
        byte[] byArray = classWriter.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ClassWriter(ClassWriter.\u2026)\n        }.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public void onPostTransform(@NotNull TransformContext context) {
        Map.Entry<ClassTransformer, Duration> it;
        void $this$mapTo$iv$iv;
        Object transformer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable<ClassTransformer> $this$forEach$iv = this.transformers;
        boolean $i$f$forEach22 = false;
        for (ClassTransformer element$iv : $this$forEach$iv) {
            transformer = element$iv;
            boolean bl = false;
            ThreadMXBean threadMXBean = this.threadMxBean;
            Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"this.threadMxBean");
            this.sumCpuTime(threadMXBean, (ClassTransformer)transformer, (Function0)new Function0<Unit>((ClassTransformer)transformer, context){
                final /* synthetic */ ClassTransformer $transformer;
                final /* synthetic */ TransformContext $context;
                {
                    this.$transformer = $transformer;
                    this.$context = $context;
                    super(0);
                }

                public final void invoke() {
                    this.$transformer.onPostTransform(this.$context);
                }
            });
        }
        Iterable $this$map$iv = this.durations.keySet();
        boolean $i$f$map = false;
        transformer = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ClassTransformer classTransformer = (ClassTransformer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getClass().getName().length();
            collection.add(n);
        }
        Integer $i$f$forEach22 = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        int w1 = $i$f$forEach22 == null ? 20 : $i$f$forEach22;
        Map<ClassTransformer, Duration> $this$forEach$iv2 = this.durations;
        boolean $i$f$forEach = false;
        Map<ClassTransformer, Duration> map = $this$forEach$iv2;
        boolean bl = false;
        Iterator<Map.Entry<ClassTransformer, Duration>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ClassTransformer, Duration> element$iv;
            Map.Entry<ClassTransformer, Duration> $dstr$transformer$ns = element$iv = iterator.next();
            boolean bl2 = false;
            it = $dstr$transformer$ns;
            boolean bl3 = false;
            ClassTransformer transformer2 = it.getKey();
            Object object = $dstr$transformer$ns;
            boolean bl4 = false;
            Duration ns = object.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            object = transformer2.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"transformer.javaClass.name");
            object = stringBuilder.append(StringsKt.padEnd$default((String)object, (int)(w1 + 1), (char)'\u0000', (int)2, null)).append(": ").append(ns.toMillis()).append(" ms").toString();
            bl4 = false;
            System.out.println(object);
        }
    }

    private final <R> R sumCpuTime(ThreadMXBean $this$sumCpuTime, ClassTransformer transformer, Function0<? extends R> action) {
        Duration duration;
        long ct0 = $this$sumCpuTime.getCurrentThreadCpuTime();
        Object result = action.invoke();
        long ct1 = $this$sumCpuTime.getCurrentThreadCpuTime();
        Map<ClassTransformer, Duration> map = this.durations;
        Map<ClassTransformer, Duration> $this$getOrPut$iv = this.durations;
        boolean $i$f$getOrPut = false;
        Duration value$iv = $this$getOrPut$iv.get(transformer);
        if (value$iv == null) {
            boolean bl = false;
            Duration duration2 = Duration.ofNanos(0L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofNanos(0)");
            Duration answer$iv = duration2;
            $this$getOrPut$iv.put(transformer, answer$iv);
            duration = answer$iv;
        } else {
            duration = value$iv;
        }
        Duration duration3 = duration.plus(Duration.ofNanos(ct1 - ct0));
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"durations.getOrPut(trans\u2026ration.ofNanos(ct1 - ct0)");
        boolean bl = false;
        map.put(transformer, duration3);
        return (R)result;
    }
}

