/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.okhttp_api;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

public class ByteCountBufferedSinkV4
implements BufferedSink {
    private final long mByteCount;
    private final Sink mOriginalSink;
    private final BufferedSink mDelegate;

    public ByteCountBufferedSinkV4(Sink sink, long byteCount) {
        this.mOriginalSink = sink;
        this.mDelegate = Okio.buffer((Sink)this.mOriginalSink);
        this.mByteCount = byteCount;
    }

    public long writeAll(Source source) throws IOException {
        long readCount;
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        long totalBytesRead = 0L;
        while ((readCount = source.read(this.buffer(), this.mByteCount)) != -1L) {
            totalBytesRead += readCount;
            this.emitCompleteSegments();
        }
        return totalBytesRead;
    }

    public BufferedSink write(byte[] source, int offset, int byteCount) throws IOException {
        if (!this.isOpen()) {
            throw new IllegalStateException("closed");
        }
        long count = (long)Math.ceil((double)source.length / (double)this.mByteCount);
        int i = 0;
        while ((long)i < count) {
            long newOffset = (long)i * this.mByteCount;
            long writeByteCount = Math.min(this.mByteCount, (long)source.length - newOffset);
            this.buffer().write(source, (int)newOffset, (int)writeByteCount);
            this.emitCompleteSegments();
            ++i;
        }
        return this;
    }

    public BufferedSink emitCompleteSegments() throws IOException {
        Buffer buffer = this.buffer();
        this.mOriginalSink.write(buffer, buffer.size());
        return this;
    }

    public Buffer buffer() {
        return this.mDelegate.buffer();
    }

    public BufferedSink write(ByteString byteString) throws IOException {
        return this.mDelegate.write(byteString);
    }

    public BufferedSink write(byte[] source) throws IOException {
        return this.mDelegate.write(source);
    }

    public BufferedSink write(Source source, long byteCount) throws IOException {
        return this.mDelegate.write(source, byteCount);
    }

    public BufferedSink writeUtf8(String string) throws IOException {
        return this.mDelegate.writeUtf8(string);
    }

    public BufferedSink writeUtf8(String string, int beginIndex, int endIndex) throws IOException {
        return this.mDelegate.writeUtf8(string, beginIndex, endIndex);
    }

    public BufferedSink writeUtf8CodePoint(int codePoint) throws IOException {
        return this.mDelegate.writeUtf8CodePoint(codePoint);
    }

    public BufferedSink writeString(String string, Charset charset) throws IOException {
        return this.mDelegate.writeString(string, charset);
    }

    public BufferedSink writeString(String string, int beginIndex, int endIndex, Charset charset) throws IOException {
        return this.mDelegate.writeString(string, beginIndex, endIndex, charset);
    }

    public BufferedSink writeByte(int b) throws IOException {
        return this.mDelegate.writeByte(b);
    }

    public BufferedSink writeShort(int s) throws IOException {
        return this.mDelegate.writeShort(s);
    }

    public BufferedSink writeShortLe(int s) throws IOException {
        return this.mDelegate.writeShortLe(s);
    }

    public BufferedSink writeInt(int i) throws IOException {
        return this.mDelegate.writeInt(i);
    }

    public BufferedSink writeIntLe(int i) throws IOException {
        return this.mDelegate.writeIntLe(i);
    }

    public BufferedSink writeLong(long v) throws IOException {
        return this.mDelegate.writeLong(v);
    }

    public BufferedSink writeLongLe(long v) throws IOException {
        return this.mDelegate.writeLongLe(v);
    }

    public BufferedSink writeDecimalLong(long v) throws IOException {
        return this.mDelegate.writeDecimalLong(v);
    }

    public BufferedSink writeHexadecimalUnsignedLong(long v) throws IOException {
        return this.mDelegate.writeHexadecimalUnsignedLong(v);
    }

    public void flush() throws IOException {
        this.mDelegate.flush();
    }

    public BufferedSink emit() throws IOException {
        return this.mDelegate.emit();
    }

    public OutputStream outputStream() {
        return this.mDelegate.outputStream();
    }

    public int write(ByteBuffer src) throws IOException {
        return this.mDelegate.write(src);
    }

    public boolean isOpen() {
        return this.mDelegate.isOpen();
    }

    public void write(Buffer source, long byteCount) throws IOException {
        this.mDelegate.write(source, byteCount);
    }

    public Timeout timeout() {
        return this.mDelegate.timeout();
    }

    public void close() throws IOException {
        this.mDelegate.close();
    }

    @NotNull
    public Buffer getBuffer() {
        return this.mDelegate.getBuffer();
    }

    @NotNull
    public BufferedSink write(@NotNull ByteString byteString, int i, int i1) throws IOException {
        return this.mDelegate.write(byteString, i, i1);
    }
}

