/*
 * Decompiled with CFR 0.152.
 */
package com.cgutman.adblib;

import com.cgutman.adblib.AdbBase64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class AdbCrypto {
    private KeyPair keyPair;
    private AdbBase64 base64;
    public static final int KEY_LENGTH_BITS = 2048;
    public static final int KEY_LENGTH_BYTES = 256;
    public static final int KEY_LENGTH_WORDS = 64;
    public static final int[] SIGNATURE_PADDING_AS_INT;
    public static byte[] SIGNATURE_PADDING;

    static {
        int[] nArray = new int[236];
        nArray[1] = 1;
        nArray[2] = 255;
        nArray[3] = 255;
        nArray[4] = 255;
        nArray[5] = 255;
        nArray[6] = 255;
        nArray[7] = 255;
        nArray[8] = 255;
        nArray[9] = 255;
        nArray[10] = 255;
        nArray[11] = 255;
        nArray[12] = 255;
        nArray[13] = 255;
        nArray[14] = 255;
        nArray[15] = 255;
        nArray[16] = 255;
        nArray[17] = 255;
        nArray[18] = 255;
        nArray[19] = 255;
        nArray[20] = 255;
        nArray[21] = 255;
        nArray[22] = 255;
        nArray[23] = 255;
        nArray[24] = 255;
        nArray[25] = 255;
        nArray[26] = 255;
        nArray[27] = 255;
        nArray[28] = 255;
        nArray[29] = 255;
        nArray[30] = 255;
        nArray[31] = 255;
        nArray[32] = 255;
        nArray[33] = 255;
        nArray[34] = 255;
        nArray[35] = 255;
        nArray[36] = 255;
        nArray[37] = 255;
        nArray[38] = 255;
        nArray[39] = 255;
        nArray[40] = 255;
        nArray[41] = 255;
        nArray[42] = 255;
        nArray[43] = 255;
        nArray[44] = 255;
        nArray[45] = 255;
        nArray[46] = 255;
        nArray[47] = 255;
        nArray[48] = 255;
        nArray[49] = 255;
        nArray[50] = 255;
        nArray[51] = 255;
        nArray[52] = 255;
        nArray[53] = 255;
        nArray[54] = 255;
        nArray[55] = 255;
        nArray[56] = 255;
        nArray[57] = 255;
        nArray[58] = 255;
        nArray[59] = 255;
        nArray[60] = 255;
        nArray[61] = 255;
        nArray[62] = 255;
        nArray[63] = 255;
        nArray[64] = 255;
        nArray[65] = 255;
        nArray[66] = 255;
        nArray[67] = 255;
        nArray[68] = 255;
        nArray[69] = 255;
        nArray[70] = 255;
        nArray[71] = 255;
        nArray[72] = 255;
        nArray[73] = 255;
        nArray[74] = 255;
        nArray[75] = 255;
        nArray[76] = 255;
        nArray[77] = 255;
        nArray[78] = 255;
        nArray[79] = 255;
        nArray[80] = 255;
        nArray[81] = 255;
        nArray[82] = 255;
        nArray[83] = 255;
        nArray[84] = 255;
        nArray[85] = 255;
        nArray[86] = 255;
        nArray[87] = 255;
        nArray[88] = 255;
        nArray[89] = 255;
        nArray[90] = 255;
        nArray[91] = 255;
        nArray[92] = 255;
        nArray[93] = 255;
        nArray[94] = 255;
        nArray[95] = 255;
        nArray[96] = 255;
        nArray[97] = 255;
        nArray[98] = 255;
        nArray[99] = 255;
        nArray[100] = 255;
        nArray[101] = 255;
        nArray[102] = 255;
        nArray[103] = 255;
        nArray[104] = 255;
        nArray[105] = 255;
        nArray[106] = 255;
        nArray[107] = 255;
        nArray[108] = 255;
        nArray[109] = 255;
        nArray[110] = 255;
        nArray[111] = 255;
        nArray[112] = 255;
        nArray[113] = 255;
        nArray[114] = 255;
        nArray[115] = 255;
        nArray[116] = 255;
        nArray[117] = 255;
        nArray[118] = 255;
        nArray[119] = 255;
        nArray[120] = 255;
        nArray[121] = 255;
        nArray[122] = 255;
        nArray[123] = 255;
        nArray[124] = 255;
        nArray[125] = 255;
        nArray[126] = 255;
        nArray[127] = 255;
        nArray[128] = 255;
        nArray[129] = 255;
        nArray[130] = 255;
        nArray[131] = 255;
        nArray[132] = 255;
        nArray[133] = 255;
        nArray[134] = 255;
        nArray[135] = 255;
        nArray[136] = 255;
        nArray[137] = 255;
        nArray[138] = 255;
        nArray[139] = 255;
        nArray[140] = 255;
        nArray[141] = 255;
        nArray[142] = 255;
        nArray[143] = 255;
        nArray[144] = 255;
        nArray[145] = 255;
        nArray[146] = 255;
        nArray[147] = 255;
        nArray[148] = 255;
        nArray[149] = 255;
        nArray[150] = 255;
        nArray[151] = 255;
        nArray[152] = 255;
        nArray[153] = 255;
        nArray[154] = 255;
        nArray[155] = 255;
        nArray[156] = 255;
        nArray[157] = 255;
        nArray[158] = 255;
        nArray[159] = 255;
        nArray[160] = 255;
        nArray[161] = 255;
        nArray[162] = 255;
        nArray[163] = 255;
        nArray[164] = 255;
        nArray[165] = 255;
        nArray[166] = 255;
        nArray[167] = 255;
        nArray[168] = 255;
        nArray[169] = 255;
        nArray[170] = 255;
        nArray[171] = 255;
        nArray[172] = 255;
        nArray[173] = 255;
        nArray[174] = 255;
        nArray[175] = 255;
        nArray[176] = 255;
        nArray[177] = 255;
        nArray[178] = 255;
        nArray[179] = 255;
        nArray[180] = 255;
        nArray[181] = 255;
        nArray[182] = 255;
        nArray[183] = 255;
        nArray[184] = 255;
        nArray[185] = 255;
        nArray[186] = 255;
        nArray[187] = 255;
        nArray[188] = 255;
        nArray[189] = 255;
        nArray[190] = 255;
        nArray[191] = 255;
        nArray[192] = 255;
        nArray[193] = 255;
        nArray[194] = 255;
        nArray[195] = 255;
        nArray[196] = 255;
        nArray[197] = 255;
        nArray[198] = 255;
        nArray[199] = 255;
        nArray[200] = 255;
        nArray[201] = 255;
        nArray[202] = 255;
        nArray[203] = 255;
        nArray[204] = 255;
        nArray[205] = 255;
        nArray[206] = 255;
        nArray[207] = 255;
        nArray[208] = 255;
        nArray[209] = 255;
        nArray[210] = 255;
        nArray[211] = 255;
        nArray[212] = 255;
        nArray[213] = 255;
        nArray[214] = 255;
        nArray[215] = 255;
        nArray[216] = 255;
        nArray[217] = 255;
        nArray[218] = 255;
        nArray[219] = 255;
        nArray[221] = 48;
        nArray[222] = 33;
        nArray[223] = 48;
        nArray[224] = 9;
        nArray[225] = 6;
        nArray[226] = 5;
        nArray[227] = 43;
        nArray[228] = 14;
        nArray[229] = 3;
        nArray[230] = 2;
        nArray[231] = 26;
        nArray[232] = 5;
        nArray[234] = 4;
        nArray[235] = 20;
        SIGNATURE_PADDING_AS_INT = nArray;
        SIGNATURE_PADDING = new byte[SIGNATURE_PADDING_AS_INT.length];
        int i = 0;
        while (i < SIGNATURE_PADDING.length) {
            AdbCrypto.SIGNATURE_PADDING[i] = (byte)SIGNATURE_PADDING_AS_INT[i];
            ++i;
        }
    }

    private static byte[] convertRsaPublicKeyToAdbFormat(RSAPublicKey pubkey) {
        int i;
        BigInteger r32 = BigInteger.ZERO.setBit(32);
        BigInteger n = pubkey.getModulus();
        BigInteger r = BigInteger.ZERO.setBit(2048);
        BigInteger rr = r.modPow(BigInteger.valueOf(2L), n);
        BigInteger rem = n.remainder(r32);
        BigInteger n0inv = rem.modInverse(r32);
        int[] myN = new int[64];
        int[] myRr = new int[64];
        int i2 = 0;
        while (i2 < 64) {
            BigInteger[] res = rr.divideAndRemainder(r32);
            rr = res[0];
            rem = res[1];
            myRr[i2] = rem.intValue();
            res = n.divideAndRemainder(r32);
            n = res[0];
            rem = res[1];
            myN[i2] = rem.intValue();
            ++i2;
        }
        ByteBuffer bbuf = ByteBuffer.allocate(524).order(ByteOrder.LITTLE_ENDIAN);
        bbuf.putInt(64);
        bbuf.putInt(n0inv.negate().intValue());
        int[] nArray = myN;
        int n2 = myN.length;
        int n3 = 0;
        while (n3 < n2) {
            i = nArray[n3];
            bbuf.putInt(i);
            ++n3;
        }
        nArray = myRr;
        n2 = myRr.length;
        n3 = 0;
        while (n3 < n2) {
            i = nArray[n3];
            bbuf.putInt(i);
            ++n3;
        }
        bbuf.putInt(pubkey.getPublicExponent().intValue());
        return bbuf.array();
    }

    public static AdbCrypto loadAdbKeyPair(AdbBase64 base64, File privateKey, File publicKey) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        AdbCrypto crypto = new AdbCrypto();
        int privKeyLength = (int)privateKey.length();
        int pubKeyLength = (int)publicKey.length();
        byte[] privKeyBytes = new byte[privKeyLength];
        byte[] pubKeyBytes = new byte[pubKeyLength];
        FileInputStream privIn = new FileInputStream(privateKey);
        FileInputStream pubIn = new FileInputStream(publicKey);
        privIn.read(privKeyBytes);
        pubIn.read(pubKeyBytes);
        privIn.close();
        pubIn.close();
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privKeyBytes);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(pubKeyBytes);
        crypto.keyPair = new KeyPair(keyFactory.generatePublic(publicKeySpec), keyFactory.generatePrivate(privateKeySpec));
        crypto.base64 = base64;
        return crypto;
    }

    public static AdbCrypto generateAdbKeyPair(AdbBase64 base64) throws NoSuchAlgorithmException {
        AdbCrypto crypto = new AdbCrypto();
        KeyPairGenerator rsaKeyPg = KeyPairGenerator.getInstance("RSA");
        rsaKeyPg.initialize(2048);
        crypto.keyPair = rsaKeyPg.genKeyPair();
        crypto.base64 = base64;
        return crypto;
    }

    public byte[] signAdbTokenPayload(byte[] payload) throws GeneralSecurityException {
        Cipher c = Cipher.getInstance("RSA/ECB/NoPadding");
        c.init(1, this.keyPair.getPrivate());
        c.update(SIGNATURE_PADDING);
        return c.doFinal(payload);
    }

    public byte[] getAdbPublicKeyPayload() throws IOException {
        byte[] convertedKey = AdbCrypto.convertRsaPublicKeyToAdbFormat((RSAPublicKey)this.keyPair.getPublic());
        StringBuilder keyString = new StringBuilder(720);
        keyString.append(this.base64.encodeToString(convertedKey));
        keyString.append(" unknown@unknown");
        keyString.append('\u0000');
        return keyString.toString().getBytes("UTF-8");
    }

    public void saveAdbKeyPair(File privateKey, File publicKey) throws IOException {
        FileOutputStream privOut = new FileOutputStream(privateKey);
        FileOutputStream pubOut = new FileOutputStream(publicKey);
        privOut.write(this.keyPair.getPrivate().getEncoded());
        pubOut.write(this.keyPair.getPublic().getEncoded());
        privOut.close();
        pubOut.close();
    }
}

