/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.adb;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import com.cgutman.adblib.AdbBase64;
import com.cgutman.adblib.AdbConnection;
import com.cgutman.adblib.AdbCrypto;
import com.cgutman.adblib.AdbStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;

public class AdbConnector {
    private static final String TAG = "AdbConnector";
    private AdbConnection connection;
    private AdbStream stream;

    private AdbBase64 getBase64Impl() {
        return new AdbBase64(){

            public String encodeToString(byte[] data) {
                return Base64.encodeToString((byte[])data, (int)0);
            }
        };
    }

    private AdbCrypto setupCrypto(String pubKeyFile, String privKeyFile) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        File pub = new File(pubKeyFile);
        File priv = new File(privKeyFile);
        AdbCrypto c = null;
        if (pub.exists() && priv.exists()) {
            try {
                c = AdbCrypto.loadAdbKeyPair((AdbBase64)this.getBase64Impl(), (File)priv, (File)pub);
            }
            catch (Exception e) {
                c = null;
            }
        }
        if (c == null) {
            c = AdbCrypto.generateAdbKeyPair((AdbBase64)this.getBase64Impl());
            c.saveAdbKeyPair(priv, pub);
            Log.d((String)TAG, (String)"Generated new keypair");
        } else {
            Log.d((String)TAG, (String)"Loaded existing keypair");
        }
        return c;
    }

    private AdbConnection connection(Context context) throws Exception {
        String path = context.getCacheDir().getAbsolutePath();
        Log.d((String)TAG, (String)("connection path " + path));
        AdbCrypto crypto = this.setupCrypto(path + File.separatorChar + "pub.key", path + File.separatorChar + "priv.key");
        Log.e((String)TAG, (String)"Socket connecting...");
        Socket sock = new Socket("127.0.0.1", 5555);
        Log.e((String)TAG, (String)"Socket connected");
        AdbConnection adb = AdbConnection.create((Socket)sock, (AdbCrypto)crypto);
        Log.e((String)TAG, (String)"ADB connecting...");
        adb.connect();
        Log.e((String)TAG, (String)"ADB connected");
        return adb;
    }

    public String openShell(Context context, String cmd) throws Exception {
        if (this.connection == null) {
            this.connection = this.connection(context);
        }
        this.stream = this.connection.open(cmd);
        StringBuilder stringBuilder = new StringBuilder();
        byte[] bytes = this.stream.read();
        stringBuilder.append(new String(bytes));
        while (bytes != null) {
            stringBuilder.append(new String(bytes));
            try {
                bytes = this.stream.read();
            }
            catch (Exception e) {
                bytes = null;
                Log.d((String)"morning", (String)e.getMessage());
            }
        }
        Log.d((String)"morning", (String)("length is " + stringBuilder.length()));
        return stringBuilder.toString();
    }
}

