/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import android.util.Pair;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;

public class RunUtil {
    private static final int MESSAGE_RUN_ON_UITHREAD = 1;
    private static Handler sHandler;

    public static void runOnUiThread(Runnable runnable) {
        RunUtil.runOnUiThread(runnable, false);
    }

    public static void runOnUiThread(Runnable runnable, boolean waitUtilDone) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
            return;
        }
        CountDownLatch countDownLatch = null;
        if (waitUtilDone) {
            countDownLatch = new CountDownLatch(1);
        }
        Pair pair = new Pair((Object)runnable, (Object)countDownLatch);
        RunUtil.getHandler().obtainMessage(1, (Object)pair).sendToTarget();
        if (waitUtilDone) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                Log.w((String)"VA", (Throwable)e);
            }
        }
    }

    public static Executor getThreadPool() {
        return AsyncTask.THREAD_POOL_EXECUTOR;
    }

    private static String getProcessNameByPid(Context context, int pid) {
        try {
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            List appProcessList = manager.getRunningAppProcesses();
            if (appProcessList != null) {
                for (ActivityManager.RunningAppProcessInfo appProcessInfo : appProcessList) {
                    if (pid != appProcessInfo.pid) continue;
                    return appProcessInfo.processName;
                }
            }
        }
        catch (Throwable e) {
            Log.w((String)"VA", (Throwable)e);
        }
        return null;
    }

    public static boolean isMainProcess(Context context) {
        String processName = RunUtil.getProcessNameByPid(context, Process.myPid());
        return context.getPackageName().equals(processName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Handler getHandler() {
        Class<RunUtil> clazz = RunUtil.class;
        synchronized (RunUtil.class) {
            if (sHandler == null) {
                sHandler = new InternalHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sHandler;
        }
    }

    private static class InternalHandler
    extends Handler {
        public InternalHandler() {
            super(Looper.getMainLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                Pair pair = (Pair)msg.obj;
                try {
                    Runnable runnable = (Runnable)pair.first;
                    runnable.run();
                }
                finally {
                    if (pair.second != null) {
                        ((CountDownLatch)pair.second).countDown();
                    }
                }
            }
        }
    }
}

