/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import com.didi.virtualapk.internal.ComponentsHandler;
import com.didi.virtualapk.internal.LoadedPlugin;
import com.didi.virtualapk.internal.PluginContentResolver;

class PluginContext
extends ContextWrapper {
    private final LoadedPlugin mPlugin;

    public PluginContext(LoadedPlugin plugin) {
        super(plugin.getPluginManager().getHostContext());
        this.mPlugin = plugin;
    }

    public PluginContext(LoadedPlugin plugin, Context base) {
        super(base);
        this.mPlugin = plugin;
    }

    public Context getApplicationContext() {
        return this.mPlugin.getApplication();
    }

    private Context getHostContext() {
        return this.getBaseContext();
    }

    public ContentResolver getContentResolver() {
        return new PluginContentResolver(this.getHostContext());
    }

    public ClassLoader getClassLoader() {
        return this.mPlugin.getClassLoader();
    }

    public PackageManager getPackageManager() {
        return this.mPlugin.getPackageManager();
    }

    public Object getSystemService(String name) {
        if (name.equals("clipboard")) {
            return this.getHostContext().getSystemService(name);
        }
        if (name.equals("notification")) {
            return this.getHostContext().getSystemService(name);
        }
        return super.getSystemService(name);
    }

    public Resources getResources() {
        return this.mPlugin.getResources();
    }

    public AssetManager getAssets() {
        return this.mPlugin.getAssets();
    }

    public Resources.Theme getTheme() {
        return this.mPlugin.getTheme();
    }

    public void startActivity(Intent intent) {
        ComponentsHandler componentsHandler = this.mPlugin.getPluginManager().getComponentsHandler();
        componentsHandler.transformIntentToExplicitAsNeeded(intent);
        super.startActivity(intent);
    }
}

