/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal;

import android.annotation.TargetApi;
import android.app.Application;
import android.app.Instrumentation;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ChangedPackages;
import android.content.pm.FeatureInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.SharedLibraryInfo;
import android.content.pm.VersionedPackage;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Process;
import android.os.UserHandle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.internal.ActivityLifecycleCallbacksProxy;
import com.didi.virtualapk.internal.PluginContext;
import com.didi.virtualapk.internal.ResourcesManager;
import com.didi.virtualapk.internal.utils.DexUtil;
import com.didi.virtualapk.internal.utils.PackageParserCompat;
import com.didi.virtualapk.internal.utils.PluginUtil;
import com.didi.virtualapk.utils.Reflector;
import com.didi.virtualapk.utils.RunUtil;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadedPlugin {
    public static final String TAG = "VA.LoadedPlugin";
    protected final String mLocation;
    protected PluginManager mPluginManager;
    protected Context mHostContext;
    protected Context mPluginContext;
    protected final File mNativeLibDir;
    protected final PackageParser.Package mPackage;
    protected final PackageInfo mPackageInfo;
    protected Resources mResources;
    protected ClassLoader mClassLoader;
    protected PluginPackageManager mPackageManager;
    protected Map<ComponentName, ActivityInfo> mActivityInfos;
    protected Map<ComponentName, ServiceInfo> mServiceInfos;
    protected Map<ComponentName, ActivityInfo> mReceiverInfos;
    protected Map<ComponentName, ProviderInfo> mProviderInfos;
    protected Map<String, ProviderInfo> mProviders;
    protected Map<ComponentName, InstrumentationInfo> mInstrumentationInfos;
    protected Application mApplication;

    protected File getDir(Context context, String name) {
        return context.getDir(name, 0);
    }

    protected ClassLoader createClassLoader(Context context, File apk, File libsDir, ClassLoader parent) throws Exception {
        File dexOutputDir = this.getDir(context, "dex");
        String dexOutputPath = dexOutputDir.getAbsolutePath();
        DexClassLoader loader = new DexClassLoader(apk.getAbsolutePath(), dexOutputPath, libsDir.getAbsolutePath(), parent);
        DexUtil.insertDex(loader, parent, libsDir);
        return loader;
    }

    protected AssetManager createAssetManager(Context context, File apk) throws Exception {
        AssetManager am = (AssetManager)AssetManager.class.newInstance();
        Reflector.with(am).method("addAssetPath", String.class).call(apk.getAbsolutePath());
        return am;
    }

    protected Resources createResources(Context context, String packageName, File apk) throws Exception {
        return ResourcesManager.createResources(context, packageName, apk);
    }

    protected PluginPackageManager createPluginPackageManager() {
        return new PluginPackageManager();
    }

    public PluginContext createPluginContext(Context context) {
        if (context == null) {
            return new PluginContext(this);
        }
        return new PluginContext(this, context);
    }

    protected ResolveInfo chooseBestActivity(Intent intent, String s, int flags, List<ResolveInfo> query) {
        return query.get(0);
    }

    public LoadedPlugin(PluginManager pluginManager, Context context, File apk) throws Exception {
        this.mPluginManager = pluginManager;
        this.mHostContext = context;
        this.mLocation = apk.getAbsolutePath();
        this.mPackage = PackageParserCompat.parsePackage(context, apk, 4);
        this.mPackage.applicationInfo.metaData = this.mPackage.mAppMetaData;
        this.mPackageInfo = new PackageInfo();
        this.mPackageInfo.applicationInfo = this.mPackage.applicationInfo;
        this.mPackageInfo.applicationInfo.sourceDir = apk.getAbsolutePath();
        if (Build.VERSION.SDK_INT >= 28 || Build.VERSION.SDK_INT == 27 && Build.VERSION.PREVIEW_SDK_INT != 0) {
            try {
                this.mPackageInfo.signatures = this.mPackage.mSigningDetails.signatures;
            }
            catch (Throwable e) {
                PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
                this.mPackageInfo.signatures = info.signatures;
            }
        } else {
            this.mPackageInfo.signatures = this.mPackage.mSignatures;
        }
        this.mPackageInfo.packageName = this.mPackage.packageName;
        if (pluginManager.getLoadedPlugin(this.mPackageInfo.packageName) != null) {
            throw new RuntimeException("plugin has already been loaded : " + this.mPackageInfo.packageName);
        }
        this.mPackageInfo.versionCode = this.mPackage.mVersionCode;
        this.mPackageInfo.versionName = this.mPackage.mVersionName;
        this.mPackageInfo.permissions = new PermissionInfo[0];
        this.mPackageManager = this.createPluginPackageManager();
        this.mPluginContext = this.createPluginContext(null);
        this.mNativeLibDir = this.getDir(context, "valibs");
        this.mPackage.applicationInfo.nativeLibraryDir = this.mNativeLibDir.getAbsolutePath();
        this.mResources = this.createResources(context, this.getPackageName(), apk);
        this.mClassLoader = this.createClassLoader(context, apk, this.mNativeLibDir, context.getClassLoader());
        this.tryToCopyNativeLib(apk);
        HashMap<ComponentName, InstrumentationInfo> instrumentations = new HashMap<ComponentName, InstrumentationInfo>();
        for (Object instrumentation : this.mPackage.instrumentation) {
            instrumentations.put(instrumentation.getComponentName(), ((PackageParser.Instrumentation)instrumentation).info);
        }
        this.mInstrumentationInfos = Collections.unmodifiableMap(instrumentations);
        this.mPackageInfo.instrumentation = instrumentations.values().toArray(new InstrumentationInfo[instrumentations.size()]);
        HashMap<ComponentName, ActivityInfo> activityInfos = new HashMap<ComponentName, ActivityInfo>();
        for (Object activity : this.mPackage.activities) {
            ((PackageParser.Activity)activity).info.metaData = ((PackageParser.Activity)activity).metaData;
            activityInfos.put(activity.getComponentName(), ((PackageParser.Activity)activity).info);
        }
        this.mActivityInfos = Collections.unmodifiableMap(activityInfos);
        this.mPackageInfo.activities = activityInfos.values().toArray(new ActivityInfo[activityInfos.size()]);
        HashMap<ComponentName, ServiceInfo> serviceInfos = new HashMap<ComponentName, ServiceInfo>();
        for (PackageParser.Service service : this.mPackage.services) {
            serviceInfos.put(service.getComponentName(), service.info);
        }
        this.mServiceInfos = Collections.unmodifiableMap(serviceInfos);
        this.mPackageInfo.services = serviceInfos.values().toArray(new ServiceInfo[serviceInfos.size()]);
        HashMap<String, ProviderInfo> providers = new HashMap<String, ProviderInfo>();
        HashMap<ComponentName, ProviderInfo> providerInfos = new HashMap<ComponentName, ProviderInfo>();
        for (PackageParser.Provider provider : this.mPackage.providers) {
            providers.put(provider.info.authority, provider.info);
            providerInfos.put(provider.getComponentName(), provider.info);
        }
        this.mProviders = Collections.unmodifiableMap(providers);
        this.mProviderInfos = Collections.unmodifiableMap(providerInfos);
        this.mPackageInfo.providers = providerInfos.values().toArray(new ProviderInfo[providerInfos.size()]);
        HashMap<ComponentName, ActivityInfo> receivers = new HashMap<ComponentName, ActivityInfo>();
        for (PackageParser.Activity receiver : this.mPackage.receivers) {
            receivers.put(receiver.getComponentName(), receiver.info);
            BroadcastReceiver br = (BroadcastReceiver)BroadcastReceiver.class.cast(this.getClassLoader().loadClass(receiver.getComponentName().getClassName()).newInstance());
            for (PackageParser.ActivityIntentInfo aii : receiver.intents) {
                this.mHostContext.registerReceiver(br, (IntentFilter)aii);
            }
        }
        this.mReceiverInfos = Collections.unmodifiableMap(receivers);
        this.mPackageInfo.receivers = receivers.values().toArray(new ActivityInfo[receivers.size()]);
        this.invokeApplication();
    }

    protected void tryToCopyNativeLib(File apk) throws Exception {
        PluginUtil.copyNativeLib(apk, this.mHostContext, this.mPackageInfo, this.mNativeLibDir);
    }

    public String getLocation() {
        return this.mLocation;
    }

    public String getPackageName() {
        return this.mPackage.packageName;
    }

    public PackageManager getPackageManager() {
        return this.mPackageManager;
    }

    public AssetManager getAssets() {
        return this.getResources().getAssets();
    }

    public Resources getResources() {
        return this.mResources;
    }

    public void updateResources(Resources newResources) {
        this.mResources = newResources;
    }

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public PluginManager getPluginManager() {
        return this.mPluginManager;
    }

    public Context getHostContext() {
        return this.mHostContext;
    }

    public Context getPluginContext() {
        return this.mPluginContext;
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public void invokeApplication() throws Exception {
        final Exception[] temp = new Exception[1];
        RunUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (LoadedPlugin.this.mApplication != null) {
                    return;
                }
                try {
                    LoadedPlugin.this.mApplication = LoadedPlugin.this.makeApplication(false, LoadedPlugin.this.mPluginManager.getInstrumentation());
                }
                catch (Exception e) {
                    temp[0] = e;
                }
            }
        }, true);
        if (temp[0] != null) {
            throw temp[0];
        }
    }

    public String getPackageResourcePath() {
        int myUid = Process.myUid();
        ApplicationInfo appInfo = this.mPackage.applicationInfo;
        return appInfo.uid == myUid ? appInfo.sourceDir : appInfo.publicSourceDir;
    }

    public String getCodePath() {
        return this.mPackage.applicationInfo.sourceDir;
    }

    public Intent getLaunchIntent() {
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        Intent launcher = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.LAUNCHER");
        for (PackageParser.Activity activity : this.mPackage.activities) {
            for (PackageParser.ActivityIntentInfo intentInfo : activity.intents) {
                if (intentInfo.match(resolver, launcher, false, TAG) <= 0) continue;
                return Intent.makeMainActivity((ComponentName)activity.getComponentName());
            }
        }
        return null;
    }

    public Intent getLeanbackLaunchIntent() {
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        Intent launcher = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.LEANBACK_LAUNCHER");
        for (PackageParser.Activity activity : this.mPackage.activities) {
            for (PackageParser.ActivityIntentInfo intentInfo : activity.intents) {
                if (intentInfo.match(resolver, launcher, false, TAG) <= 0) continue;
                Intent intent = new Intent("android.intent.action.MAIN");
                intent.setComponent(activity.getComponentName());
                intent.addCategory("android.intent.category.LEANBACK_LAUNCHER");
                return intent;
            }
        }
        return null;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.mPackage.applicationInfo;
    }

    public PackageInfo getPackageInfo() {
        return this.mPackageInfo;
    }

    public ActivityInfo getActivityInfo(ComponentName componentName) {
        return this.mActivityInfos.get(componentName);
    }

    public ServiceInfo getServiceInfo(ComponentName componentName) {
        return this.mServiceInfos.get(componentName);
    }

    public ActivityInfo getReceiverInfo(ComponentName componentName) {
        return this.mReceiverInfos.get(componentName);
    }

    public ProviderInfo getProviderInfo(ComponentName componentName) {
        return this.mProviderInfos.get(componentName);
    }

    public Resources.Theme getTheme() {
        Resources.Theme theme = this.mResources.newTheme();
        theme.applyStyle(PluginUtil.selectDefaultTheme(this.mPackage.applicationInfo.theme, Build.VERSION.SDK_INT), false);
        return theme;
    }

    public void setTheme(int resid) {
        Reflector.QuietReflector.with(this.mResources).field("mThemeResId").set(resid);
    }

    protected Application makeApplication(boolean forceDefaultAppClass, Instrumentation instrumentation) throws Exception {
        if (null != this.mApplication) {
            return this.mApplication;
        }
        String appClass = this.mPackage.applicationInfo.className;
        if (forceDefaultAppClass || null == appClass) {
            appClass = "android.app.Application";
        }
        this.mApplication = instrumentation.newApplication(this.mClassLoader, appClass, this.getPluginContext());
        this.mApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleCallbacksProxy());
        instrumentation.callApplicationOnCreate(this.mApplication);
        return this.mApplication;
    }

    public ResolveInfo resolveActivity(Intent intent, int flags) {
        List<ResolveInfo> query = this.queryIntentActivities(intent, flags);
        if (null == query || query.isEmpty()) {
            return null;
        }
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        return this.chooseBestActivity(intent, intent.resolveTypeIfNeeded(resolver), flags, query);
    }

    public List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        ComponentName component = intent.getComponent();
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        block0: for (PackageParser.Activity activity : this.mPackage.activities) {
            if (this.match((PackageParser.Component)activity, component)) {
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.activityInfo = activity.info;
                resolveInfos.add(resolveInfo);
                continue;
            }
            if (component != null) continue;
            for (PackageParser.ActivityIntentInfo intentInfo : activity.intents) {
                if (intentInfo.match(resolver, intent, true, TAG) < 0) continue;
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.activityInfo = activity.info;
                resolveInfos.add(resolveInfo);
                continue block0;
            }
        }
        return resolveInfos;
    }

    public ResolveInfo resolveService(Intent intent, int flags) {
        List<ResolveInfo> query = this.queryIntentServices(intent, flags);
        if (null == query || query.isEmpty()) {
            return null;
        }
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        return this.chooseBestActivity(intent, intent.resolveTypeIfNeeded(resolver), flags, query);
    }

    public List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
        ComponentName component = intent.getComponent();
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        block0: for (PackageParser.Service service : this.mPackage.services) {
            if (this.match((PackageParser.Component)service, component)) {
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.serviceInfo = service.info;
                resolveInfos.add(resolveInfo);
                continue;
            }
            if (component != null) continue;
            for (PackageParser.ServiceIntentInfo intentInfo : service.intents) {
                if (intentInfo.match(resolver, intent, true, TAG) < 0) continue;
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.serviceInfo = service.info;
                resolveInfos.add(resolveInfo);
                continue block0;
            }
        }
        return resolveInfos;
    }

    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
        ComponentName component = intent.getComponent();
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        block0: for (PackageParser.Activity receiver : this.mPackage.receivers) {
            if (receiver.getComponentName().equals((Object)component)) {
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.activityInfo = receiver.info;
                resolveInfos.add(resolveInfo);
                continue;
            }
            if (component != null) continue;
            for (PackageParser.ActivityIntentInfo intentInfo : receiver.intents) {
                if (intentInfo.match(resolver, intent, true, TAG) < 0) continue;
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.activityInfo = receiver.info;
                resolveInfos.add(resolveInfo);
                continue block0;
            }
        }
        return resolveInfos;
    }

    public ProviderInfo resolveContentProvider(String name, int flags) {
        return this.mProviders.get(name);
    }

    protected boolean match(PackageParser.Component component, ComponentName target) {
        ComponentName source = component.getComponentName();
        if (source == target) {
            return true;
        }
        return source != null && target != null && source.getClassName().equals(target.getClassName()) && (source.getPackageName().equals(target.getPackageName()) || this.mHostContext.getPackageName().equals(target.getPackageName()));
    }

    protected class PluginPackageManager
    extends PackageManager {
        protected PackageManager mHostPackageManager;

        protected PluginPackageManager() {
            this.mHostPackageManager = LoadedPlugin.this.mHostContext.getPackageManager();
        }

        public PackageInfo getPackageInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mPackageInfo;
            }
            return this.mHostPackageManager.getPackageInfo(packageName, flags);
        }

        @TargetApi(value=26)
        public PackageInfo getPackageInfo(VersionedPackage versionedPackage, int i) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(versionedPackage.getPackageName());
            if (null != plugin) {
                return plugin.mPackageInfo;
            }
            return this.mHostPackageManager.getPackageInfo(versionedPackage, i);
        }

        public String[] currentToCanonicalPackageNames(String[] names) {
            return this.mHostPackageManager.currentToCanonicalPackageNames(names);
        }

        public String[] canonicalToCurrentPackageNames(String[] names) {
            return this.mHostPackageManager.canonicalToCurrentPackageNames(names);
        }

        public Intent getLaunchIntentForPackage(@NonNull String packageName) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.getLaunchIntent();
            }
            return this.mHostPackageManager.getLaunchIntentForPackage(packageName);
        }

        @TargetApi(value=21)
        public Intent getLeanbackLaunchIntentForPackage(@NonNull String packageName) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.getLeanbackLaunchIntent();
            }
            return this.mHostPackageManager.getLeanbackLaunchIntentForPackage(packageName);
        }

        public int[] getPackageGids(@NonNull String packageName) throws PackageManager.NameNotFoundException {
            return this.mHostPackageManager.getPackageGids(packageName);
        }

        @TargetApi(value=24)
        public int[] getPackageGids(String packageName, int flags) throws PackageManager.NameNotFoundException {
            return this.mHostPackageManager.getPackageGids(packageName, flags);
        }

        @TargetApi(value=24)
        public int getPackageUid(String packageName, int flags) throws PackageManager.NameNotFoundException {
            return this.mHostPackageManager.getPackageUid(packageName, flags);
        }

        public PermissionInfo getPermissionInfo(String name, int flags) throws PackageManager.NameNotFoundException {
            return this.mHostPackageManager.getPermissionInfo(name, flags);
        }

        public List<PermissionInfo> queryPermissionsByGroup(String group, int flags) throws PackageManager.NameNotFoundException {
            return this.mHostPackageManager.queryPermissionsByGroup(group, flags);
        }

        public PermissionGroupInfo getPermissionGroupInfo(String name, int flags) throws PackageManager.NameNotFoundException {
            return this.mHostPackageManager.getPermissionGroupInfo(name, flags);
        }

        public List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
            return this.mHostPackageManager.getAllPermissionGroups(flags);
        }

        public ApplicationInfo getApplicationInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.getApplicationInfo();
            }
            return this.mHostPackageManager.getApplicationInfo(packageName, flags);
        }

        public ActivityInfo getActivityInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return plugin.mActivityInfos.get(component);
            }
            return this.mHostPackageManager.getActivityInfo(component, flags);
        }

        public ActivityInfo getReceiverInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return plugin.mReceiverInfos.get(component);
            }
            return this.mHostPackageManager.getReceiverInfo(component, flags);
        }

        public ServiceInfo getServiceInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return plugin.mServiceInfos.get(component);
            }
            return this.mHostPackageManager.getServiceInfo(component, flags);
        }

        public ProviderInfo getProviderInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return plugin.mProviderInfos.get(component);
            }
            return this.mHostPackageManager.getProviderInfo(component, flags);
        }

        public List<PackageInfo> getInstalledPackages(int flags) {
            return this.mHostPackageManager.getInstalledPackages(flags);
        }

        @TargetApi(value=18)
        public List<PackageInfo> getPackagesHoldingPermissions(String[] permissions, int flags) {
            return this.mHostPackageManager.getPackagesHoldingPermissions(permissions, flags);
        }

        public int checkPermission(String permName, String pkgName) {
            return this.mHostPackageManager.checkPermission(permName, pkgName);
        }

        @TargetApi(value=23)
        public boolean isPermissionRevokedByPolicy(@NonNull String permName, @NonNull String pkgName) {
            return this.mHostPackageManager.isPermissionRevokedByPolicy(permName, pkgName);
        }

        public boolean addPermission(PermissionInfo info) {
            return this.mHostPackageManager.addPermission(info);
        }

        public boolean addPermissionAsync(PermissionInfo info) {
            return this.mHostPackageManager.addPermissionAsync(info);
        }

        public void removePermission(String name) {
            this.mHostPackageManager.removePermission(name);
        }

        public int checkSignatures(String pkg1, String pkg2) {
            return this.mHostPackageManager.checkSignatures(pkg1, pkg2);
        }

        public int checkSignatures(int uid1, int uid2) {
            return this.mHostPackageManager.checkSignatures(uid1, uid2);
        }

        public String[] getPackagesForUid(int uid) {
            return this.mHostPackageManager.getPackagesForUid(uid);
        }

        public String getNameForUid(int uid) {
            return this.mHostPackageManager.getNameForUid(uid);
        }

        public List<ApplicationInfo> getInstalledApplications(int flags) {
            return this.mHostPackageManager.getInstalledApplications(flags);
        }

        @TargetApi(value=26)
        public boolean isInstantApp() {
            return this.mHostPackageManager.isInstantApp();
        }

        @TargetApi(value=26)
        public boolean isInstantApp(String packageName) {
            return this.mHostPackageManager.isInstantApp(packageName);
        }

        @TargetApi(value=26)
        public int getInstantAppCookieMaxBytes() {
            return this.mHostPackageManager.getInstantAppCookieMaxBytes();
        }

        @TargetApi(value=26)
        @NonNull
        public byte[] getInstantAppCookie() {
            return this.mHostPackageManager.getInstantAppCookie();
        }

        @TargetApi(value=26)
        public void clearInstantAppCookie() {
            this.mHostPackageManager.clearInstantAppCookie();
        }

        @TargetApi(value=26)
        public void updateInstantAppCookie(@Nullable byte[] cookie) {
            this.mHostPackageManager.updateInstantAppCookie(cookie);
        }

        public String[] getSystemSharedLibraryNames() {
            return this.mHostPackageManager.getSystemSharedLibraryNames();
        }

        @TargetApi(value=26)
        @NonNull
        public List<SharedLibraryInfo> getSharedLibraries(int flags) {
            return this.mHostPackageManager.getSharedLibraries(flags);
        }

        @TargetApi(value=26)
        @Nullable
        public ChangedPackages getChangedPackages(int sequenceNumber) {
            return this.mHostPackageManager.getChangedPackages(sequenceNumber);
        }

        public FeatureInfo[] getSystemAvailableFeatures() {
            return this.mHostPackageManager.getSystemAvailableFeatures();
        }

        public boolean hasSystemFeature(String name) {
            return this.mHostPackageManager.hasSystemFeature(name);
        }

        @TargetApi(value=24)
        public boolean hasSystemFeature(String name, int version) {
            return this.mHostPackageManager.hasSystemFeature(name, version);
        }

        public ResolveInfo resolveActivity(Intent intent, int flags) {
            ResolveInfo resolveInfo = LoadedPlugin.this.mPluginManager.resolveActivity(intent, flags);
            if (null != resolveInfo) {
                return resolveInfo;
            }
            return this.mHostPackageManager.resolveActivity(intent, flags);
        }

        public List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
            List hostResolveInfos;
            ActivityInfo activityInfo;
            LoadedPlugin plugin;
            ComponentName component = intent.getComponent();
            if (null == component && intent.getSelector() != null) {
                intent = intent.getSelector();
                component = intent.getComponent();
            }
            if (null != component && null != (plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component)) && (activityInfo = plugin.getActivityInfo(component)) != null) {
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.activityInfo = activityInfo;
                return Arrays.asList(resolveInfo);
            }
            ArrayList<ResolveInfo> all = new ArrayList<ResolveInfo>();
            List<ResolveInfo> pluginResolveInfos = LoadedPlugin.this.mPluginManager.queryIntentActivities(intent, flags);
            if (null != pluginResolveInfos && pluginResolveInfos.size() > 0) {
                all.addAll(pluginResolveInfos);
            }
            if (null != (hostResolveInfos = this.mHostPackageManager.queryIntentActivities(intent, flags)) && hostResolveInfos.size() > 0) {
                all.addAll(hostResolveInfos);
            }
            return all;
        }

        public List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, Intent intent, int flags) {
            return this.mHostPackageManager.queryIntentActivityOptions(caller, specifics, intent, flags);
        }

        public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
            List hostResolveInfos;
            ActivityInfo activityInfo;
            LoadedPlugin plugin;
            ComponentName component = intent.getComponent();
            if (null == component && intent.getSelector() != null) {
                intent = intent.getSelector();
                component = intent.getComponent();
            }
            if (null != component && null != (plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component)) && (activityInfo = plugin.getReceiverInfo(component)) != null) {
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.activityInfo = activityInfo;
                return Arrays.asList(resolveInfo);
            }
            ArrayList<ResolveInfo> all = new ArrayList<ResolveInfo>();
            List<ResolveInfo> pluginResolveInfos = LoadedPlugin.this.mPluginManager.queryBroadcastReceivers(intent, flags);
            if (null != pluginResolveInfos && pluginResolveInfos.size() > 0) {
                all.addAll(pluginResolveInfos);
            }
            if (null != (hostResolveInfos = this.mHostPackageManager.queryBroadcastReceivers(intent, flags)) && hostResolveInfos.size() > 0) {
                all.addAll(hostResolveInfos);
            }
            return all;
        }

        public ResolveInfo resolveService(Intent intent, int flags) {
            ResolveInfo resolveInfo = LoadedPlugin.this.mPluginManager.resolveService(intent, flags);
            if (null != resolveInfo) {
                return resolveInfo;
            }
            return this.mHostPackageManager.resolveService(intent, flags);
        }

        public List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
            List hostResolveInfos;
            ServiceInfo serviceInfo;
            LoadedPlugin plugin;
            ComponentName component = intent.getComponent();
            if (null == component && intent.getSelector() != null) {
                intent = intent.getSelector();
                component = intent.getComponent();
            }
            if (null != component && null != (plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component)) && (serviceInfo = plugin.getServiceInfo(component)) != null) {
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.serviceInfo = serviceInfo;
                return Arrays.asList(resolveInfo);
            }
            ArrayList<ResolveInfo> all = new ArrayList<ResolveInfo>();
            List<ResolveInfo> pluginResolveInfos = LoadedPlugin.this.mPluginManager.queryIntentServices(intent, flags);
            if (null != pluginResolveInfos && pluginResolveInfos.size() > 0) {
                all.addAll(pluginResolveInfos);
            }
            if (null != (hostResolveInfos = this.mHostPackageManager.queryIntentServices(intent, flags)) && hostResolveInfos.size() > 0) {
                all.addAll(hostResolveInfos);
            }
            return all;
        }

        @TargetApi(value=19)
        public List<ResolveInfo> queryIntentContentProviders(Intent intent, int flags) {
            return this.mHostPackageManager.queryIntentContentProviders(intent, flags);
        }

        public ProviderInfo resolveContentProvider(String name, int flags) {
            ProviderInfo providerInfo = LoadedPlugin.this.mPluginManager.resolveContentProvider(name, flags);
            if (null != providerInfo) {
                return providerInfo;
            }
            return this.mHostPackageManager.resolveContentProvider(name, flags);
        }

        public List<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
            return this.mHostPackageManager.queryContentProviders(processName, uid, flags);
        }

        public InstrumentationInfo getInstrumentationInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return plugin.mInstrumentationInfos.get(component);
            }
            return this.mHostPackageManager.getInstrumentationInfo(component, flags);
        }

        public List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
            return this.mHostPackageManager.queryInstrumentation(targetPackage, flags);
        }

        public Drawable getDrawable(String packageName, int resid, ApplicationInfo appInfo) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(resid);
            }
            return this.mHostPackageManager.getDrawable(packageName, resid, appInfo);
        }

        public Drawable getActivityIcon(ComponentName component) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return plugin.mResources.getDrawable(plugin.mActivityInfos.get((Object)component).icon);
            }
            return this.mHostPackageManager.getActivityIcon(component);
        }

        public Drawable getActivityIcon(Intent intent) throws PackageManager.NameNotFoundException {
            ResolveInfo ri = LoadedPlugin.this.mPluginManager.resolveActivity(intent);
            if (null != ri) {
                LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(ri.resolvePackageName);
                return plugin.mResources.getDrawable(ri.activityInfo.icon);
            }
            return this.mHostPackageManager.getActivityIcon(intent);
        }

        @TargetApi(value=20)
        public Drawable getActivityBanner(ComponentName component) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return plugin.mResources.getDrawable(plugin.mActivityInfos.get((Object)component).banner);
            }
            return this.mHostPackageManager.getActivityBanner(component);
        }

        @TargetApi(value=20)
        public Drawable getActivityBanner(Intent intent) throws PackageManager.NameNotFoundException {
            ResolveInfo ri = LoadedPlugin.this.mPluginManager.resolveActivity(intent);
            if (null != ri) {
                LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(ri.resolvePackageName);
                return plugin.mResources.getDrawable(ri.activityInfo.banner);
            }
            return this.mHostPackageManager.getActivityBanner(intent);
        }

        public Drawable getDefaultActivityIcon() {
            return this.mHostPackageManager.getDefaultActivityIcon();
        }

        public Drawable getApplicationIcon(ApplicationInfo info) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(info.packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(info.icon);
            }
            return this.mHostPackageManager.getApplicationIcon(info);
        }

        public Drawable getApplicationIcon(String packageName) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(plugin.mPackage.applicationInfo.icon);
            }
            return this.mHostPackageManager.getApplicationIcon(packageName);
        }

        @TargetApi(value=20)
        public Drawable getApplicationBanner(ApplicationInfo info) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(info.packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(info.banner);
            }
            return this.mHostPackageManager.getApplicationBanner(info);
        }

        @TargetApi(value=20)
        public Drawable getApplicationBanner(String packageName) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(plugin.mPackage.applicationInfo.banner);
            }
            return this.mHostPackageManager.getApplicationBanner(packageName);
        }

        public Drawable getActivityLogo(ComponentName component) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return plugin.mResources.getDrawable(plugin.mActivityInfos.get((Object)component).logo);
            }
            return this.mHostPackageManager.getActivityLogo(component);
        }

        public Drawable getActivityLogo(Intent intent) throws PackageManager.NameNotFoundException {
            ResolveInfo ri = LoadedPlugin.this.mPluginManager.resolveActivity(intent);
            if (null != ri) {
                LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(ri.resolvePackageName);
                return plugin.mResources.getDrawable(ri.activityInfo.logo);
            }
            return this.mHostPackageManager.getActivityLogo(intent);
        }

        public Drawable getApplicationLogo(ApplicationInfo info) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(info.packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(0 != info.logo ? info.logo : 17301651);
            }
            return this.mHostPackageManager.getApplicationLogo(info);
        }

        public Drawable getApplicationLogo(String packageName) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(0 != plugin.mPackage.applicationInfo.logo ? plugin.mPackage.applicationInfo.logo : 17301651);
            }
            return this.mHostPackageManager.getApplicationLogo(packageName);
        }

        @TargetApi(value=21)
        public Drawable getUserBadgedIcon(Drawable icon, UserHandle user) {
            return this.mHostPackageManager.getUserBadgedIcon(icon, user);
        }

        @TargetApi(value=17)
        public Drawable getUserBadgeForDensity(UserHandle user, int density) {
            try {
                return (Drawable)Reflector.with(this.mHostPackageManager).method("getUserBadgeForDensity", UserHandle.class, Integer.TYPE).call(user, density);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @TargetApi(value=21)
        public Drawable getUserBadgedDrawableForDensity(Drawable drawable2, UserHandle user, Rect badgeLocation, int badgeDensity) {
            return this.mHostPackageManager.getUserBadgedDrawableForDensity(drawable2, user, badgeLocation, badgeDensity);
        }

        @TargetApi(value=21)
        public CharSequence getUserBadgedLabel(CharSequence label, UserHandle user) {
            return this.mHostPackageManager.getUserBadgedLabel(label, user);
        }

        public CharSequence getText(String packageName, int resid, ApplicationInfo appInfo) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mResources.getText(resid);
            }
            return this.mHostPackageManager.getText(packageName, resid, appInfo);
        }

        public XmlResourceParser getXml(String packageName, int resid, ApplicationInfo appInfo) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mResources.getXml(resid);
            }
            return this.mHostPackageManager.getXml(packageName, resid, appInfo);
        }

        public CharSequence getApplicationLabel(ApplicationInfo info) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(info.packageName);
            if (null != plugin) {
                try {
                    return plugin.mResources.getText(info.labelRes);
                }
                catch (Resources.NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            return this.mHostPackageManager.getApplicationLabel(info);
        }

        public Resources getResourcesForActivity(ComponentName component) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return plugin.mResources;
            }
            return this.mHostPackageManager.getResourcesForActivity(component);
        }

        public Resources getResourcesForApplication(ApplicationInfo app) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(app.packageName);
            if (null != plugin) {
                return plugin.mResources;
            }
            return this.mHostPackageManager.getResourcesForApplication(app);
        }

        public Resources getResourcesForApplication(String appPackageName) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(appPackageName);
            if (null != plugin) {
                return plugin.mResources;
            }
            return this.mHostPackageManager.getResourcesForApplication(appPackageName);
        }

        public void verifyPendingInstall(int id, int verificationCode) {
            this.mHostPackageManager.verifyPendingInstall(id, verificationCode);
        }

        @TargetApi(value=17)
        public void extendVerificationTimeout(int id, int verificationCodeAtTimeout, long millisecondsToDelay) {
            this.mHostPackageManager.extendVerificationTimeout(id, verificationCodeAtTimeout, millisecondsToDelay);
        }

        public void setInstallerPackageName(String targetPackage, String installerPackageName) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(targetPackage);
            if (null != plugin) {
                return;
            }
            this.mHostPackageManager.setInstallerPackageName(targetPackage, installerPackageName);
        }

        public String getInstallerPackageName(String packageName) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return LoadedPlugin.this.mHostContext.getPackageName();
            }
            return this.mHostPackageManager.getInstallerPackageName(packageName);
        }

        public void addPackageToPreferred(String packageName) {
            this.mHostPackageManager.addPackageToPreferred(packageName);
        }

        public void removePackageFromPreferred(String packageName) {
            this.mHostPackageManager.removePackageFromPreferred(packageName);
        }

        public List<PackageInfo> getPreferredPackages(int flags) {
            return this.mHostPackageManager.getPreferredPackages(flags);
        }

        public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
            this.mHostPackageManager.addPreferredActivity(filter, match, set, activity);
        }

        public void clearPackagePreferredActivities(String packageName) {
            this.mHostPackageManager.clearPackagePreferredActivities(packageName);
        }

        public int getPreferredActivities(@NonNull List<IntentFilter> outFilters, @NonNull List<ComponentName> outActivities, String packageName) {
            return this.mHostPackageManager.getPreferredActivities(outFilters, outActivities, packageName);
        }

        public void setComponentEnabledSetting(ComponentName component, int newState, int flags) {
            this.mHostPackageManager.setComponentEnabledSetting(component, newState, flags);
        }

        public int getComponentEnabledSetting(ComponentName component) {
            return this.mHostPackageManager.getComponentEnabledSetting(component);
        }

        public void setApplicationEnabledSetting(String packageName, int newState, int flags) {
            this.mHostPackageManager.setApplicationEnabledSetting(packageName, newState, flags);
        }

        public int getApplicationEnabledSetting(String packageName) {
            return this.mHostPackageManager.getApplicationEnabledSetting(packageName);
        }

        public boolean isSafeMode() {
            return this.mHostPackageManager.isSafeMode();
        }

        @TargetApi(value=26)
        public void setApplicationCategoryHint(@NonNull String packageName, int categoryHint) {
            this.mHostPackageManager.setApplicationCategoryHint(packageName, categoryHint);
        }

        @TargetApi(value=21)
        @NonNull
        public PackageInstaller getPackageInstaller() {
            return this.mHostPackageManager.getPackageInstaller();
        }

        @TargetApi(value=26)
        public boolean canRequestPackageInstalls() {
            return this.mHostPackageManager.canRequestPackageInstalls();
        }

        public Drawable loadItemIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo) {
            if (itemInfo == null) {
                return null;
            }
            return itemInfo.loadIcon(this.mHostPackageManager);
        }
    }
}

