/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.Application;
import android.app.IActivityManager;
import android.app.Instrumentation;
import android.content.ComponentName;
import android.content.Context;
import android.content.IContentProvider;
import android.content.Intent;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.util.Singleton;
import com.didi.virtualapk.delegate.ActivityManagerProxy;
import com.didi.virtualapk.delegate.IContentProviderProxy;
import com.didi.virtualapk.delegate.RemoteContentProvider;
import com.didi.virtualapk.internal.ComponentsHandler;
import com.didi.virtualapk.internal.LoadedPlugin;
import com.didi.virtualapk.internal.VAInstrumentation;
import com.didi.virtualapk.internal.utils.PluginUtil;
import com.didi.virtualapk.utils.Reflector;
import com.didi.virtualapk.utils.RunUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PluginManager {
    public static final String TAG = "VA.PluginManager";
    private static volatile PluginManager sInstance = null;
    protected final Context mContext;
    protected final Application mApplication;
    protected ComponentsHandler mComponentsHandler;
    protected final Map<String, LoadedPlugin> mPlugins = new ConcurrentHashMap<String, LoadedPlugin>();
    protected final List<Callback> mCallbacks = new ArrayList<Callback>();
    protected VAInstrumentation mInstrumentation;
    protected IActivityManager mActivityManager;
    protected IContentProvider mIContentProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PluginManager getInstance(Context base) {
        if (sInstance != null) return sInstance;
        Class<PluginManager> clazz = PluginManager.class;
        synchronized (PluginManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = PluginManager.createInstance(base);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private static PluginManager createInstance(Context context) {
        try {
            Bundle metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (metaData == null) {
                return new PluginManager(context);
            }
            String factoryClass = metaData.getString("VA_FACTORY");
            if (factoryClass == null) {
                return new PluginManager(context);
            }
            PluginManager pluginManager = (PluginManager)Reflector.on(factoryClass).method("create", Context.class).call(context);
            if (pluginManager != null) {
                Log.d((String)TAG, (String)("Created a instance of " + pluginManager.getClass()));
                return pluginManager;
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Created the instance error!", (Throwable)e);
        }
        return new PluginManager(context);
    }

    protected PluginManager(Context context) {
        if (context instanceof Application) {
            this.mApplication = (Application)context;
            this.mContext = this.mApplication.getBaseContext();
        } else {
            Context app = context.getApplicationContext();
            if (app == null) {
                this.mContext = context;
                this.mApplication = ActivityThread.currentApplication();
            } else {
                this.mApplication = (Application)app;
                this.mContext = this.mApplication.getBaseContext();
            }
        }
        this.mComponentsHandler = this.createComponentsHandler();
        this.hookCurrentProcess();
    }

    protected void hookCurrentProcess() {
        this.hookInstrumentationAndHandler();
        this.hookSystemServices();
        this.hookDataBindingUtil();
    }

    public void init() {
        RunUtil.getThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                PluginManager.this.doInWorkThread();
            }
        });
    }

    protected void doInWorkThread() {
    }

    public Application getHostApplication() {
        return this.mApplication;
    }

    protected ComponentsHandler createComponentsHandler() {
        return new ComponentsHandler(this);
    }

    protected VAInstrumentation createInstrumentation(Instrumentation origin) throws Exception {
        return new VAInstrumentation(this, origin);
    }

    protected ActivityManagerProxy createActivityManagerProxy(IActivityManager origin) throws Exception {
        return new ActivityManagerProxy(this, origin);
    }

    protected LoadedPlugin createLoadedPlugin(File apk) throws Exception {
        return new LoadedPlugin(this, this.mContext, apk);
    }

    protected void hookDataBindingUtil() {
        Reflector.QuietReflector reflector = Reflector.QuietReflector.on("android.databinding.DataBindingUtil").field("sMapper");
        Object old = reflector.get();
        if (old != null) {
            try {
                Callback callback = (Callback)Reflector.on("android.databinding.DataBinderMapperProxy").constructor(new Class[0]).newInstance(new Object[0]);
                reflector.set(callback);
                this.addCallback(callback);
                Log.d((String)TAG, (String)("hookDataBindingUtil succeed : " + callback));
            }
            catch (Reflector.ReflectedException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(Callback callback) {
        if (callback == null) {
            return;
        }
        List<Callback> list = this.mCallbacks;
        synchronized (list) {
            if (this.mCallbacks.contains(callback)) {
                throw new RuntimeException("Already added " + callback + "!");
            }
            this.mCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(Callback callback) {
        List<Callback> list = this.mCallbacks;
        synchronized (list) {
            this.mCallbacks.remove(callback);
        }
    }

    protected void hookSystemServices() {
        try {
            Singleton defaultSingleton = Build.VERSION.SDK_INT >= 26 ? (Singleton)Reflector.on(ActivityManager.class).field("IActivityManagerSingleton").get() : (Singleton)Reflector.on(ActivityManagerNative.class).field("gDefault").get();
            IActivityManager origin = (IActivityManager)defaultSingleton.get();
            IActivityManager activityManagerProxy = (IActivityManager)Proxy.newProxyInstance(this.mContext.getClassLoader(), new Class[]{IActivityManager.class}, (InvocationHandler)this.createActivityManagerProxy(origin));
            Reflector.with(defaultSingleton).field("mInstance").set(activityManagerProxy);
            if (defaultSingleton.get() == activityManagerProxy) {
                this.mActivityManager = activityManagerProxy;
                Log.d((String)TAG, (String)("hookSystemServices succeed : " + this.mActivityManager));
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    protected void hookInstrumentationAndHandler() {
        try {
            ActivityThread activityThread = ActivityThread.currentActivityThread();
            Instrumentation baseInstrumentation = activityThread.getInstrumentation();
            VAInstrumentation instrumentation = this.createInstrumentation(baseInstrumentation);
            Reflector.with(activityThread).field("mInstrumentation").set((Object)instrumentation);
            Handler mainHandler = (Handler)Reflector.with(activityThread).method("getHandler", new Class[0]).call(new Object[0]);
            Reflector.with(mainHandler).field("mCallback").set((Object)instrumentation);
            this.mInstrumentation = instrumentation;
            Log.d((String)TAG, (String)("hookInstrumentationAndHandler succeed : " + (Object)((Object)this.mInstrumentation)));
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    protected void hookIContentProviderAsNeeded() {
        Uri uri = Uri.parse((String)RemoteContentProvider.getUri(this.mContext));
        this.mContext.getContentResolver().call(uri, "wakeup", null, null);
        try {
            Field authority = null;
            Field provider = null;
            ActivityThread activityThread = ActivityThread.currentActivityThread();
            Map providerMap = (Map)Reflector.with(activityThread).field("mProviderMap").get();
            for (Map.Entry entry : providerMap.entrySet()) {
                IContentProvider proxy;
                String auth;
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (key instanceof String) {
                    auth = (String)key;
                } else {
                    if (authority == null) {
                        authority = key.getClass().getDeclaredField("authority");
                        authority.setAccessible(true);
                    }
                    auth = (String)authority.get(key);
                }
                if (!auth.equals(RemoteContentProvider.getAuthority(this.mContext))) continue;
                if (provider == null) {
                    provider = val.getClass().getDeclaredField("mProvider");
                    provider.setAccessible(true);
                }
                IContentProvider rawProvider = (IContentProvider)provider.get(val);
                this.mIContentProvider = proxy = IContentProviderProxy.newInstance(this.mContext, rawProvider);
                Log.d((String)TAG, (String)("hookIContentProvider succeed : " + this.mIContentProvider));
                break;
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPlugin(File apk) throws Exception {
        LoadedPlugin plugin;
        if (null == apk) {
            throw new IllegalArgumentException("error : apk is null.");
        }
        if (!apk.exists()) {
            FileInputStream in = new FileInputStream(apk);
            ((InputStream)in).close();
        }
        if (null == (plugin = this.createLoadedPlugin(apk))) {
            throw new RuntimeException("Can't load plugin which is invalid: " + apk.getAbsolutePath());
        }
        this.mPlugins.put(plugin.getPackageName(), plugin);
        List<Callback> list = this.mCallbacks;
        synchronized (list) {
            for (int i = 0; i < this.mCallbacks.size(); ++i) {
                this.mCallbacks.get(i).onAddedLoadedPlugin(plugin);
            }
        }
    }

    public LoadedPlugin getLoadedPlugin(Intent intent) {
        return this.getLoadedPlugin(PluginUtil.getComponent(intent));
    }

    public LoadedPlugin getLoadedPlugin(ComponentName component) {
        if (component == null) {
            return null;
        }
        return this.getLoadedPlugin(component.getPackageName());
    }

    public LoadedPlugin getLoadedPlugin(String packageName) {
        return this.mPlugins.get(packageName);
    }

    public List<LoadedPlugin> getAllLoadedPlugins() {
        ArrayList<LoadedPlugin> list = new ArrayList<LoadedPlugin>();
        list.addAll(this.mPlugins.values());
        return list;
    }

    public Context getHostContext() {
        return this.mContext;
    }

    public VAInstrumentation getInstrumentation() {
        return this.mInstrumentation;
    }

    public IActivityManager getActivityManager() {
        return this.mActivityManager;
    }

    public synchronized IContentProvider getIContentProvider() {
        if (this.mIContentProvider == null) {
            this.hookIContentProviderAsNeeded();
        }
        return this.mIContentProvider;
    }

    public ComponentsHandler getComponentsHandler() {
        return this.mComponentsHandler;
    }

    public ResolveInfo resolveActivity(Intent intent) {
        return this.resolveActivity(intent, 0);
    }

    public ResolveInfo resolveActivity(Intent intent, int flags) {
        for (LoadedPlugin plugin : this.mPlugins.values()) {
            ResolveInfo resolveInfo = plugin.resolveActivity(intent, flags);
            if (null == resolveInfo) continue;
            return resolveInfo;
        }
        return null;
    }

    public ResolveInfo resolveService(Intent intent, int flags) {
        for (LoadedPlugin plugin : this.mPlugins.values()) {
            ResolveInfo resolveInfo = plugin.resolveService(intent, flags);
            if (null == resolveInfo) continue;
            return resolveInfo;
        }
        return null;
    }

    public ProviderInfo resolveContentProvider(String name, int flags) {
        for (LoadedPlugin plugin : this.mPlugins.values()) {
            ProviderInfo providerInfo = plugin.resolveContentProvider(name, flags);
            if (null == providerInfo) continue;
            return providerInfo;
        }
        return null;
    }

    @Deprecated
    public List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        for (LoadedPlugin plugin : this.mPlugins.values()) {
            List<ResolveInfo> result = plugin.queryIntentActivities(intent, flags);
            if (null == result || result.size() <= 0) continue;
            resolveInfos.addAll(result);
        }
        return resolveInfos;
    }

    @Deprecated
    public List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        for (LoadedPlugin plugin : this.mPlugins.values()) {
            List<ResolveInfo> result = plugin.queryIntentServices(intent, flags);
            if (null == result || result.size() <= 0) continue;
            resolveInfos.addAll(result);
        }
        return resolveInfos;
    }

    @Deprecated
    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        for (LoadedPlugin plugin : this.mPlugins.values()) {
            List<ResolveInfo> result = plugin.queryBroadcastReceivers(intent, flags);
            if (null == result || result.size() <= 0) continue;
            resolveInfos.addAll(result);
        }
        return resolveInfos;
    }

    public static interface Callback {
        public void onAddedLoadedPlugin(LoadedPlugin var1);
    }
}

