/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.utils;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipVerifyUtil {
    public static boolean verifyZip(Context context, String zipPath) {
        return ZipVerifyUtil.verifyZip(context, zipPath, "test.cer");
    }

    public static boolean verifyZip(Context context, String zipPath, String cerName) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            InputStream in = context.getAssets().open(cerName);
            Certificate certificate = certificateFactory.generateCertificate(in);
            in.close();
            return ZipVerifyUtil.verifyZip(zipPath, certificate);
        }
        catch (IOException | CertificateException e) {
            Log.w((String)"VA", (Throwable)e);
            return false;
        }
    }

    public static boolean verifyZip(String zipPath, Certificate remoteCertificate) {
        try {
            String certPath = ZipVerifyUtil.checkZipFileForCertificate(zipPath);
            Certificate certificate = ZipVerifyUtil.getCertificateFromZip(zipPath, certPath);
            remoteCertificate.verify(certificate.getPublicKey());
            return true;
        }
        catch (Exception e) {
            Log.w((String)"VA", (Throwable)e);
            return false;
        }
    }

    public static Certificate getCertificateFromZip(String zipPath, String certPath) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ZipFile zip = new ZipFile(new File(zipPath));
        InputStream in = zip.getInputStream(zip.getEntry(certPath));
        Certificate certificate = certificateFactory.generateCertificates(in).iterator().next();
        in.close();
        zip.close();
        return certificate;
    }

    public static String checkZipFileForCertificate(String zipPath) throws IOException {
        String certPath = "";
        ZipFile zip = new ZipFile(new File(zipPath));
        InputStream is = zip.getInputStream(zip.getEntry("META-INF/MANIFEST.MF"));
        Manifest man = new Manifest(is);
        is.close();
        HashSet<String> signed = new HashSet<String>();
        for (Map.Entry<String, Attributes> entry : man.getEntries().entrySet()) {
            for (Object attrkey : entry.getValue().keySet()) {
                if (!(attrkey instanceof Attributes.Name) || ((Attributes.Name)attrkey).toString().indexOf("-Digest") == -1) continue;
                signed.add(entry.getKey());
            }
        }
        HashSet<String> entries = new HashSet<String>();
        Enumeration<? extends ZipEntry> enumeration = zip.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry ze = enumeration.nextElement();
            if (ze.isDirectory()) continue;
            String name = ze.getName();
            if (!name.startsWith("META-INF/")) {
                entries.add(name);
                continue;
            }
            if (!name.endsWith(".RSA") && !name.endsWith(".DSA")) continue;
            certPath = name;
        }
        HashSet hashSet = new HashSet(entries);
        hashSet.removeAll(signed);
        HashSet missing = new HashSet(signed);
        missing.removeAll(entries);
        zip.close();
        if (hashSet.isEmpty() && missing.isEmpty()) {
            return certPath;
        }
        return null;
    }

    public static Certificate getCertificate(String certificatePath) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        FileInputStream in = new FileInputStream(certificatePath);
        Certificate certificate = certificateFactory.generateCertificate(in);
        in.close();
        return certificate;
    }

    private static byte[] decode(String base64) throws Exception {
        return Base64.decode((byte[])base64.getBytes(), (int)0);
    }
}

