/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal.utils;

import android.content.Context;
import android.content.pm.PackageParser;
import android.os.Build;
import com.didi.virtualapk.utils.Reflector;
import java.io.File;

public final class PackageParserCompat {
    public static final PackageParser.Package parsePackage(Context context, File apk, int flags) {
        try {
            if (Build.VERSION.SDK_INT >= 28 || Build.VERSION.SDK_INT == 27 && Build.VERSION.PREVIEW_SDK_INT != 0) {
                return PackageParserPPreview.parsePackage(context, apk, flags);
            }
            if (Build.VERSION.SDK_INT >= 24) {
                return PackageParserV24.parsePackage(context, apk, flags);
            }
            if (Build.VERSION.SDK_INT >= 21) {
                return PackageParserLollipop.parsePackage(context, apk, flags);
            }
            return PackageParserLegacy.parsePackage(context, apk, flags);
        }
        catch (Throwable e) {
            throw new RuntimeException("error", e);
        }
    }

    private static final class PackageParserLegacy {
        private PackageParserLegacy() {
        }

        static final PackageParser.Package parsePackage(Context context, File apk, int flags) throws Throwable {
            PackageParser parser = new PackageParser(apk.getAbsolutePath());
            PackageParser.Package pkg = parser.parsePackage(apk, apk.getAbsolutePath(), context.getResources().getDisplayMetrics(), flags);
            Reflector.with(parser).method("collectCertificates", PackageParser.Package.class, Integer.TYPE).call(pkg, flags);
            return pkg;
        }
    }

    private static final class PackageParserLollipop {
        private PackageParserLollipop() {
        }

        static final PackageParser.Package parsePackage(Context context, File apk, int flags) throws Throwable {
            PackageParser parser = new PackageParser();
            PackageParser.Package pkg = parser.parsePackage(apk, flags);
            parser.collectCertificates(pkg, flags);
            return pkg;
        }
    }

    private static final class PackageParserV24 {
        private PackageParserV24() {
        }

        static final PackageParser.Package parsePackage(Context context, File apk, int flags) throws Throwable {
            PackageParser parser = new PackageParser();
            PackageParser.Package pkg = parser.parsePackage(apk, flags);
            Reflector.with(parser).method("collectCertificates", PackageParser.Package.class, Integer.TYPE).call(pkg, flags);
            return pkg;
        }
    }

    private static final class PackageParserPPreview {
        private PackageParserPPreview() {
        }

        static final PackageParser.Package parsePackage(Context context, File apk, int flags) throws Throwable {
            PackageParser parser = new PackageParser();
            PackageParser.Package pkg = parser.parsePackage(apk, flags);
            Reflector.with(parser).method("collectCertificates", PackageParser.Package.class, Boolean.TYPE).call(pkg, false);
            return pkg;
        }
    }
}

