/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal.utils;

import android.app.ActivityThread;
import android.app.Application;
import android.os.Build;
import com.didi.virtualapk.utils.Reflector;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;

public class DexUtil {
    private static boolean sHasInsertedNativeLibrary = false;

    public static void insertDex(DexClassLoader dexClassLoader, ClassLoader baseClassLoader, File nativeLibsDir) throws Exception {
        Object baseDexElements = DexUtil.getDexElements(DexUtil.getPathList(baseClassLoader));
        Object newDexElements = DexUtil.getDexElements(DexUtil.getPathList((ClassLoader)dexClassLoader));
        Object allDexElements = DexUtil.combineArray(baseDexElements, newDexElements);
        Object pathList = DexUtil.getPathList(baseClassLoader);
        Reflector.with(pathList).field("dexElements").set(allDexElements);
        DexUtil.insertNativeLibrary(dexClassLoader, baseClassLoader, nativeLibsDir);
    }

    private static Object getDexElements(Object pathList) throws Exception {
        return Reflector.with(pathList).field("dexElements").get();
    }

    private static Object getPathList(ClassLoader baseDexClassLoader) throws Exception {
        return Reflector.with(baseDexClassLoader).field("pathList").get();
    }

    private static Object combineArray(Object firstArray, Object secondArray) {
        Class<?> localClass = firstArray.getClass().getComponentType();
        int firstArrayLength = Array.getLength(firstArray);
        int secondArrayLength = Array.getLength(secondArray);
        Object result = Array.newInstance(localClass, firstArrayLength + secondArrayLength);
        System.arraycopy(firstArray, 0, result, 0, firstArrayLength);
        System.arraycopy(secondArray, 0, result, firstArrayLength, secondArrayLength);
        return result;
    }

    private static synchronized void insertNativeLibrary(DexClassLoader dexClassLoader, ClassLoader baseClassLoader, File nativeLibsDir) throws Exception {
        if (sHasInsertedNativeLibrary) {
            return;
        }
        sHasInsertedNativeLibrary = true;
        Application context = ActivityThread.currentApplication();
        Object basePathList = DexUtil.getPathList(baseClassLoader);
        if (Build.VERSION.SDK_INT > 22) {
            Reflector reflector = Reflector.with(basePathList);
            List nativeLibraryDirectories = (List)reflector.field("nativeLibraryDirectories").get();
            nativeLibraryDirectories.add(nativeLibsDir);
            Object baseNativeLibraryPathElements = reflector.field("nativeLibraryPathElements").get();
            int baseArrayLength = Array.getLength(baseNativeLibraryPathElements);
            Object newPathList = DexUtil.getPathList((ClassLoader)dexClassLoader);
            Object newNativeLibraryPathElements = reflector.get(newPathList);
            Class<?> elementClass = newNativeLibraryPathElements.getClass().getComponentType();
            Object allNativeLibraryPathElements = Array.newInstance(elementClass, baseArrayLength + 1);
            System.arraycopy(baseNativeLibraryPathElements, 0, allNativeLibraryPathElements, 0, baseArrayLength);
            Field soPathField = Build.VERSION.SDK_INT >= 26 ? elementClass.getDeclaredField("path") : elementClass.getDeclaredField("dir");
            soPathField.setAccessible(true);
            int newArrayLength = Array.getLength(newNativeLibraryPathElements);
            for (int i = 0; i < newArrayLength; ++i) {
                Object element = Array.get(newNativeLibraryPathElements, i);
                String dir = ((File)soPathField.get(element)).getAbsolutePath();
                if (!dir.contains("valibs")) continue;
                Array.set(allNativeLibraryPathElements, baseArrayLength, element);
                break;
            }
            reflector.set(allNativeLibraryPathElements);
        } else {
            Reflector reflector = Reflector.with(basePathList).field("nativeLibraryDirectories");
            File[] nativeLibraryDirectories = (File[])reflector.get();
            int N = nativeLibraryDirectories.length;
            File[] newNativeLibraryDirectories = new File[N + 1];
            System.arraycopy(nativeLibraryDirectories, 0, newNativeLibraryDirectories, 0, N);
            newNativeLibraryDirectories[N] = nativeLibsDir;
            reflector.set(newNativeLibraryDirectories);
        }
    }
}

