/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.Instrumentation;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.util.Log;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.delegate.StubActivity;
import com.didi.virtualapk.internal.LoadedPlugin;
import com.didi.virtualapk.internal.utils.PluginUtil;
import com.didi.virtualapk.utils.Reflector;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class VAInstrumentation
extends Instrumentation
implements Handler.Callback {
    public static final String TAG = "VA.VAInstrumentation";
    public static final int LAUNCH_ACTIVITY = 100;
    protected Instrumentation mBase;
    protected final ArrayList<WeakReference<Activity>> mActivities = new ArrayList();
    protected PluginManager mPluginManager;

    public VAInstrumentation(PluginManager pluginManager, Instrumentation base) {
        this.mPluginManager = pluginManager;
        this.mBase = base;
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode) {
        this.injectIntent(intent);
        return this.mBase.execStartActivity(who, contextThread, token, target, intent, requestCode);
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options) {
        this.injectIntent(intent);
        return this.mBase.execStartActivity(who, contextThread, token, target, intent, requestCode, options);
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Fragment target, Intent intent, int requestCode, Bundle options) {
        this.injectIntent(intent);
        return this.mBase.execStartActivity(who, contextThread, token, target, intent, requestCode, options);
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, String target, Intent intent, int requestCode, Bundle options) {
        this.injectIntent(intent);
        return this.mBase.execStartActivity(who, contextThread, token, target, intent, requestCode, options);
    }

    protected void injectIntent(Intent intent) {
        this.mPluginManager.getComponentsHandler().transformIntentToExplicitAsNeeded(intent);
        if (intent.getComponent() != null) {
            Log.i((String)TAG, (String)String.format("execStartActivity[%s : %s]", intent.getComponent().getPackageName(), intent.getComponent().getClassName()));
            this.mPluginManager.getComponentsHandler().markIntentIfNeeded(intent);
        }
    }

    public Activity newActivity(ClassLoader cl, String className, Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            cl.loadClass(className);
            Log.i((String)TAG, (String)String.format("newActivity[%s]", className));
        }
        catch (ClassNotFoundException e) {
            ComponentName component = PluginUtil.getComponent(intent);
            if (component == null) {
                return this.newActivity(this.mBase.newActivity(cl, className, intent));
            }
            String targetClassName = component.getClassName();
            Log.i((String)TAG, (String)String.format("newActivity[%s : %s/%s]", className, component.getPackageName(), targetClassName));
            LoadedPlugin plugin = this.mPluginManager.getLoadedPlugin(component);
            if (plugin == null) {
                boolean debuggable = false;
                try {
                    Context context = this.mPluginManager.getHostContext();
                    debuggable = (context.getApplicationInfo().flags & 2) != 0;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (debuggable) {
                    throw new ActivityNotFoundException("error intent: " + intent.toURI());
                }
                Log.i((String)TAG, (String)("Not found. starting the stub activity: " + StubActivity.class));
                return this.newActivity(this.mBase.newActivity(cl, StubActivity.class.getName(), intent));
            }
            Activity activity = this.mBase.newActivity(plugin.getClassLoader(), targetClassName, intent);
            activity.setIntent(intent);
            Reflector.QuietReflector.with(activity).field("mResources").set(plugin.getResources());
            return this.newActivity(activity);
        }
        return this.newActivity(this.mBase.newActivity(cl, className, intent));
    }

    public Application newApplication(ClassLoader cl, String className, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.mBase.newApplication(cl, className, context);
    }

    public void callActivityOnCreate(Activity activity, Bundle icicle) {
        this.injectActivity(activity);
        this.mBase.callActivityOnCreate(activity, icicle);
    }

    @TargetApi(value=21)
    public void callActivityOnCreate(Activity activity, Bundle icicle, PersistableBundle persistentState) {
        this.injectActivity(activity);
        this.mBase.callActivityOnCreate(activity, icicle, persistentState);
    }

    protected void injectActivity(Activity activity) {
        Intent intent = activity.getIntent();
        if (PluginUtil.isIntentFromPlugin(intent)) {
            Context base = activity.getBaseContext();
            try {
                LoadedPlugin plugin = this.mPluginManager.getLoadedPlugin(intent);
                Reflector.with(base).field("mResources").set(plugin.getResources());
                Reflector reflector = Reflector.with(activity);
                reflector.field("mBase").set((Object)plugin.createPluginContext(activity.getBaseContext()));
                reflector.field("mApplication").set(plugin.getApplication());
                ActivityInfo activityInfo = plugin.getActivityInfo(PluginUtil.getComponent(intent));
                if (activityInfo.screenOrientation != -1) {
                    activity.setRequestedOrientation(activityInfo.screenOrientation);
                }
                ComponentName component = PluginUtil.getComponent(intent);
                Intent wrapperIntent = new Intent(intent);
                wrapperIntent.setClassName(component.getPackageName(), component.getClassName());
                activity.setIntent(wrapperIntent);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 100) {
            Object r = msg.obj;
            try {
                int theme;
                Reflector reflector = Reflector.with(r);
                Intent intent = (Intent)reflector.field("intent").get();
                intent.setExtrasClassLoader(this.mPluginManager.getHostContext().getClassLoader());
                ActivityInfo activityInfo = (ActivityInfo)reflector.field("activityInfo").get();
                if (PluginUtil.isIntentFromPlugin(intent) && (theme = PluginUtil.getTheme(this.mPluginManager.getHostContext(), intent)) != 0) {
                    Log.i((String)TAG, (String)("resolve theme, current theme:" + activityInfo.theme + "  after :0x" + Integer.toHexString(theme)));
                    activityInfo.theme = theme;
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return false;
    }

    public Context getContext() {
        return this.mBase.getContext();
    }

    public Context getTargetContext() {
        return this.mBase.getTargetContext();
    }

    public ComponentName getComponentName() {
        return this.mBase.getComponentName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Activity newActivity(Activity activity) {
        ArrayList<WeakReference<Activity>> arrayList = this.mActivities;
        synchronized (arrayList) {
            for (int i = this.mActivities.size() - 1; i >= 0; --i) {
                if (this.mActivities.get(i).get() != null) continue;
                this.mActivities.remove(i);
            }
            this.mActivities.add(new WeakReference<Activity>(activity));
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<WeakReference<Activity>> getActivities() {
        ArrayList<WeakReference<Activity>> arrayList = this.mActivities;
        synchronized (arrayList) {
            return new ArrayList<WeakReference<Activity>>(this.mActivities);
        }
    }
}

