/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityThread;
import android.app.LoadedApk;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.content.res.ResourcesKey;
import android.os.Build;
import android.util.ArrayMap;
import android.util.DisplayMetrics;
import android.util.Log;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.internal.LoadedPlugin;
import com.didi.virtualapk.utils.Reflector;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class ResourcesManager {
    public static final String TAG = "VA.LoadedPlugin";
    private static Configuration mDefaultConfiguration;

    ResourcesManager() {
    }

    public static synchronized Resources createResources(Context hostContext, String packageName, File apk) throws Exception {
        if (Build.VERSION.SDK_INT >= 24) {
            return ResourcesManager.createResourcesForN(hostContext, packageName, apk);
        }
        Resources resources = ResourcesManager.createResourcesSimple(hostContext, apk.getAbsolutePath());
        ResourcesManager.hookResources(hostContext, resources);
        return resources;
    }

    private static Resources createResourcesSimple(Context hostContext, String apk) throws Exception {
        AssetManager assetManager;
        Resources hostResources = hostContext.getResources();
        Resources newResources = null;
        Reflector reflector = Reflector.on(AssetManager.class).method("addAssetPath", String.class);
        if (Build.VERSION.SDK_INT < 21) {
            assetManager = (AssetManager)AssetManager.class.newInstance();
            reflector.bind(assetManager);
            int cookie1 = (Integer)reflector.call(hostContext.getApplicationInfo().sourceDir);
            if (cookie1 == 0) {
                throw new RuntimeException("createResources failed, can't addAssetPath for " + hostContext.getApplicationInfo().sourceDir);
            }
        } else {
            assetManager = hostResources.getAssets();
            reflector.bind(assetManager);
        }
        int cookie2 = (Integer)reflector.call(apk);
        if (cookie2 == 0) {
            throw new RuntimeException("createResources failed, can't addAssetPath for " + apk);
        }
        List<LoadedPlugin> pluginList = PluginManager.getInstance(hostContext).getAllLoadedPlugins();
        for (LoadedPlugin plugin : pluginList) {
            int cookie3 = (Integer)reflector.call(plugin.getLocation());
            if (cookie3 != 0) continue;
            throw new RuntimeException("createResources failed, can't addAssetPath for " + plugin.getLocation());
        }
        newResources = ResourcesManager.isMiUi(hostResources) ? MiUiResourcesCompat.createResources(hostResources, assetManager) : (ResourcesManager.isVivo(hostResources) ? VivoResourcesCompat.createResources(hostContext, hostResources, assetManager) : (ResourcesManager.isNubia(hostResources) ? NubiaResourcesCompat.createResources(hostResources, assetManager) : (ResourcesManager.isNotRawResources(hostResources) ? AdaptationResourcesCompat.createResources(hostResources, assetManager) : new Resources(assetManager, hostResources.getDisplayMetrics(), hostResources.getConfiguration()))));
        for (LoadedPlugin plugin : pluginList) {
            plugin.updateResources(newResources);
        }
        return newResources;
    }

    public static void hookResources(Context base, Resources resources) {
        if (Build.VERSION.SDK_INT >= 24) {
            return;
        }
        try {
            Reflector reflector = Reflector.with(base);
            reflector.field("mResources").set(resources);
            Object loadedApk = reflector.field("mPackageInfo").get();
            Reflector.with(loadedApk).field("mResources").set(resources);
            ActivityThread activityThread = ActivityThread.currentActivityThread();
            Object resManager = Build.VERSION.SDK_INT >= 19 ? android.app.ResourcesManager.getInstance() : Reflector.with(activityThread).field("mResourcesManager").get();
            Map map = (Map)Reflector.with(resManager).field("mActiveResources").get();
            Object key = map.keySet().iterator().next();
            map.put(key, new WeakReference<Resources>(resources));
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=24)
    private static Resources createResourcesForN(Context context, String packageName, File apk) throws Exception {
        long startTime = System.currentTimeMillis();
        String newAssetPath = apk.getAbsolutePath();
        ApplicationInfo info = context.getApplicationInfo();
        String baseResDir = info.publicSourceDir;
        info.splitSourceDirs = ResourcesManager.append(info.splitSourceDirs, newAssetPath);
        LoadedApk loadedApk = (LoadedApk)Reflector.with(context).field("mPackageInfo").get();
        Reflector rLoadedApk = Reflector.with(loadedApk).field("mSplitResDirs");
        String[] splitResDirs = (String[])rLoadedApk.get();
        rLoadedApk.set(ResourcesManager.append(splitResDirs, newAssetPath));
        android.app.ResourcesManager resourcesManager = android.app.ResourcesManager.getInstance();
        ArrayMap originalMap = (ArrayMap)Reflector.with(resourcesManager).field("mResourceImpls").get();
        android.app.ResourcesManager resourcesManager2 = resourcesManager;
        synchronized (resourcesManager2) {
            HashMap<ResourcesKey, WeakReference<ResourcesImpl>> resolvedMap = new HashMap<ResourcesKey, WeakReference<ResourcesImpl>>();
            if (Build.VERSION.SDK_INT >= 28 || Build.VERSION.SDK_INT == 27 && Build.VERSION.PREVIEW_SDK_INT != 0) {
                ResourcesManagerCompatForP.resolveResourcesImplMap((Map<ResourcesKey, WeakReference<ResourcesImpl>>)originalMap, resolvedMap, context, loadedApk);
            } else {
                ResourcesManagerCompatForN.resolveResourcesImplMap((Map<ResourcesKey, WeakReference<ResourcesImpl>>)originalMap, resolvedMap, baseResDir, newAssetPath);
            }
            originalMap.clear();
            originalMap.putAll(resolvedMap);
        }
        android.app.ResourcesManager.getInstance().appendLibAssetForMainAssetPath(baseResDir, packageName + ".vastub");
        Resources newResources = context.getResources();
        for (LoadedPlugin plugin : PluginManager.getInstance(context).getAllLoadedPlugins()) {
            plugin.updateResources(newResources);
        }
        Log.d((String)TAG, (String)("createResourcesForN cost time: +" + (System.currentTimeMillis() - startTime) + "ms"));
        return newResources;
    }

    private static String[] append(String[] paths, String newPath) {
        if (ResourcesManager.contains(paths, newPath)) {
            return paths;
        }
        int newPathsCount = 1 + (paths != null ? paths.length : 0);
        String[] newPaths = new String[newPathsCount];
        if (paths != null) {
            System.arraycopy(paths, 0, newPaths, 0, paths.length);
        }
        newPaths[newPathsCount - 1] = newPath;
        return newPaths;
    }

    @TargetApi(value=19)
    private static boolean contains(String[] array, String value) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!Objects.equals(array[i], value)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMiUi(Resources resources) {
        return resources.getClass().getName().equals("android.content.res.MiuiResources");
    }

    private static boolean isVivo(Resources resources) {
        return resources.getClass().getName().equals("android.content.res.VivoResources");
    }

    private static boolean isNubia(Resources resources) {
        return resources.getClass().getName().equals("android.content.res.NubiaResources");
    }

    private static boolean isNotRawResources(Resources resources) {
        return !resources.getClass().getName().equals("android.content.res.Resources");
    }

    private static final class ResourcesManagerCompatForP {
        private ResourcesManagerCompatForP() {
        }

        @TargetApi(value=17)
        public static void resolveResourcesImplMap(Map<ResourcesKey, WeakReference<ResourcesImpl>> originalMap, Map<ResourcesKey, WeakReference<ResourcesImpl>> resolvedMap, Context context, LoadedApk loadedApk) throws Exception {
            HashMap<ResourcesImpl, Object> newResImplMap = new HashMap<ResourcesImpl, Object>();
            HashMap resKeyMap = new HashMap();
            if (mDefaultConfiguration == null) {
                mDefaultConfiguration = new Configuration();
            }
            Resources newRes = context.createConfigurationContext(mDefaultConfiguration).getResources();
            newResImplMap.put(newRes.getImpl(), context);
            for (WeakReference<Activity> weakReference : PluginManager.getInstance(context).getInstrumentation().getActivities()) {
                Activity activity = (Activity)weakReference.get();
                if (activity == null) continue;
                newRes = activity.createConfigurationContext(activity.getResources().getConfiguration()).getResources();
                newResImplMap.put(newRes.getImpl(), activity);
            }
            for (Map.Entry entry : originalMap.entrySet()) {
                ResourcesImpl resImpl = (ResourcesImpl)((WeakReference)entry.getValue()).get();
                if (resImpl != null) {
                    resKeyMap.put(resImpl, entry.getKey());
                }
                resolvedMap.put((ResourcesKey)entry.getKey(), (WeakReference<ResourcesImpl>)entry.getValue());
            }
            for (Map.Entry entry : newResImplMap.entrySet()) {
                ResourcesKey newKey = (ResourcesKey)resKeyMap.get(entry.getKey());
                ResourcesImpl originResImpl = ((Context)entry.getValue()).getResources().getImpl();
                resolvedMap.put(newKey, new WeakReference<ResourcesImpl>(originResImpl));
                resolvedMap.remove(resKeyMap.get(originResImpl));
            }
        }
    }

    private static final class ResourcesManagerCompatForN {
        private ResourcesManagerCompatForN() {
        }

        @TargetApi(value=19)
        public static void resolveResourcesImplMap(Map<ResourcesKey, WeakReference<ResourcesImpl>> originalMap, Map<ResourcesKey, WeakReference<ResourcesImpl>> resolvedMap, String baseResDir, String newAssetPath) throws Exception {
            for (Map.Entry<ResourcesKey, WeakReference<ResourcesImpl>> entry : originalMap.entrySet()) {
                ResourcesKey key = entry.getKey();
                if (Objects.equals(key.mResDir, baseResDir)) {
                    resolvedMap.put(new ResourcesKey(key.mResDir, ResourcesManager.append(key.mSplitResDirs, newAssetPath), key.mOverlayDirs, key.mLibDirs, key.mDisplayId, key.mOverrideConfiguration, key.mCompatInfo), entry.getValue());
                    continue;
                }
                resolvedMap.put(key, entry.getValue());
            }
        }
    }

    private static final class AdaptationResourcesCompat {
        private AdaptationResourcesCompat() {
        }

        private static Resources createResources(Resources hostResources, AssetManager assetManager) throws Exception {
            Resources newResources;
            try {
                Reflector reflector = Reflector.with(hostResources);
                newResources = (Resources)reflector.constructor(AssetManager.class, DisplayMetrics.class, Configuration.class).newInstance(assetManager, hostResources.getDisplayMetrics(), hostResources.getConfiguration());
            }
            catch (Exception e) {
                newResources = new Resources(assetManager, hostResources.getDisplayMetrics(), hostResources.getConfiguration());
            }
            return newResources;
        }
    }

    private static final class NubiaResourcesCompat {
        private NubiaResourcesCompat() {
        }

        private static Resources createResources(Resources hostResources, AssetManager assetManager) throws Exception {
            Reflector reflector = Reflector.on("android.content.res.NubiaResources");
            Resources newResources = (Resources)reflector.constructor(AssetManager.class, DisplayMetrics.class, Configuration.class).newInstance(assetManager, hostResources.getDisplayMetrics(), hostResources.getConfiguration());
            return newResources;
        }
    }

    private static final class VivoResourcesCompat {
        private VivoResourcesCompat() {
        }

        private static Resources createResources(Context hostContext, Resources hostResources, AssetManager assetManager) throws Exception {
            Reflector reflector = Reflector.on("android.content.res.VivoResources");
            Resources newResources = (Resources)reflector.constructor(AssetManager.class, DisplayMetrics.class, Configuration.class).newInstance(assetManager, hostResources.getDisplayMetrics(), hostResources.getConfiguration());
            reflector.method("init", String.class).callByCaller(newResources, hostContext.getPackageName());
            reflector.field("mThemeValues");
            reflector.set(newResources, reflector.get(hostResources));
            return newResources;
        }
    }

    private static final class MiUiResourcesCompat {
        private MiUiResourcesCompat() {
        }

        private static Resources createResources(Resources hostResources, AssetManager assetManager) throws Exception {
            Reflector reflector = Reflector.on("android.content.res.MiuiResources");
            Resources newResources = (Resources)reflector.constructor(AssetManager.class, DisplayMetrics.class, Configuration.class).newInstance(assetManager, hostResources.getDisplayMetrics(), hostResources.getConfiguration());
            return newResources;
        }
    }
}

