/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal;

import android.annotation.TargetApi;
import android.content.ContentResolverWrapper;
import android.content.Context;
import android.content.IContentProvider;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Keep;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.delegate.RemoteContentProvider;
import com.didi.virtualapk.internal.LoadedPlugin;

public class PluginContentResolver
extends ContentResolverWrapper {
    private PluginManager mPluginManager;

    public PluginContentResolver(Context context) {
        super(context);
        this.mPluginManager = PluginManager.getInstance(context);
    }

    @Override
    protected IContentProvider acquireProvider(Context context, String auth) {
        if (this.mPluginManager.resolveContentProvider(auth, 0) != null) {
            return this.mPluginManager.getIContentProvider();
        }
        return super.acquireProvider(context, auth);
    }

    @Override
    protected IContentProvider acquireExistingProvider(Context context, String auth) {
        if (this.mPluginManager.resolveContentProvider(auth, 0) != null) {
            return this.mPluginManager.getIContentProvider();
        }
        return super.acquireExistingProvider(context, auth);
    }

    @Override
    @TargetApi(value=16)
    protected IContentProvider acquireUnstableProvider(Context context, String auth) {
        if (this.mPluginManager.resolveContentProvider(auth, 0) != null) {
            return this.mPluginManager.getIContentProvider();
        }
        return super.acquireUnstableProvider(context, auth);
    }

    @Override
    public boolean releaseProvider(IContentProvider provider) {
        return true;
    }

    @Override
    @TargetApi(value=16)
    public boolean releaseUnstableProvider(IContentProvider icp) {
        return true;
    }

    @Override
    @TargetApi(value=16)
    public void unstableProviderDied(IContentProvider icp) {
    }

    @Override
    @TargetApi(value=20)
    public void appNotRespondingViaProvider(IContentProvider icp) {
    }

    protected int resolveUserIdFromAuthority(String auth) {
        return 0;
    }

    @Keep
    public static Uri wrapperUri(LoadedPlugin loadedPlugin, Uri pluginUri) {
        String pkg = loadedPlugin.getPackageName();
        String pluginUriString = Uri.encode((String)pluginUri.toString());
        StringBuilder builder = new StringBuilder(RemoteContentProvider.getUri(loadedPlugin.getHostContext()));
        builder.append("/?plugin=" + loadedPlugin.getLocation());
        builder.append("&pkg=" + pkg);
        builder.append("&uri=" + pluginUriString);
        Uri wrapperUri = Uri.parse((String)builder.toString());
        return wrapperUri;
    }

    @Deprecated
    public static String getAuthority(Context context) {
        return RemoteContentProvider.getAuthority(context);
    }

    @Deprecated
    public static String getUri(Context context) {
        return RemoteContentProvider.getUri(context);
    }

    @Keep
    public static Bundle getBundleForCall(Uri uri) {
        Bundle bundle = new Bundle();
        bundle.putString("wrapper_uri", uri.toString());
        return bundle;
    }
}

