/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal;

import android.app.Activity;
import android.app.ActivityThread;
import android.app.Application;
import android.os.Bundle;
import com.didi.virtualapk.utils.Reflector;
import java.util.ArrayList;

class ActivityLifecycleCallbacksProxy
implements Application.ActivityLifecycleCallbacks {
    final ArrayList<Application.ActivityLifecycleCallbacks> mActivityLifecycleCallbacks = (ArrayList)Reflector.QuietReflector.with(ActivityThread.currentApplication()).field("mActivityLifecycleCallbacks").get();

    ActivityLifecycleCallbacksProxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] collectActivityLifecycleCallbacks() {
        if (this.mActivityLifecycleCallbacks == null) {
            return null;
        }
        Object[] callbacks = null;
        ArrayList<Application.ActivityLifecycleCallbacks> arrayList = this.mActivityLifecycleCallbacks;
        synchronized (arrayList) {
            if (this.mActivityLifecycleCallbacks.size() > 0) {
                callbacks = this.mActivityLifecycleCallbacks.toArray();
            }
        }
        return callbacks;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityCreated(activity, savedInstanceState);
            }
        }
    }

    public void onActivityStarted(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityStarted(activity);
            }
        }
    }

    public void onActivityResumed(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityResumed(activity);
            }
        }
    }

    public void onActivityPaused(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPaused(activity);
            }
        }
    }

    public void onActivityStopped(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityStopped(activity);
            }
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivitySaveInstanceState(activity, outState);
            }
        }
    }

    public void onActivityDestroyed(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityDestroyed(activity);
            }
        }
    }
}

