/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.utils;

import android.content.Context;
import android.content.pm.PackageParser;
import android.os.Build;
import com.didi.virtualapk.utils.ReflectUtil;
import java.io.File;

public final class PackageParserCompat {
    public static final PackageParser.Package parsePackage(Context context, File apk, int flags) throws PackageParser.PackageParserException {
        if (Build.VERSION.SDK_INT >= 24) {
            if (Build.VERSION.PREVIEW_SDK_INT == 0) {
                return PackageParserV24.parsePackage(context, apk, flags);
            }
            return PackageParserPPreview.parsePackage(context, apk, flags);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return PackageParserLollipop.parsePackage(context, apk, flags);
        }
        return PackageParserLegacy.parsePackage(context, apk, flags);
    }

    private static final class PackageParserLegacy {
        private PackageParserLegacy() {
        }

        static final PackageParser.Package parsePackage(Context context, File apk, int flags) {
            PackageParser parser = new PackageParser(apk.getAbsolutePath());
            PackageParser.Package pkg = parser.parsePackage(apk, apk.getAbsolutePath(), context.getResources().getDisplayMetrics(), flags);
            ReflectUtil.invokeNoException(PackageParser.class, parser, "collectCertificates", new Class[]{PackageParser.Package.class, Integer.TYPE}, pkg, flags);
            return pkg;
        }
    }

    private static final class PackageParserLollipop {
        private PackageParserLollipop() {
        }

        static final PackageParser.Package parsePackage(Context context, File apk, int flags) throws PackageParser.PackageParserException {
            PackageParser parser = new PackageParser();
            PackageParser.Package pkg = parser.parsePackage(apk, flags);
            try {
                parser.collectCertificates(pkg, flags);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return pkg;
        }
    }

    private static final class PackageParserV24 {
        private PackageParserV24() {
        }

        static final PackageParser.Package parsePackage(Context context, File apk, int flags) throws PackageParser.PackageParserException {
            PackageParser parser = new PackageParser();
            PackageParser.Package pkg = parser.parsePackage(apk, flags);
            ReflectUtil.invokeNoException(PackageParser.class, null, "collectCertificates", new Class[]{PackageParser.Package.class, Integer.TYPE}, pkg, flags);
            return pkg;
        }
    }

    private static final class PackageParserPPreview {
        private PackageParserPPreview() {
        }

        static final PackageParser.Package parsePackage(Context context, File apk, int flags) throws PackageParser.PackageParserException {
            PackageParser parser = new PackageParser();
            PackageParser.Package pkg = parser.parsePackage(apk, flags);
            ReflectUtil.invokeNoException(PackageParser.class, null, "collectCertificates", new Class[]{PackageParser.Package.class, Boolean.TYPE}, pkg, false);
            return pkg;
        }
    }
}

