/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal;

import android.app.Activity;
import android.app.Fragment;
import android.app.Instrumentation;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;
import android.view.ContextThemeWrapper;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.internal.LoadedPlugin;
import com.didi.virtualapk.utils.PluginUtil;
import com.didi.virtualapk.utils.ReflectUtil;

public class VAInstrumentation
extends Instrumentation
implements Handler.Callback {
    public static final String TAG = "VAInstrumentation";
    public static final int LAUNCH_ACTIVITY = 100;
    private Instrumentation mBase;
    PluginManager mPluginManager;

    public VAInstrumentation(PluginManager pluginManager, Instrumentation base) {
        this.mPluginManager = pluginManager;
        this.mBase = base;
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options) {
        this.mPluginManager.getComponentsHandler().transformIntentToExplicitAsNeeded(intent);
        if (intent.getComponent() != null) {
            Log.i((String)TAG, (String)String.format("execStartActivity[%s : %s]", intent.getComponent().getPackageName(), intent.getComponent().getClassName()));
            this.mPluginManager.getComponentsHandler().markIntentIfNeeded(intent);
        }
        Instrumentation.ActivityResult result = this.realExecStartActivity(who, contextThread, token, target, intent, requestCode, options);
        return result;
    }

    private Instrumentation.ActivityResult realExecStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options) {
        Instrumentation.ActivityResult result = null;
        try {
            Class[] parameterTypes = new Class[]{Context.class, IBinder.class, IBinder.class, Activity.class, Intent.class, Integer.TYPE, Bundle.class};
            result = (Instrumentation.ActivityResult)ReflectUtil.invoke(Instrumentation.class, (Object)this.mBase, "execStartActivity", parameterTypes, new Object[]{who, contextThread, token, target, intent, requestCode, options});
        }
        catch (Exception e) {
            if (e.getCause() instanceof ActivityNotFoundException) {
                throw (ActivityNotFoundException)e.getCause();
            }
            e.printStackTrace();
        }
        return result;
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Fragment target, Intent intent, int requestCode, Bundle options) {
        this.mPluginManager.getComponentsHandler().transformIntentToExplicitAsNeeded(intent);
        if (intent.getComponent() != null) {
            Log.i((String)TAG, (String)String.format("execStartActivity[%s : %s]", intent.getComponent().getPackageName(), intent.getComponent().getClassName()));
            this.mPluginManager.getComponentsHandler().markIntentIfNeeded(intent);
        }
        Instrumentation.ActivityResult result = this.realExecStartActivity(who, contextThread, token, target, intent, requestCode, options);
        return result;
    }

    private Instrumentation.ActivityResult realExecStartActivity(Context who, IBinder contextThread, IBinder token, Fragment target, Intent intent, int requestCode, Bundle options) {
        Instrumentation.ActivityResult result = null;
        try {
            Class[] parameterTypes = new Class[]{Context.class, IBinder.class, IBinder.class, Fragment.class, Intent.class, Integer.TYPE, Bundle.class};
            result = (Instrumentation.ActivityResult)ReflectUtil.invoke(Instrumentation.class, (Object)this.mBase, "execStartActivity", parameterTypes, new Object[]{who, contextThread, token, target, intent, requestCode, options});
        }
        catch (Exception e) {
            if (e.getCause() instanceof ActivityNotFoundException) {
                throw (ActivityNotFoundException)e.getCause();
            }
            e.printStackTrace();
        }
        return result;
    }

    private Instrumentation.ActivityResult realExecStartActivity(Context who, IBinder contextThread, IBinder token, String target, Intent intent, int requestCode, Bundle options) {
        Instrumentation.ActivityResult result = null;
        try {
            Class[] parameterTypes = new Class[]{Context.class, IBinder.class, IBinder.class, String.class, Intent.class, Integer.TYPE, Bundle.class};
            result = (Instrumentation.ActivityResult)ReflectUtil.invoke(Instrumentation.class, (Object)this.mBase, "execStartActivity", parameterTypes, new Object[]{who, contextThread, token, target, intent, requestCode, options});
        }
        catch (Exception e) {
            if (e.getCause() instanceof ActivityNotFoundException) {
                throw (ActivityNotFoundException)e.getCause();
            }
            e.printStackTrace();
        }
        return result;
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, String target, Intent intent, int requestCode, Bundle options) {
        this.mPluginManager.getComponentsHandler().transformIntentToExplicitAsNeeded(intent);
        if (intent.getComponent() != null) {
            Log.i((String)TAG, (String)String.format("execStartActivity[%s : %s]", intent.getComponent().getPackageName(), intent.getComponent().getClassName()));
            this.mPluginManager.getComponentsHandler().markIntentIfNeeded(intent);
        }
        Instrumentation.ActivityResult result = this.realExecStartActivity(who, contextThread, token, target, intent, requestCode, options);
        return null;
    }

    public Activity newActivity(ClassLoader cl, String className, Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        block4: {
            try {
                cl.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                ComponentName component = PluginUtil.getComponent(intent);
                LoadedPlugin plugin = this.mPluginManager.getLoadedPlugin(component);
                String targetClassName = component.getClassName();
                Log.i((String)TAG, (String)String.format("newActivity[%s : %s/%s]", className, component.getPackageName(), targetClassName));
                if (plugin == null) break block4;
                Activity activity = this.mBase.newActivity(plugin.getClassLoader(), targetClassName, intent);
                activity.setIntent(intent);
                try {
                    ReflectUtil.setField(ContextThemeWrapper.class, activity, "mResources", plugin.getResources());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return activity;
            }
        }
        return this.mBase.newActivity(cl, className, intent);
    }

    public void callActivityOnCreate(Activity activity, Bundle icicle) {
        Intent intent = activity.getIntent();
        if (PluginUtil.isIntentFromPlugin(intent)) {
            Context base = activity.getBaseContext();
            try {
                LoadedPlugin plugin = this.mPluginManager.getLoadedPlugin(intent);
                ReflectUtil.setField(base.getClass(), base, "mResources", plugin.getResources());
                ReflectUtil.setField(ContextWrapper.class, activity, "mBase", plugin.getPluginContext());
                ReflectUtil.setField(Activity.class, activity, "mApplication", plugin.getApplication());
                ReflectUtil.setFieldNoException(ContextThemeWrapper.class, activity, "mBase", plugin.getPluginContext());
                ActivityInfo activityInfo = plugin.getActivityInfo(PluginUtil.getComponent(intent));
                if (activityInfo.screenOrientation != -1) {
                    activity.setRequestedOrientation(activityInfo.screenOrientation);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mBase.callActivityOnCreate(activity, icicle);
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 100) {
            Object r = msg.obj;
            try {
                int theme;
                Intent intent = (Intent)ReflectUtil.getField(r.getClass(), r, "intent");
                intent.setExtrasClassLoader(VAInstrumentation.class.getClassLoader());
                ActivityInfo activityInfo = (ActivityInfo)ReflectUtil.getField(r.getClass(), r, "activityInfo");
                if (PluginUtil.isIntentFromPlugin(intent) && (theme = PluginUtil.getTheme(this.mPluginManager.getHostContext(), intent)) != 0) {
                    Log.i((String)TAG, (String)("resolve theme, current theme:" + activityInfo.theme + "  after :0x" + Integer.toHexString(theme)));
                    activityInfo.theme = theme;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public Context getContext() {
        return this.mBase.getContext();
    }

    public Context getTargetContext() {
        return this.mBase.getTargetContext();
    }

    public ComponentName getComponentName() {
        return this.mBase.getComponentName();
    }
}

