/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Keep;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.internal.LoadedPlugin;
import java.lang.reflect.Method;

public class PluginContentResolver
extends ContentResolver {
    private ContentResolver mBase;
    private PluginManager mPluginManager;
    private static Method sAcquireProvider;
    private static Method sAcquireExistingProvider;
    private static Method sAcquireUnstableProvider;

    public PluginContentResolver(Context context) {
        super(context);
        this.mBase = context.getContentResolver();
        this.mPluginManager = PluginManager.getInstance(context);
    }

    protected IContentProvider acquireProvider(Context context, String auth) {
        try {
            if (this.mPluginManager.resolveContentProvider(auth, 0) != null) {
                return this.mPluginManager.getIContentProvider();
            }
            return (IContentProvider)sAcquireProvider.invoke((Object)this.mBase, context, auth);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IContentProvider acquireExistingProvider(Context context, String auth) {
        try {
            if (this.mPluginManager.resolveContentProvider(auth, 0) != null) {
                return this.mPluginManager.getIContentProvider();
            }
            return (IContentProvider)sAcquireExistingProvider.invoke((Object)this.mBase, context, auth);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IContentProvider acquireUnstableProvider(Context context, String auth) {
        try {
            if (this.mPluginManager.resolveContentProvider(auth, 0) != null) {
                return this.mPluginManager.getIContentProvider();
            }
            return (IContentProvider)sAcquireUnstableProvider.invoke((Object)this.mBase, context, auth);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean releaseProvider(IContentProvider provider) {
        return true;
    }

    public boolean releaseUnstableProvider(IContentProvider icp) {
        return true;
    }

    public void unstableProviderDied(IContentProvider icp) {
    }

    public void appNotRespondingViaProvider(IContentProvider icp) {
    }

    protected int resolveUserIdFromAuthority(String auth) {
        return 0;
    }

    @Keep
    public static Uri wrapperUri(LoadedPlugin loadedPlugin, Uri pluginUri) {
        String pkg = loadedPlugin.getPackageName();
        String pluginUriString = Uri.encode((String)pluginUri.toString());
        StringBuilder builder = new StringBuilder(PluginContentResolver.getUri(loadedPlugin.getHostContext()));
        builder.append("/?plugin=" + loadedPlugin.getLocation());
        builder.append("&pkg=" + pkg);
        builder.append("&uri=" + pluginUriString);
        Uri wrapperUri = Uri.parse((String)builder.toString());
        return wrapperUri;
    }

    @Deprecated
    public static String getAuthority(Context context) {
        return context.getPackageName() + ".VirtualAPK.Provider";
    }

    @Deprecated
    public static String getUri(Context context) {
        return "content://" + PluginContentResolver.getAuthority(context);
    }

    @Keep
    public static Bundle getBundleForCall(Uri uri) {
        Bundle bundle = new Bundle();
        bundle.putString("wrapper_uri", uri.toString());
        return bundle;
    }

    static {
        try {
            sAcquireProvider = ContentResolver.class.getDeclaredMethod("acquireProvider", Context.class, String.class);
            sAcquireProvider.setAccessible(true);
            sAcquireExistingProvider = ContentResolver.class.getDeclaredMethod("acquireExistingProvider", Context.class, String.class);
            sAcquireExistingProvider.setAccessible(true);
            sAcquireUnstableProvider = ContentResolver.class.getDeclaredMethod("acquireUnstableProvider", Context.class, String.class);
            sAcquireUnstableProvider.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

