/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.delegate;

import android.content.Context;
import android.content.IContentProvider;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.internal.LoadedPlugin;
import com.didi.virtualapk.internal.PluginContentResolver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;

public class IContentProviderProxy
implements InvocationHandler {
    private static final String TAG = "IContentProviderProxy";
    private IContentProvider mBase;
    private Context mContext;

    private IContentProviderProxy(Context context, IContentProvider iContentProvider) {
        this.mBase = iContentProvider;
        this.mContext = context;
    }

    public static IContentProvider newInstance(Context context, IContentProvider iContentProvider) {
        return (IContentProvider)Proxy.newProxyInstance(iContentProvider.getClass().getClassLoader(), new Class[]{IContentProvider.class}, (InvocationHandler)new IContentProviderProxy(context, iContentProvider));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Log.v((String)TAG, (String)(method.toGenericString() + " : " + Arrays.toString(args)));
        this.wrapperUri(method, args);
        try {
            return method.invoke((Object)this.mBase, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private void wrapperUri(Method method, Object[] args) {
        String uriString;
        Uri uri = null;
        int index = 0;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Uri)) continue;
                uri = (Uri)args[i];
                index = i;
                break;
            }
        }
        Bundle bundleInCallMethod = null;
        if (method.getName().equals("call") && (bundleInCallMethod = this.getBundleParameter(args)) != null && (uriString = bundleInCallMethod.getString("wrapper_uri")) != null) {
            uri = Uri.parse((String)uriString);
        }
        if (uri == null) {
            return;
        }
        PluginManager pluginManager = PluginManager.getInstance(this.mContext);
        ProviderInfo info = pluginManager.resolveContentProvider(uri.getAuthority(), 0);
        if (info != null) {
            String pkg = info.packageName;
            LoadedPlugin plugin = pluginManager.getLoadedPlugin(pkg);
            String pluginUri = Uri.encode((String)uri.toString());
            StringBuilder builder = new StringBuilder(PluginContentResolver.getUri(this.mContext));
            builder.append("/?plugin=" + plugin.getLocation());
            builder.append("&pkg=" + pkg);
            builder.append("&uri=" + pluginUri);
            Uri wrapperUri = Uri.parse((String)builder.toString());
            if (method.getName().equals("call")) {
                bundleInCallMethod.putString("wrapper_uri", wrapperUri.toString());
            } else {
                args[index] = wrapperUri;
            }
        }
    }

    private Bundle getBundleParameter(Object[] args) {
        Bundle bundle = null;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Bundle)) continue;
                bundle = (Bundle)args[i];
                break;
            }
        }
        return bundle;
    }
}

