/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.utils;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.text.TextUtils;
import android.view.ContextThemeWrapper;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.internal.LoadedPlugin;
import com.didi.virtualapk.utils.ReflectUtil;
import com.didi.virtualapk.utils.Settings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PluginUtil {
    public static String getTargetActivity(Intent intent) {
        return intent.getStringExtra("target.activity");
    }

    public static ComponentName getComponent(Intent intent) {
        return new ComponentName(intent.getStringExtra("target.package"), intent.getStringExtra("target.activity"));
    }

    public static boolean isIntentFromPlugin(Intent intent) {
        return intent.getBooleanExtra("isPlugin", false);
    }

    public static int getTheme(Context context, Intent intent) {
        return PluginUtil.getTheme(context, PluginUtil.getComponent(intent));
    }

    public static int getTheme(Context context, ComponentName component) {
        LoadedPlugin loadedPlugin = PluginManager.getInstance(context).getLoadedPlugin(component);
        if (null == loadedPlugin) {
            return 0;
        }
        ActivityInfo info = loadedPlugin.getActivityInfo(component);
        if (null == info) {
            return 0;
        }
        if (0 != info.theme) {
            return info.theme;
        }
        ApplicationInfo appInfo = info.applicationInfo;
        if (null != appInfo && appInfo.theme != 0) {
            return appInfo.theme;
        }
        return PluginUtil.selectDefaultTheme(0, Build.VERSION.SDK_INT);
    }

    public static int selectDefaultTheme(int curTheme, int targetSdkVersion) {
        return PluginUtil.selectSystemTheme(curTheme, targetSdkVersion, 16973829, 16973931, 16974120, 16974143);
    }

    private static int selectSystemTheme(int curTheme, int targetSdkVersion, int orig, int holo, int dark, int deviceDefault) {
        if (curTheme != 0) {
            return curTheme;
        }
        if (targetSdkVersion < 11) {
            return orig;
        }
        if (targetSdkVersion < 14) {
            return holo;
        }
        if (targetSdkVersion < 24) {
            return dark;
        }
        return deviceDefault;
    }

    public static void hookActivityResources(Activity activity, String packageName) {
        if (Build.VERSION.SDK_INT >= 21 && PluginUtil.isVivo(activity.getResources())) {
            return;
        }
        try {
            Context base = activity.getBaseContext();
            LoadedPlugin plugin = PluginManager.getInstance((Context)activity).getLoadedPlugin(packageName);
            Resources resources = plugin.getResources();
            if (resources != null) {
                ReflectUtil.setField(base.getClass(), base, "mResources", resources);
                Resources.Theme theme = resources.newTheme();
                theme.setTo(activity.getTheme());
                int themeResource = (Integer)ReflectUtil.getField(ContextThemeWrapper.class, activity, "mThemeResource");
                theme.applyStyle(themeResource, true);
                ReflectUtil.setField(ContextThemeWrapper.class, activity, "mTheme", theme);
                ReflectUtil.setField(ContextThemeWrapper.class, activity, "mResources", resources);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final boolean isLocalService(ServiceInfo serviceInfo) {
        return TextUtils.isEmpty((CharSequence)serviceInfo.processName) || serviceInfo.applicationInfo.packageName.equals(serviceInfo.processName);
    }

    public static boolean isVivo(Resources resources) {
        return resources.getClass().getName().equals("android.content.res.VivoResources");
    }

    public static void putBinder(Bundle bundle, String key, IBinder value) {
        if (Build.VERSION.SDK_INT >= 18) {
            bundle.putBinder(key, value);
        } else {
            try {
                ReflectUtil.invoke(Bundle.class, (Object)bundle, "putIBinder", new Class[]{String.class, IBinder.class}, new Object[]{key, value});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static IBinder getBinder(Bundle bundle, String key) {
        if (Build.VERSION.SDK_INT >= 18) {
            return bundle.getBinder(key);
        }
        try {
            return (IBinder)ReflectUtil.invoke(Bundle.class, (Object)bundle, "getIBinder", key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void copyNativeLib(File apk, Context context, PackageInfo packageInfo, File nativeLibDir) {
        try {
            ZipEntry entry;
            String cpuArch = Build.VERSION.SDK_INT >= 21 ? Build.SUPPORTED_ABIS[0] : Build.CPU_ABI;
            boolean findSo = false;
            ZipFile zipfile = new ZipFile(apk.getAbsolutePath());
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            while (e.hasMoreElements()) {
                entry = e.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".so") || !entry.getName().contains("lib/" + cpuArch)) continue;
                findSo = true;
                break;
            }
            e = zipfile.entries();
            while (e.hasMoreElements()) {
                int VersionCode;
                entry = e.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".so") || (!findSo || !entry.getName().contains("lib/" + cpuArch)) && (findSo || !entry.getName().contains("lib/armeabi/"))) continue;
                String[] temp = entry.getName().split("/");
                String libName = temp[temp.length - 1];
                System.out.println("verify so " + libName);
                File libFile = new File(nativeLibDir.getAbsolutePath() + File.separator + libName);
                String key = packageInfo.packageName + "_" + libName;
                if (libFile.exists() && (VersionCode = Settings.getSoVersion(context, key)) == packageInfo.versionCode) {
                    System.out.println("skip existing so : " + entry.getName());
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(libFile);
                System.out.println("copy so " + entry.getName() + " of " + cpuArch);
                PluginUtil.copySo(zipfile.getInputStream(entry), fos);
                Settings.setSoVersion(context, key, packageInfo.versionCode);
            }
            zipfile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copySo(InputStream input, OutputStream output) throws IOException {
        int count;
        BufferedInputStream bufferedInput = new BufferedInputStream(input);
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);
        byte[] data = new byte[8192];
        while ((count = bufferedInput.read(data, 0, 8192)) != -1) {
            bufferedOutput.write(data, 0, count);
        }
        bufferedOutput.flush();
        bufferedOutput.close();
        output.close();
        bufferedInput.close();
        input.close();
    }
}

