/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.Log;
import java.util.HashMap;

class StubActivityInfo {
    public static final int MAX_COUNT_STANDARD = 1;
    public static final int MAX_COUNT_SINGLETOP = 8;
    public static final int MAX_COUNT_SINGLETASK = 8;
    public static final int MAX_COUNT_SINGLEINSTANCE = 8;
    public static final String corePackage = "com.didi.virtualapk.core";
    public static final String STUB_ACTIVITY_STANDARD = "%s.A$%d";
    public static final String STUB_ACTIVITY_SINGLETOP = "%s.B$%d";
    public static final String STUB_ACTIVITY_SINGLETASK = "%s.C$%d";
    public static final String STUB_ACTIVITY_SINGLEINSTANCE = "%s.D$%d";
    public final int usedStandardStubActivity = 1;
    public int usedSingleTopStubActivity = 0;
    public int usedSingleTaskStubActivity = 0;
    public int usedSingleInstanceStubActivity = 0;
    private HashMap<String, String> mCachedStubActivity = new HashMap();

    StubActivityInfo() {
    }

    public String getStubActivity(String className, int launchMode, Resources.Theme theme) {
        String stubActivity = this.mCachedStubActivity.get(className);
        if (stubActivity != null) {
            return stubActivity;
        }
        TypedArray array = theme.obtainStyledAttributes(new int[]{16842840, 16842836});
        boolean windowIsTranslucent = array.getBoolean(0, false);
        array.recycle();
        Log.d((String)"StubActivityInfo", (String)("getStubActivity, is transparent theme ? " + windowIsTranslucent));
        stubActivity = String.format(STUB_ACTIVITY_STANDARD, corePackage, 1);
        switch (launchMode) {
            case 0: {
                stubActivity = String.format(STUB_ACTIVITY_STANDARD, corePackage, 1);
                if (!windowIsTranslucent) break;
                stubActivity = String.format(STUB_ACTIVITY_STANDARD, corePackage, 2);
                break;
            }
            case 1: {
                this.usedSingleTopStubActivity = this.usedSingleTopStubActivity % 8 + 1;
                stubActivity = String.format(STUB_ACTIVITY_SINGLETOP, corePackage, this.usedSingleTopStubActivity);
                break;
            }
            case 2: {
                this.usedSingleTaskStubActivity = this.usedSingleTaskStubActivity % 8 + 1;
                stubActivity = String.format(STUB_ACTIVITY_SINGLETASK, corePackage, this.usedSingleTaskStubActivity);
                break;
            }
            case 3: {
                this.usedSingleInstanceStubActivity = this.usedSingleInstanceStubActivity % 8 + 1;
                stubActivity = String.format(STUB_ACTIVITY_SINGLEINSTANCE, corePackage, this.usedSingleInstanceStubActivity);
                break;
            }
        }
        this.mCachedStubActivity.put(className, stubActivity);
        return stubActivity;
    }
}

