/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.internal.LoadedPlugin;
import com.didi.virtualapk.utils.ReflectUtil;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;

class ResourcesManager {
    ResourcesManager() {
    }

    public static synchronized Resources createResources(Context hostContext, String apk) {
        Resources hostResources = hostContext.getResources();
        Resources newResources = null;
        try {
            AssetManager assetManager;
            if (Build.VERSION.SDK_INT < 21) {
                assetManager = (AssetManager)AssetManager.class.newInstance();
                ReflectUtil.invoke(AssetManager.class, (Object)assetManager, "addAssetPath", hostContext.getApplicationInfo().sourceDir);
            } else {
                assetManager = hostResources.getAssets();
            }
            ReflectUtil.invoke(AssetManager.class, (Object)assetManager, "addAssetPath", apk);
            List<LoadedPlugin> pluginList = PluginManager.getInstance(hostContext).getAllLoadedPlugins();
            for (LoadedPlugin plugin : pluginList) {
                ReflectUtil.invoke(AssetManager.class, (Object)assetManager, "addAssetPath", plugin.getLocation());
            }
            newResources = ResourcesManager.isMiUi(hostResources) ? MiUiResourcesCompat.createResources(hostResources, assetManager) : (ResourcesManager.isVivo(hostResources) ? VivoResourcesCompat.createResources(hostContext, hostResources, assetManager) : (ResourcesManager.isNubia(hostResources) ? NubiaResourcesCompat.createResources(hostResources, assetManager) : (ResourcesManager.isNotRawResources(hostResources) ? AdaptationResourcesCompat.createResources(hostResources, assetManager) : new Resources(assetManager, hostResources.getDisplayMetrics(), hostResources.getConfiguration()))));
            for (LoadedPlugin plugin : pluginList) {
                plugin.updateResources(newResources);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newResources;
    }

    public static void hookResources(Context base, Resources resources) {
        try {
            ReflectUtil.setField(base.getClass(), base, "mResources", resources);
            Object loadedApk = ReflectUtil.getPackageInfo(base);
            ReflectUtil.setField(loadedApk.getClass(), loadedApk, "mResources", resources);
            Object activityThread = ReflectUtil.getActivityThread(base);
            Object resManager = ReflectUtil.getField(activityThread.getClass(), activityThread, "mResourcesManager");
            if (Build.VERSION.SDK_INT < 24) {
                Map map = (Map)ReflectUtil.getField(resManager.getClass(), resManager, "mActiveResources");
                Object key = map.keySet().iterator().next();
                map.put(key, new WeakReference<Resources>(resources));
            } else {
                Map map = (Map)ReflectUtil.getFieldNoException(resManager.getClass(), resManager, "mResourceImpls");
                Object key = map.keySet().iterator().next();
                Object resourcesImpl = ReflectUtil.getFieldNoException(Resources.class, resources, "mResourcesImpl");
                map.put(key, new WeakReference<Object>(resourcesImpl));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isMiUi(Resources resources) {
        return resources.getClass().getName().equals("android.content.res.MiuiResources");
    }

    private static boolean isVivo(Resources resources) {
        return resources.getClass().getName().equals("android.content.res.VivoResources");
    }

    private static boolean isNubia(Resources resources) {
        return resources.getClass().getName().equals("android.content.res.NubiaResources");
    }

    private static boolean isNotRawResources(Resources resources) {
        return !resources.getClass().getName().equals("android.content.res.Resources");
    }

    private static final class AdaptationResourcesCompat {
        private AdaptationResourcesCompat() {
        }

        private static Resources createResources(Resources hostResources, AssetManager assetManager) throws Exception {
            Resources newResources;
            try {
                Class<?> resourcesClazz = hostResources.getClass();
                newResources = (Resources)ReflectUtil.invokeConstructor(resourcesClazz, new Class[]{AssetManager.class, DisplayMetrics.class, Configuration.class}, assetManager, hostResources.getDisplayMetrics(), hostResources.getConfiguration());
            }
            catch (Exception e) {
                newResources = new Resources(assetManager, hostResources.getDisplayMetrics(), hostResources.getConfiguration());
            }
            return newResources;
        }
    }

    private static final class NubiaResourcesCompat {
        private NubiaResourcesCompat() {
        }

        private static Resources createResources(Resources hostResources, AssetManager assetManager) throws Exception {
            Class<?> resourcesClazz = Class.forName("android.content.res.NubiaResources");
            Resources newResources = (Resources)ReflectUtil.invokeConstructor(resourcesClazz, new Class[]{AssetManager.class, DisplayMetrics.class, Configuration.class}, assetManager, hostResources.getDisplayMetrics(), hostResources.getConfiguration());
            return newResources;
        }
    }

    private static final class VivoResourcesCompat {
        private VivoResourcesCompat() {
        }

        private static Resources createResources(Context hostContext, Resources hostResources, AssetManager assetManager) throws Exception {
            Class<?> resourcesClazz = Class.forName("android.content.res.VivoResources");
            Resources newResources = (Resources)ReflectUtil.invokeConstructor(resourcesClazz, new Class[]{AssetManager.class, DisplayMetrics.class, Configuration.class}, assetManager, hostResources.getDisplayMetrics(), hostResources.getConfiguration());
            ReflectUtil.invokeNoException(resourcesClazz, newResources, "init", new Class[]{String.class}, hostContext.getPackageName());
            Object themeValues = ReflectUtil.getFieldNoException(resourcesClazz, hostResources, "mThemeValues");
            ReflectUtil.setFieldNoException(resourcesClazz, newResources, "mThemeValues", themeValues);
            return newResources;
        }
    }

    private static final class MiUiResourcesCompat {
        private MiUiResourcesCompat() {
        }

        private static Resources createResources(Resources hostResources, AssetManager assetManager) throws Exception {
            Class<?> resourcesClazz = Class.forName("android.content.res.MiuiResources");
            Resources newResources = (Resources)ReflectUtil.invokeConstructor(resourcesClazz, new Class[]{AssetManager.class, DisplayMetrics.class, Configuration.class}, assetManager, hostResources.getDisplayMetrics(), hostResources.getConfiguration());
            return newResources;
        }
    }
}

