/*
 * Decompiled with CFR 0.152.
 */
package android.databinding;

import android.databinding.DataBinderMapper;
import android.databinding.DataBindingComponent;
import android.databinding.ViewDataBinding;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.View;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.internal.LoadedPlugin;
import java.util.LinkedList;

public class DataBinderMapperProxy
extends DataBinderMapper
implements PluginManager.Callback {
    public static final String TAG = "DataBinderMapperProxy";
    private final LinkedList<DataBinderMapper> mMappers = new LinkedList();
    private DataBinderMapper[] mCache;

    public DataBinderMapperProxy(@NonNull Object source) {
        this.addMapper((DataBinderMapper)source);
    }

    public ViewDataBinding getDataBinder(DataBindingComponent bindingComponent, View view, int layoutId) {
        for (DataBinderMapper mapper : this.getCache()) {
            ViewDataBinding viewDataBinding = mapper.getDataBinder(bindingComponent, view, layoutId);
            if (viewDataBinding == null) continue;
            Log.i((String)TAG, (String)("Found by mapper: " + mapper));
            return viewDataBinding;
        }
        return null;
    }

    ViewDataBinding getDataBinder(DataBindingComponent bindingComponent, View[] view, int layoutId) {
        for (DataBinderMapper mapper : this.getCache()) {
            ViewDataBinding viewDataBinding = mapper.getDataBinder(bindingComponent, view, layoutId);
            if (viewDataBinding == null) continue;
            Log.i((String)TAG, (String)("Found by mapper: " + mapper));
            return viewDataBinding;
        }
        return null;
    }

    public int getLayoutId(String tag) {
        for (DataBinderMapper mapper : this.getCache()) {
            int layoutId = mapper.getLayoutId(tag);
            if (layoutId == 0) continue;
            Log.i((String)TAG, (String)("Found by mapper: " + mapper));
            return layoutId;
        }
        return 0;
    }

    public String convertBrIdToString(int id) {
        for (DataBinderMapper mapper : this.getCache()) {
            String brId = mapper.convertBrIdToString(id);
            if (brId == null) continue;
            Log.i((String)TAG, (String)("Found by mapper: " + mapper));
            return brId;
        }
        return null;
    }

    @Override
    public void onAddedLoadedPlugin(LoadedPlugin plugin) {
        try {
            String clsName = "android.databinding.DataBinderMapper_" + plugin.getPackageName().replace('.', '_');
            Log.i((String)TAG, (String)("Try to find the class: " + clsName));
            Class<?> cls = Class.forName(clsName, true, plugin.getClassLoader());
            Object obj = cls.newInstance();
            this.addMapper((DataBinderMapper)obj);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMapper(DataBinderMapper mapper) {
        LinkedList<DataBinderMapper> linkedList = this.mMappers;
        synchronized (linkedList) {
            this.mMappers.add(mapper);
            this.mCache = null;
        }
        Log.i((String)TAG, (String)("Added mapper: " + mapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataBinderMapper[] getCache() {
        LinkedList<DataBinderMapper> linkedList = this.mMappers;
        synchronized (linkedList) {
            if (this.mCache == null) {
                this.mCache = this.mMappers.toArray(new DataBinderMapper[this.mMappers.size()]);
            }
            return this.mCache;
        }
    }
}

