/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.utils;

import android.os.Build;
import com.didi.virtualapk.Systems;
import com.didi.virtualapk.utils.ReflectUtil;
import dalvik.system.DexClassLoader;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;

public class DexUtil {
    private static boolean sHasInsertedNativeLibrary = false;

    public static void insertDex(DexClassLoader dexClassLoader) throws Exception {
        Object baseDexElements = DexUtil.getDexElements(DexUtil.getPathList(DexUtil.getPathClassLoader()));
        Object newDexElements = DexUtil.getDexElements(DexUtil.getPathList(dexClassLoader));
        Object allDexElements = DexUtil.combineArray(baseDexElements, newDexElements);
        Object pathList = DexUtil.getPathList(DexUtil.getPathClassLoader());
        ReflectUtil.setField(pathList.getClass(), pathList, "dexElements", allDexElements);
        DexUtil.insertNativeLibrary(dexClassLoader);
    }

    private static PathClassLoader getPathClassLoader() {
        PathClassLoader pathClassLoader = (PathClassLoader)DexUtil.class.getClassLoader();
        return pathClassLoader;
    }

    private static Object getDexElements(Object pathList) throws Exception {
        return ReflectUtil.getField(pathList.getClass(), pathList, "dexElements");
    }

    private static Object getPathList(Object baseDexClassLoader) throws Exception {
        return ReflectUtil.getField(Class.forName("dalvik.system.BaseDexClassLoader"), baseDexClassLoader, "pathList");
    }

    private static Object combineArray(Object firstArray, Object secondArray) {
        Class<?> localClass = firstArray.getClass().getComponentType();
        int firstArrayLength = Array.getLength(firstArray);
        int allLength = firstArrayLength + Array.getLength(secondArray);
        Object result = Array.newInstance(localClass, allLength);
        for (int k = 0; k < allLength; ++k) {
            if (k < firstArrayLength) {
                Array.set(result, k, Array.get(firstArray, k));
                continue;
            }
            Array.set(result, k, Array.get(secondArray, k - firstArrayLength));
        }
        return result;
    }

    private static synchronized void insertNativeLibrary(DexClassLoader dexClassLoader) throws Exception {
        if (sHasInsertedNativeLibrary) {
            return;
        }
        sHasInsertedNativeLibrary = true;
        Object basePathList = DexUtil.getPathList(DexUtil.getPathClassLoader());
        if (Build.VERSION.SDK_INT > 22) {
            List nativeLibraryDirectories = (List)ReflectUtil.getField(basePathList.getClass(), basePathList, "nativeLibraryDirectories");
            nativeLibraryDirectories.add(Systems.getContext().getDir("valibs", 0));
            Object baseNativeLibraryPathElements = ReflectUtil.getField(basePathList.getClass(), basePathList, "nativeLibraryPathElements");
            int baseArrayLength = Array.getLength(baseNativeLibraryPathElements);
            Object newPathList = DexUtil.getPathList(dexClassLoader);
            Object newNativeLibraryPathElements = ReflectUtil.getField(newPathList.getClass(), newPathList, "nativeLibraryPathElements");
            Class<?> elementClass = newNativeLibraryPathElements.getClass().getComponentType();
            Object allNativeLibraryPathElements = Array.newInstance(elementClass, baseArrayLength + 1);
            System.arraycopy(baseNativeLibraryPathElements, 0, allNativeLibraryPathElements, 0, baseArrayLength);
            Field dirField = elementClass.getDeclaredField("dir");
            dirField.setAccessible(true);
            int newArrayLength = Array.getLength(newNativeLibraryPathElements);
            for (int i = 0; i < newArrayLength; ++i) {
                Object element = Array.get(newNativeLibraryPathElements, i);
                String dir = ((File)dirField.get(element)).getAbsolutePath();
                if (!dir.contains("valibs")) continue;
                Array.set(allNativeLibraryPathElements, baseArrayLength, element);
                break;
            }
            ReflectUtil.setField(basePathList.getClass(), basePathList, "nativeLibraryPathElements", allNativeLibraryPathElements);
        } else {
            File[] nativeLibraryDirectories = (File[])ReflectUtil.getFieldNoException(basePathList.getClass(), basePathList, "nativeLibraryDirectories");
            int N = nativeLibraryDirectories.length;
            File[] newNativeLibraryDirectories = new File[N + 1];
            System.arraycopy(nativeLibraryDirectories, 0, newNativeLibraryDirectories, 0, N);
            newNativeLibraryDirectories[N] = Systems.getContext().getDir("valibs", 0);
            ReflectUtil.setField(basePathList.getClass(), basePathList, "nativeLibraryDirectories", newNativeLibraryDirectories);
        }
    }
}

