/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal;

import android.annotation.TargetApi;
import android.app.Application;
import android.app.Instrumentation;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.os.UserHandle;
import android.support.annotation.WorkerThread;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.internal.PluginContext;
import com.didi.virtualapk.internal.ResourcesManager;
import com.didi.virtualapk.utils.DexUtil;
import com.didi.virtualapk.utils.PackageParserCompat;
import com.didi.virtualapk.utils.PluginUtil;
import com.didi.virtualapk.utils.ReflectUtil;
import com.didi.virtualapk.utils.RunUtil;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LoadedPlugin {
    public static final String TAG = "LoadedPlugin";
    private final String mLocation;
    private PluginManager mPluginManager;
    private Context mHostContext;
    private Context mPluginContext;
    private final File mNativeLibDir;
    private final PackageParser.Package mPackage;
    private final PackageInfo mPackageInfo;
    private AssetManager mAssets;
    private Resources mResources;
    private ClassLoader mClassLoader;
    private PluginPackageManager mPackageManager;
    private Map<ComponentName, ActivityInfo> mActivityInfos;
    private Map<ComponentName, ServiceInfo> mServiceInfos;
    private Map<ComponentName, ActivityInfo> mReceiverInfos;
    private Map<ComponentName, ProviderInfo> mProviderInfos;
    private Map<String, ProviderInfo> mProviders;
    private Map<ComponentName, InstrumentationInfo> mInstrumentationInfos;
    private Application mApplication;

    public static LoadedPlugin create(PluginManager pluginManager, Context host, File apk) throws Exception {
        return new LoadedPlugin(pluginManager, host, apk);
    }

    private static ClassLoader createClassLoader(Context context, File apk, File libsDir, ClassLoader parent) {
        File dexOutputDir = context.getDir("dex", 0);
        String dexOutputPath = dexOutputDir.getAbsolutePath();
        DexClassLoader loader = new DexClassLoader(apk.getAbsolutePath(), dexOutputPath, libsDir.getAbsolutePath(), parent);
        try {
            DexUtil.insertDex(loader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loader;
    }

    private static AssetManager createAssetManager(Context context, File apk) {
        try {
            AssetManager am = (AssetManager)AssetManager.class.newInstance();
            ReflectUtil.invoke(AssetManager.class, (Object)am, "addAssetPath", apk.getAbsolutePath());
            return am;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @WorkerThread
    private static Resources createResources(Context context, File apk) {
        Resources resources = ResourcesManager.createResources(context, apk.getAbsolutePath());
        ResourcesManager.hookResources(context, resources);
        return resources;
    }

    private static ResolveInfo chooseBestActivity(Intent intent, String s, int flags, List<ResolveInfo> query) {
        return query.get(0);
    }

    LoadedPlugin(PluginManager pluginManager, Context context, File apk) throws PackageParser.PackageParserException {
        this.mPluginManager = pluginManager;
        this.mHostContext = context;
        this.mLocation = apk.getAbsolutePath();
        this.mPackage = PackageParserCompat.parsePackage(context, apk, 4);
        this.mPackage.applicationInfo.metaData = this.mPackage.mAppMetaData;
        this.mPackageInfo = new PackageInfo();
        this.mPackageInfo.applicationInfo = this.mPackage.applicationInfo;
        this.mPackageInfo.applicationInfo.sourceDir = apk.getAbsolutePath();
        this.mPackageInfo.signatures = this.mPackage.mSignatures;
        this.mPackageInfo.packageName = this.mPackage.packageName;
        if (pluginManager.getLoadedPlugin(this.mPackageInfo.packageName) != null) {
            throw new RuntimeException("plugin has already been loaded : " + this.mPackageInfo.packageName);
        }
        this.mPackageInfo.versionCode = this.mPackage.mVersionCode;
        this.mPackageInfo.versionName = this.mPackage.mVersionName;
        this.mPackageInfo.permissions = new PermissionInfo[0];
        this.mPackageManager = new PluginPackageManager();
        this.mPluginContext = new PluginContext(this);
        this.mNativeLibDir = context.getDir("valibs", 0);
        this.mResources = LoadedPlugin.createResources(context, apk);
        this.mAssets = this.mResources.getAssets();
        this.mClassLoader = LoadedPlugin.createClassLoader(context, apk, this.mNativeLibDir, context.getClassLoader());
        this.tryToCopyNativeLib(apk);
        HashMap<ComponentName, InstrumentationInfo> instrumentations = new HashMap<ComponentName, InstrumentationInfo>();
        for (Object instrumentation : this.mPackage.instrumentation) {
            instrumentations.put(instrumentation.getComponentName(), ((PackageParser.Instrumentation)instrumentation).info);
        }
        this.mInstrumentationInfos = Collections.unmodifiableMap(instrumentations);
        this.mPackageInfo.instrumentation = instrumentations.values().toArray(new InstrumentationInfo[instrumentations.size()]);
        HashMap<ComponentName, ActivityInfo> activityInfos = new HashMap<ComponentName, ActivityInfo>();
        for (Object activity : this.mPackage.activities) {
            activityInfos.put(activity.getComponentName(), ((PackageParser.Activity)activity).info);
        }
        this.mActivityInfos = Collections.unmodifiableMap(activityInfos);
        this.mPackageInfo.activities = activityInfos.values().toArray(new ActivityInfo[activityInfos.size()]);
        HashMap<ComponentName, ServiceInfo> serviceInfos = new HashMap<ComponentName, ServiceInfo>();
        for (PackageParser.Service service : this.mPackage.services) {
            serviceInfos.put(service.getComponentName(), service.info);
        }
        this.mServiceInfos = Collections.unmodifiableMap(serviceInfos);
        this.mPackageInfo.services = serviceInfos.values().toArray(new ServiceInfo[serviceInfos.size()]);
        HashMap<String, ProviderInfo> providers = new HashMap<String, ProviderInfo>();
        HashMap<ComponentName, ProviderInfo> providerInfos = new HashMap<ComponentName, ProviderInfo>();
        for (PackageParser.Provider provider : this.mPackage.providers) {
            providers.put(provider.info.authority, provider.info);
            providerInfos.put(provider.getComponentName(), provider.info);
        }
        this.mProviders = Collections.unmodifiableMap(providers);
        this.mProviderInfos = Collections.unmodifiableMap(providerInfos);
        this.mPackageInfo.providers = providerInfos.values().toArray(new ProviderInfo[providerInfos.size()]);
        HashMap<ComponentName, ActivityInfo> receivers = new HashMap<ComponentName, ActivityInfo>();
        for (PackageParser.Activity receiver : this.mPackage.receivers) {
            receivers.put(receiver.getComponentName(), receiver.info);
            try {
                BroadcastReceiver br = (BroadcastReceiver)BroadcastReceiver.class.cast(this.getClassLoader().loadClass(receiver.getComponentName().getClassName()).newInstance());
                for (PackageParser.ActivityIntentInfo aii : receiver.intents) {
                    this.mHostContext.registerReceiver(br, (IntentFilter)aii);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mReceiverInfos = Collections.unmodifiableMap(receivers);
        this.mPackageInfo.receivers = receivers.values().toArray(new ActivityInfo[receivers.size()]);
    }

    private void tryToCopyNativeLib(File apk) {
        Bundle metaData = this.mPackageInfo.applicationInfo.metaData;
        if (metaData != null && metaData.getBoolean("VA_IS_HAVE_LIB")) {
            PluginUtil.copyNativeLib(apk, this.mHostContext, this.mPackageInfo, this.mNativeLibDir);
        }
    }

    public String getLocation() {
        return this.mLocation;
    }

    public String getPackageName() {
        return this.mPackage.packageName;
    }

    public PackageManager getPackageManager() {
        return this.mPackageManager;
    }

    public AssetManager getAssets() {
        return this.mAssets;
    }

    public Resources getResources() {
        return this.mResources;
    }

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public PluginManager getPluginManager() {
        return this.mPluginManager;
    }

    public Context getHostContext() {
        return this.mHostContext;
    }

    public Context getPluginContext() {
        return this.mPluginContext;
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public void invokeApplication() {
        if (this.mApplication != null) {
            return;
        }
        RunUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                LoadedPlugin.this.mApplication = LoadedPlugin.this.makeApplication(false, LoadedPlugin.this.mPluginManager.getInstrumentation());
            }
        }, true);
    }

    public String getPackageResourcePath() {
        int myUid = Process.myUid();
        ApplicationInfo appInfo = this.mPackage.applicationInfo;
        return appInfo.uid == myUid ? appInfo.sourceDir : appInfo.publicSourceDir;
    }

    public String getCodePath() {
        return this.mPackage.applicationInfo.sourceDir;
    }

    public Intent getLaunchIntent() {
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        Intent launcher = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.LAUNCHER");
        for (PackageParser.Activity activity : this.mPackage.activities) {
            for (PackageParser.ActivityIntentInfo intentInfo : activity.intents) {
                if (intentInfo.match(resolver, launcher, false, TAG) <= 0) continue;
                return Intent.makeMainActivity((ComponentName)activity.getComponentName());
            }
        }
        return null;
    }

    public Intent getLeanbackLaunchIntent() {
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        Intent launcher = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.LEANBACK_LAUNCHER");
        for (PackageParser.Activity activity : this.mPackage.activities) {
            for (PackageParser.ActivityIntentInfo intentInfo : activity.intents) {
                if (intentInfo.match(resolver, launcher, false, TAG) <= 0) continue;
                Intent intent = new Intent("android.intent.action.MAIN");
                intent.setComponent(activity.getComponentName());
                intent.addCategory("android.intent.category.LEANBACK_LAUNCHER");
                return intent;
            }
        }
        return null;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.mPackage.applicationInfo;
    }

    public PackageInfo getPackageInfo() {
        return this.mPackageInfo;
    }

    public ActivityInfo getActivityInfo(ComponentName componentName) {
        return this.mActivityInfos.get(componentName);
    }

    public ServiceInfo getServiceInfo(ComponentName componentName) {
        return this.mServiceInfos.get(componentName);
    }

    public ActivityInfo getReceiverInfo(ComponentName componentName) {
        return this.mReceiverInfos.get(componentName);
    }

    public ProviderInfo getProviderInfo(ComponentName componentName) {
        return this.mProviderInfos.get(componentName);
    }

    public Resources.Theme getTheme() {
        Resources.Theme theme = this.mResources.newTheme();
        theme.applyStyle(PluginUtil.selectDefaultTheme(this.mPackage.applicationInfo.theme, Build.VERSION.SDK_INT), false);
        return theme;
    }

    public void setTheme(int resid) {
        try {
            ReflectUtil.setField(Resources.class, this.mResources, "mThemeResId", resid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Application makeApplication(boolean forceDefaultAppClass, Instrumentation instrumentation) {
        if (null != this.mApplication) {
            return this.mApplication;
        }
        String appClass = this.mPackage.applicationInfo.className;
        if (forceDefaultAppClass || null == appClass) {
            appClass = "android.app.Application";
        }
        try {
            this.mApplication = instrumentation.newApplication(this.mClassLoader, appClass, this.getPluginContext());
            instrumentation.callApplicationOnCreate(this.mApplication);
            return this.mApplication;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ResolveInfo resolveActivity(Intent intent, int flags) {
        List<ResolveInfo> query = this.queryIntentActivities(intent, flags);
        if (null == query || query.isEmpty()) {
            return null;
        }
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        return LoadedPlugin.chooseBestActivity(intent, intent.resolveTypeIfNeeded(resolver), flags, query);
    }

    public List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        ComponentName component = intent.getComponent();
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        block0: for (PackageParser.Activity activity : this.mPackage.activities) {
            if (this.match((PackageParser.Component)activity, component)) {
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.activityInfo = activity.info;
                resolveInfos.add(resolveInfo);
                continue;
            }
            if (component != null) continue;
            for (PackageParser.ActivityIntentInfo intentInfo : activity.intents) {
                if (intentInfo.match(resolver, intent, true, TAG) < 0) continue;
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.activityInfo = activity.info;
                resolveInfos.add(resolveInfo);
                continue block0;
            }
        }
        return resolveInfos;
    }

    public ResolveInfo resolveService(Intent intent, int flags) {
        List<ResolveInfo> query = this.queryIntentServices(intent, flags);
        if (null == query || query.isEmpty()) {
            return null;
        }
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        return LoadedPlugin.chooseBestActivity(intent, intent.resolveTypeIfNeeded(resolver), flags, query);
    }

    public List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
        ComponentName component = intent.getComponent();
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        block0: for (PackageParser.Service service : this.mPackage.services) {
            if (this.match((PackageParser.Component)service, component)) {
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.serviceInfo = service.info;
                resolveInfos.add(resolveInfo);
                continue;
            }
            if (component != null) continue;
            for (PackageParser.ServiceIntentInfo intentInfo : service.intents) {
                if (intentInfo.match(resolver, intent, true, TAG) < 0) continue;
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.serviceInfo = service.info;
                resolveInfos.add(resolveInfo);
                continue block0;
            }
        }
        return resolveInfos;
    }

    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
        ComponentName component = intent.getComponent();
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        ContentResolver resolver = this.mPluginContext.getContentResolver();
        block0: for (PackageParser.Activity receiver : this.mPackage.receivers) {
            if (receiver.getComponentName().equals((Object)component)) {
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.activityInfo = receiver.info;
                resolveInfos.add(resolveInfo);
                continue;
            }
            if (component != null) continue;
            for (PackageParser.ActivityIntentInfo intentInfo : receiver.intents) {
                if (intentInfo.match(resolver, intent, true, TAG) < 0) continue;
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.activityInfo = receiver.info;
                resolveInfos.add(resolveInfo);
                continue block0;
            }
        }
        return resolveInfos;
    }

    public ProviderInfo resolveContentProvider(String name, int flags) {
        return this.mProviders.get(name);
    }

    private boolean match(PackageParser.Component component, ComponentName target) {
        ComponentName source = component.getComponentName();
        if (source == target) {
            return true;
        }
        return source != null && target != null && source.getClassName().equals(target.getClassName()) && (source.getPackageName().equals(target.getPackageName()) || this.mHostContext.getPackageName().equals(target.getPackageName()));
    }

    private class PluginPackageManager
    extends PackageManager {
        private PackageManager mHostPackageManager;

        private PluginPackageManager() {
            this.mHostPackageManager = LoadedPlugin.this.mHostContext.getPackageManager();
        }

        public PackageInfo getPackageInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mPackageInfo;
            }
            return this.mHostPackageManager.getPackageInfo(packageName, flags);
        }

        public String[] currentToCanonicalPackageNames(String[] names) {
            return this.mHostPackageManager.currentToCanonicalPackageNames(names);
        }

        public String[] canonicalToCurrentPackageNames(String[] names) {
            return this.mHostPackageManager.canonicalToCurrentPackageNames(names);
        }

        public Intent getLaunchIntentForPackage(String packageName) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.getLaunchIntent();
            }
            return this.mHostPackageManager.getLaunchIntentForPackage(packageName);
        }

        @TargetApi(value=21)
        public Intent getLeanbackLaunchIntentForPackage(String packageName) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.getLeanbackLaunchIntent();
            }
            return this.mHostPackageManager.getLeanbackLaunchIntentForPackage(packageName);
        }

        public int[] getPackageGids(String packageName) throws PackageManager.NameNotFoundException {
            return this.mHostPackageManager.getPackageGids(packageName);
        }

        public PermissionInfo getPermissionInfo(String name, int flags) throws PackageManager.NameNotFoundException {
            return this.mHostPackageManager.getPermissionInfo(name, flags);
        }

        public List<PermissionInfo> queryPermissionsByGroup(String group, int flags) throws PackageManager.NameNotFoundException {
            return this.mHostPackageManager.queryPermissionsByGroup(group, flags);
        }

        public PermissionGroupInfo getPermissionGroupInfo(String name, int flags) throws PackageManager.NameNotFoundException {
            return this.mHostPackageManager.getPermissionGroupInfo(name, flags);
        }

        public List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
            return this.mHostPackageManager.getAllPermissionGroups(flags);
        }

        public ApplicationInfo getApplicationInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.getApplicationInfo();
            }
            return this.mHostPackageManager.getApplicationInfo(packageName, flags);
        }

        public ActivityInfo getActivityInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return (ActivityInfo)plugin.mActivityInfos.get(component);
            }
            return this.mHostPackageManager.getActivityInfo(component, flags);
        }

        public ActivityInfo getReceiverInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return (ActivityInfo)plugin.mReceiverInfos.get(component);
            }
            return this.mHostPackageManager.getReceiverInfo(component, flags);
        }

        public ServiceInfo getServiceInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return (ServiceInfo)plugin.mServiceInfos.get(component);
            }
            return this.mHostPackageManager.getServiceInfo(component, flags);
        }

        public ProviderInfo getProviderInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return (ProviderInfo)plugin.mProviderInfos.get(component);
            }
            return this.mHostPackageManager.getProviderInfo(component, flags);
        }

        public List<PackageInfo> getInstalledPackages(int flags) {
            return this.mHostPackageManager.getInstalledPackages(flags);
        }

        @TargetApi(value=18)
        public List<PackageInfo> getPackagesHoldingPermissions(String[] permissions, int flags) {
            return this.mHostPackageManager.getPackagesHoldingPermissions(permissions, flags);
        }

        public int checkPermission(String permName, String pkgName) {
            return this.mHostPackageManager.checkPermission(permName, pkgName);
        }

        public boolean addPermission(PermissionInfo info) {
            return this.mHostPackageManager.addPermission(info);
        }

        public boolean addPermissionAsync(PermissionInfo info) {
            return this.mHostPackageManager.addPermissionAsync(info);
        }

        public void removePermission(String name) {
            this.mHostPackageManager.removePermission(name);
        }

        public int checkSignatures(String pkg1, String pkg2) {
            return this.mHostPackageManager.checkSignatures(pkg1, pkg2);
        }

        public int checkSignatures(int uid1, int uid2) {
            return this.mHostPackageManager.checkSignatures(uid1, uid2);
        }

        public String[] getPackagesForUid(int uid) {
            return this.mHostPackageManager.getPackagesForUid(uid);
        }

        public String getNameForUid(int uid) {
            return this.mHostPackageManager.getNameForUid(uid);
        }

        public List<ApplicationInfo> getInstalledApplications(int flags) {
            return this.mHostPackageManager.getInstalledApplications(flags);
        }

        public String[] getSystemSharedLibraryNames() {
            return this.mHostPackageManager.getSystemSharedLibraryNames();
        }

        public FeatureInfo[] getSystemAvailableFeatures() {
            return this.mHostPackageManager.getSystemAvailableFeatures();
        }

        public boolean hasSystemFeature(String name) {
            return this.mHostPackageManager.hasSystemFeature(name);
        }

        public ResolveInfo resolveActivity(Intent intent, int flags) {
            ResolveInfo resolveInfo = LoadedPlugin.this.mPluginManager.resolveActivity(intent, flags);
            if (null != resolveInfo) {
                return resolveInfo;
            }
            return this.mHostPackageManager.resolveActivity(intent, flags);
        }

        public List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
            List hostResolveInfos;
            ActivityInfo activityInfo;
            LoadedPlugin plugin;
            ComponentName component = intent.getComponent();
            if (null == component && intent.getSelector() != null) {
                intent = intent.getSelector();
                component = intent.getComponent();
            }
            if (null != component && null != (plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component)) && (activityInfo = plugin.getActivityInfo(component)) != null) {
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.activityInfo = activityInfo;
                return Arrays.asList(resolveInfo);
            }
            ArrayList<ResolveInfo> all = new ArrayList<ResolveInfo>();
            List<ResolveInfo> pluginResolveInfos = LoadedPlugin.this.mPluginManager.queryIntentActivities(intent, flags);
            if (null != pluginResolveInfos && pluginResolveInfos.size() > 0) {
                all.addAll(pluginResolveInfos);
            }
            if (null != (hostResolveInfos = this.mHostPackageManager.queryIntentActivities(intent, flags)) && hostResolveInfos.size() > 0) {
                all.addAll(hostResolveInfos);
            }
            return all;
        }

        public List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, Intent intent, int flags) {
            return this.mHostPackageManager.queryIntentActivityOptions(caller, specifics, intent, flags);
        }

        public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
            List hostResolveInfos;
            ActivityInfo activityInfo;
            LoadedPlugin plugin;
            ComponentName component = intent.getComponent();
            if (null == component && intent.getSelector() != null) {
                intent = intent.getSelector();
                component = intent.getComponent();
            }
            if (null != component && null != (plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component)) && (activityInfo = plugin.getReceiverInfo(component)) != null) {
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.activityInfo = activityInfo;
                return Arrays.asList(resolveInfo);
            }
            ArrayList<ResolveInfo> all = new ArrayList<ResolveInfo>();
            List<ResolveInfo> pluginResolveInfos = LoadedPlugin.this.mPluginManager.queryBroadcastReceivers(intent, flags);
            if (null != pluginResolveInfos && pluginResolveInfos.size() > 0) {
                all.addAll(pluginResolveInfos);
            }
            if (null != (hostResolveInfos = this.mHostPackageManager.queryBroadcastReceivers(intent, flags)) && hostResolveInfos.size() > 0) {
                all.addAll(hostResolveInfos);
            }
            return all;
        }

        public ResolveInfo resolveService(Intent intent, int flags) {
            ResolveInfo resolveInfo = LoadedPlugin.this.mPluginManager.resolveService(intent, flags);
            if (null != resolveInfo) {
                return resolveInfo;
            }
            return this.mHostPackageManager.resolveService(intent, flags);
        }

        public List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
            List hostResolveInfos;
            ServiceInfo serviceInfo;
            LoadedPlugin plugin;
            ComponentName component = intent.getComponent();
            if (null == component && intent.getSelector() != null) {
                intent = intent.getSelector();
                component = intent.getComponent();
            }
            if (null != component && null != (plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component)) && (serviceInfo = plugin.getServiceInfo(component)) != null) {
                ResolveInfo resolveInfo = new ResolveInfo();
                resolveInfo.serviceInfo = serviceInfo;
                return Arrays.asList(resolveInfo);
            }
            ArrayList<ResolveInfo> all = new ArrayList<ResolveInfo>();
            List<ResolveInfo> pluginResolveInfos = LoadedPlugin.this.mPluginManager.queryIntentServices(intent, flags);
            if (null != pluginResolveInfos && pluginResolveInfos.size() > 0) {
                all.addAll(pluginResolveInfos);
            }
            if (null != (hostResolveInfos = this.mHostPackageManager.queryIntentServices(intent, flags)) && hostResolveInfos.size() > 0) {
                all.addAll(hostResolveInfos);
            }
            return all;
        }

        @TargetApi(value=19)
        public List<ResolveInfo> queryIntentContentProviders(Intent intent, int flags) {
            return this.mHostPackageManager.queryIntentContentProviders(intent, flags);
        }

        public ProviderInfo resolveContentProvider(String name, int flags) {
            ProviderInfo providerInfo = LoadedPlugin.this.mPluginManager.resolveContentProvider(name, flags);
            if (null != providerInfo) {
                return providerInfo;
            }
            return this.mHostPackageManager.resolveContentProvider(name, flags);
        }

        public List<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
            return this.mHostPackageManager.queryContentProviders(processName, uid, flags);
        }

        public InstrumentationInfo getInstrumentationInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return (InstrumentationInfo)plugin.mInstrumentationInfos.get(component);
            }
            return this.mHostPackageManager.getInstrumentationInfo(component, flags);
        }

        public List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
            return this.mHostPackageManager.queryInstrumentation(targetPackage, flags);
        }

        public Drawable getDrawable(String packageName, int resid, ApplicationInfo appInfo) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(resid);
            }
            return this.mHostPackageManager.getDrawable(packageName, resid, appInfo);
        }

        public Drawable getActivityIcon(ComponentName component) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return plugin.mResources.getDrawable(((ActivityInfo)((LoadedPlugin)plugin).mActivityInfos.get((Object)component)).icon);
            }
            return this.mHostPackageManager.getActivityIcon(component);
        }

        public Drawable getActivityIcon(Intent intent) throws PackageManager.NameNotFoundException {
            ResolveInfo ri = LoadedPlugin.this.mPluginManager.resolveActivity(intent);
            if (null != ri) {
                LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(ri.resolvePackageName);
                return plugin.mResources.getDrawable(ri.activityInfo.icon);
            }
            return this.mHostPackageManager.getActivityIcon(intent);
        }

        @TargetApi(value=20)
        public Drawable getActivityBanner(ComponentName component) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return plugin.mResources.getDrawable(((ActivityInfo)((LoadedPlugin)plugin).mActivityInfos.get((Object)component)).banner);
            }
            return this.mHostPackageManager.getActivityBanner(component);
        }

        @TargetApi(value=20)
        public Drawable getActivityBanner(Intent intent) throws PackageManager.NameNotFoundException {
            ResolveInfo ri = LoadedPlugin.this.mPluginManager.resolveActivity(intent);
            if (null != ri) {
                LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(ri.resolvePackageName);
                return plugin.mResources.getDrawable(ri.activityInfo.banner);
            }
            return this.mHostPackageManager.getActivityBanner(intent);
        }

        public Drawable getDefaultActivityIcon() {
            return this.mHostPackageManager.getDefaultActivityIcon();
        }

        public Drawable getApplicationIcon(ApplicationInfo info) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(info.packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(info.icon);
            }
            return this.mHostPackageManager.getApplicationIcon(info);
        }

        public Drawable getApplicationIcon(String packageName) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(((LoadedPlugin)plugin).mPackage.applicationInfo.icon);
            }
            return this.mHostPackageManager.getApplicationIcon(packageName);
        }

        @TargetApi(value=20)
        public Drawable getApplicationBanner(ApplicationInfo info) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(info.packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(info.banner);
            }
            return this.mHostPackageManager.getApplicationBanner(info);
        }

        @TargetApi(value=20)
        public Drawable getApplicationBanner(String packageName) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(((LoadedPlugin)plugin).mPackage.applicationInfo.banner);
            }
            return this.mHostPackageManager.getApplicationBanner(packageName);
        }

        public Drawable getActivityLogo(ComponentName component) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return plugin.mResources.getDrawable(((ActivityInfo)((LoadedPlugin)plugin).mActivityInfos.get((Object)component)).logo);
            }
            return this.mHostPackageManager.getActivityLogo(component);
        }

        public Drawable getActivityLogo(Intent intent) throws PackageManager.NameNotFoundException {
            ResolveInfo ri = LoadedPlugin.this.mPluginManager.resolveActivity(intent);
            if (null != ri) {
                LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(ri.resolvePackageName);
                return plugin.mResources.getDrawable(ri.activityInfo.logo);
            }
            return this.mHostPackageManager.getActivityLogo(intent);
        }

        public Drawable getApplicationLogo(ApplicationInfo info) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(info.packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(0 != info.logo ? info.logo : 17301651);
            }
            return this.mHostPackageManager.getApplicationLogo(info);
        }

        public Drawable getApplicationLogo(String packageName) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mResources.getDrawable(0 != ((LoadedPlugin)plugin).mPackage.applicationInfo.logo ? ((LoadedPlugin)plugin).mPackage.applicationInfo.logo : 17301651);
            }
            return this.mHostPackageManager.getApplicationLogo(packageName);
        }

        @TargetApi(value=21)
        public Drawable getUserBadgedIcon(Drawable icon, UserHandle user) {
            return this.mHostPackageManager.getUserBadgedIcon(icon, user);
        }

        public Drawable getUserBadgeForDensity(UserHandle user, int density) {
            try {
                Method method = PackageManager.class.getMethod("getUserBadgeForDensity", UserHandle.class, Integer.TYPE);
                return (Drawable)method.invoke((Object)this.mHostPackageManager, user, density);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @TargetApi(value=21)
        public Drawable getUserBadgedDrawableForDensity(Drawable drawable2, UserHandle user, Rect badgeLocation, int badgeDensity) {
            return this.mHostPackageManager.getUserBadgedDrawableForDensity(drawable2, user, badgeLocation, badgeDensity);
        }

        @TargetApi(value=21)
        public CharSequence getUserBadgedLabel(CharSequence label, UserHandle user) {
            return this.mHostPackageManager.getUserBadgedLabel(label, user);
        }

        public CharSequence getText(String packageName, int resid, ApplicationInfo appInfo) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mResources.getText(resid);
            }
            return this.mHostPackageManager.getText(packageName, resid, appInfo);
        }

        public XmlResourceParser getXml(String packageName, int resid, ApplicationInfo appInfo) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return plugin.mResources.getXml(resid);
            }
            return this.mHostPackageManager.getXml(packageName, resid, appInfo);
        }

        public CharSequence getApplicationLabel(ApplicationInfo info) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(info.packageName);
            if (null != plugin) {
                try {
                    return plugin.mResources.getText(info.labelRes);
                }
                catch (Resources.NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            return this.mHostPackageManager.getApplicationLabel(info);
        }

        public Resources getResourcesForActivity(ComponentName component) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(component);
            if (null != plugin) {
                return plugin.mResources;
            }
            return this.mHostPackageManager.getResourcesForActivity(component);
        }

        public Resources getResourcesForApplication(ApplicationInfo app) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(app.packageName);
            if (null != plugin) {
                return plugin.mResources;
            }
            return this.mHostPackageManager.getResourcesForApplication(app);
        }

        public Resources getResourcesForApplication(String appPackageName) throws PackageManager.NameNotFoundException {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(appPackageName);
            if (null != plugin) {
                return plugin.mResources;
            }
            return this.mHostPackageManager.getResourcesForApplication(appPackageName);
        }

        public void verifyPendingInstall(int id, int verificationCode) {
            this.mHostPackageManager.verifyPendingInstall(id, verificationCode);
        }

        @TargetApi(value=17)
        public void extendVerificationTimeout(int id, int verificationCodeAtTimeout, long millisecondsToDelay) {
            this.mHostPackageManager.extendVerificationTimeout(id, verificationCodeAtTimeout, millisecondsToDelay);
        }

        public void setInstallerPackageName(String targetPackage, String installerPackageName) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(targetPackage);
            if (null != plugin) {
                return;
            }
            this.mHostPackageManager.setInstallerPackageName(targetPackage, installerPackageName);
        }

        public String getInstallerPackageName(String packageName) {
            LoadedPlugin plugin = LoadedPlugin.this.mPluginManager.getLoadedPlugin(packageName);
            if (null != plugin) {
                return LoadedPlugin.this.mHostContext.getPackageName();
            }
            return this.mHostPackageManager.getInstallerPackageName(packageName);
        }

        public void addPackageToPreferred(String packageName) {
            this.mHostPackageManager.addPackageToPreferred(packageName);
        }

        public void removePackageFromPreferred(String packageName) {
            this.mHostPackageManager.removePackageFromPreferred(packageName);
        }

        public List<PackageInfo> getPreferredPackages(int flags) {
            return this.mHostPackageManager.getPreferredPackages(flags);
        }

        public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
            this.mHostPackageManager.addPreferredActivity(filter, match, set, activity);
        }

        public void clearPackagePreferredActivities(String packageName) {
            this.mHostPackageManager.clearPackagePreferredActivities(packageName);
        }

        public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
            return this.mHostPackageManager.getPreferredActivities(outFilters, outActivities, packageName);
        }

        public void setComponentEnabledSetting(ComponentName component, int newState, int flags) {
            this.mHostPackageManager.setComponentEnabledSetting(component, newState, flags);
        }

        public int getComponentEnabledSetting(ComponentName component) {
            return this.mHostPackageManager.getComponentEnabledSetting(component);
        }

        public void setApplicationEnabledSetting(String packageName, int newState, int flags) {
            this.mHostPackageManager.setApplicationEnabledSetting(packageName, newState, flags);
        }

        public int getApplicationEnabledSetting(String packageName) {
            return this.mHostPackageManager.getApplicationEnabledSetting(packageName);
        }

        public boolean isSafeMode() {
            return this.mHostPackageManager.isSafeMode();
        }

        @TargetApi(value=21)
        public PackageInstaller getPackageInstaller() {
            return this.mHostPackageManager.getPackageInstaller();
        }

        @TargetApi(value=24)
        public int[] getPackageGids(String s, int i) throws PackageManager.NameNotFoundException {
            return this.mHostPackageManager.getPackageGids(s);
        }

        public int getPackageUid(String s, int i) throws PackageManager.NameNotFoundException {
            Object uid = ReflectUtil.invokeNoException(PackageManager.class, this.mHostPackageManager, "getPackageUid", new Class[]{String.class, Integer.TYPE}, s, i);
            if (uid != null) {
                return (Integer)uid;
            }
            throw new PackageManager.NameNotFoundException(s);
        }

        @TargetApi(value=23)
        public boolean isPermissionRevokedByPolicy(String s, String s1) {
            return false;
        }

        @TargetApi(value=24)
        public boolean hasSystemFeature(String s, int i) {
            return this.mHostPackageManager.hasSystemFeature(s);
        }
    }
}

