/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.delegate;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.OperationApplicationException;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.Log;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.internal.LoadedPlugin;
import com.didi.virtualapk.utils.RunUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RemoteContentProvider
extends ContentProvider {
    private static final String TAG = "RemoteContentProvider";
    public static final String KEY_PKG = "pkg";
    public static final String KEY_PLUGIN = "plugin";
    public static final String KEY_URI = "uri";
    public static final String KEY_WRAPPER_URI = "wrapper_uri";
    private static Map<String, ContentProvider> sCachedProviders = new HashMap<String, ContentProvider>();

    public boolean onCreate() {
        Log.d((String)TAG, (String)("onCreate, current thread:" + Thread.currentThread().getName()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentProvider getContentProvider(final Uri uri) {
        final PluginManager pluginManager = PluginManager.getInstance(this.getContext());
        Uri pluginUri = Uri.parse((String)uri.getQueryParameter(KEY_URI));
        final String auth = pluginUri.getAuthority();
        ContentProvider cachedProvider = sCachedProviders.get(auth);
        if (cachedProvider != null) {
            return cachedProvider;
        }
        Map<String, ContentProvider> map = sCachedProviders;
        synchronized (map) {
            ProviderInfo providerInfo;
            LoadedPlugin plugin = pluginManager.getLoadedPlugin(uri.getQueryParameter(KEY_PKG));
            if (plugin == null) {
                try {
                    pluginManager.loadPlugin(new File(uri.getQueryParameter(KEY_PLUGIN)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((providerInfo = pluginManager.resolveContentProvider(auth, 0)) != null) {
                RunUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LoadedPlugin loadedPlugin = pluginManager.getLoadedPlugin(uri.getQueryParameter(RemoteContentProvider.KEY_PKG));
                            ContentProvider contentProvider = (ContentProvider)Class.forName(providerInfo.name).newInstance();
                            contentProvider.attachInfo(loadedPlugin.getPluginContext(), providerInfo);
                            sCachedProviders.put(auth, contentProvider);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, true);
                return sCachedProviders.get(auth);
            }
        }
        return null;
    }

    public String getType(Uri uri) {
        ContentProvider provider = this.getContentProvider(uri);
        Uri pluginUri = Uri.parse((String)uri.getQueryParameter(KEY_URI));
        if (provider != null) {
            return provider.getType(pluginUri);
        }
        return null;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        ContentProvider provider = this.getContentProvider(uri);
        Uri pluginUri = Uri.parse((String)uri.getQueryParameter(KEY_URI));
        if (provider != null) {
            return provider.query(pluginUri, projection, selection, selectionArgs, sortOrder);
        }
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        ContentProvider provider = this.getContentProvider(uri);
        Uri pluginUri = Uri.parse((String)uri.getQueryParameter(KEY_URI));
        if (provider != null) {
            return provider.insert(pluginUri, values);
        }
        return uri;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        ContentProvider provider = this.getContentProvider(uri);
        Uri pluginUri = Uri.parse((String)uri.getQueryParameter(KEY_URI));
        if (provider != null) {
            return provider.delete(pluginUri, selection, selectionArgs);
        }
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        ContentProvider provider = this.getContentProvider(uri);
        Uri pluginUri = Uri.parse((String)uri.getQueryParameter(KEY_URI));
        if (provider != null) {
            return provider.update(pluginUri, values, selection, selectionArgs);
        }
        return 0;
    }

    public int bulkInsert(Uri uri, ContentValues[] values) {
        ContentProvider provider = this.getContentProvider(uri);
        Uri pluginUri = Uri.parse((String)uri.getQueryParameter(KEY_URI));
        if (provider != null) {
            return provider.bulkInsert(pluginUri, values);
        }
        return 0;
    }

    @NonNull
    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        ContentProvider provider;
        try {
            Field uriField = ContentProviderOperation.class.getDeclaredField("mUri");
            uriField.setAccessible(true);
            for (ContentProviderOperation operation : operations) {
                Uri pluginUri = Uri.parse((String)operation.getUri().getQueryParameter(KEY_URI));
                uriField.set(operation, pluginUri);
            }
        }
        catch (Exception e) {
            return new ContentProviderResult[0];
        }
        if (operations.size() > 0 && (provider = this.getContentProvider(operations.get(0).getUri())) != null) {
            return provider.applyBatch(operations);
        }
        return new ContentProviderResult[0];
    }

    public Bundle call(String method, String arg, Bundle extras) {
        Log.d((String)TAG, (String)("call " + method + " with extras : " + extras));
        if (extras == null || extras.getString(KEY_WRAPPER_URI) == null) {
            return null;
        }
        Uri uri = Uri.parse((String)extras.getString(KEY_WRAPPER_URI));
        ContentProvider provider = this.getContentProvider(uri);
        if (provider != null) {
            return provider.call(method, arg, extras);
        }
        return null;
    }
}

