/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.internal;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.os.IBinder;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.internal.LoadedPlugin;
import com.didi.virtualapk.internal.StubActivityInfo;
import java.util.concurrent.atomic.AtomicInteger;

public class ComponentsHandler {
    public static final String TAG = "PluginManager";
    private Context mContext;
    private PluginManager mPluginManager;
    private StubActivityInfo mStubActivityInfo = new StubActivityInfo();
    private ArrayMap<ComponentName, Service> mServices = new ArrayMap();
    private ArrayMap<IBinder, Intent> mBoundServices = new ArrayMap();
    private ArrayMap<Service, AtomicInteger> mServiceCounters = new ArrayMap();

    public ComponentsHandler(PluginManager pluginManager) {
        this.mPluginManager = pluginManager;
        this.mContext = pluginManager.getHostContext();
    }

    public Intent transformIntentToExplicitAsNeeded(Intent intent) {
        ResolveInfo info;
        ComponentName component = intent.getComponent();
        if (component == null && (info = this.mPluginManager.resolveActivity(intent)) != null && info.activityInfo != null) {
            component = new ComponentName(info.activityInfo.packageName, info.activityInfo.name);
            intent.setComponent(component);
        }
        return intent;
    }

    public void markIntentIfNeeded(Intent intent) {
        if (intent.getComponent() == null) {
            return;
        }
        String targetPackageName = intent.getComponent().getPackageName();
        String targetClassName = intent.getComponent().getClassName();
        if (!targetPackageName.equals(this.mContext.getPackageName()) && this.mPluginManager.getLoadedPlugin(targetPackageName) != null) {
            intent.putExtra("isPlugin", true);
            intent.putExtra("target.package", targetPackageName);
            intent.putExtra("target.activity", targetClassName);
            this.dispatchStubActivity(intent);
        }
    }

    private void dispatchStubActivity(Intent intent) {
        ComponentName component = intent.getComponent();
        String targetClassName = intent.getComponent().getClassName();
        LoadedPlugin loadedPlugin = this.mPluginManager.getLoadedPlugin(intent);
        ActivityInfo info = loadedPlugin.getActivityInfo(component);
        if (info == null) {
            throw new RuntimeException("can not find " + component);
        }
        int launchMode = info.launchMode;
        Resources.Theme themeObj = loadedPlugin.getResources().newTheme();
        themeObj.applyStyle(info.theme, true);
        String stubActivity = this.mStubActivityInfo.getStubActivity(targetClassName, launchMode, themeObj);
        Log.i((String)TAG, (String)String.format("dispatchStubActivity,[%s -> %s]", targetClassName, stubActivity));
        intent.setClassName(this.mContext, stubActivity);
    }

    public AtomicInteger getServiceCounter(Service service) {
        return (AtomicInteger)this.mServiceCounters.get((Object)service);
    }

    public Service getService(ComponentName component) {
        return (Service)this.mServices.get((Object)component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rememberService(ComponentName component, Service service) {
        ArrayMap<ComponentName, Service> arrayMap = this.mServices;
        synchronized (arrayMap) {
            this.mServices.put((Object)component, (Object)service);
            this.mServiceCounters.put((Object)service, (Object)new AtomicInteger(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service forgetService(ComponentName component) {
        ArrayMap<ComponentName, Service> arrayMap = this.mServices;
        synchronized (arrayMap) {
            Service service = (Service)this.mServices.remove((Object)component);
            this.mServiceCounters.remove((Object)service);
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent forgetIServiceConnection(IBinder iServiceConnection) {
        ArrayMap<IBinder, Intent> arrayMap = this.mBoundServices;
        synchronized (arrayMap) {
            Intent intent = (Intent)this.mBoundServices.remove((Object)iServiceConnection);
            return intent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remberIServiceConnection(IBinder iServiceConnection, Intent intent) {
        ArrayMap<IBinder, Intent> arrayMap = this.mBoundServices;
        synchronized (arrayMap) {
            this.mBoundServices.put((Object)iServiceConnection, (Object)intent);
        }
    }

    public boolean isServiceAvailable(ComponentName component) {
        return this.mServices.containsKey((Object)component);
    }
}

