/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.delegate;

import android.app.ActivityThread;
import android.app.Application;
import android.app.IActivityManager;
import android.app.IServiceConnection;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.internal.LoadedPlugin;
import com.didi.virtualapk.utils.PluginUtil;
import com.didi.virtualapk.utils.ReflectUtil;
import java.lang.reflect.Method;

public class LocalService
extends Service {
    private static final String TAG = "LocalService";
    public static final String EXTRA_TARGET = "target";
    public static final String EXTRA_COMMAND = "command";
    public static final String EXTRA_PLUGIN_LOCATION = "plugin_location";
    public static final int EXTRA_COMMAND_START_SERVICE = 1;
    public static final int EXTRA_COMMAND_STOP_SERVICE = 2;
    public static final int EXTRA_COMMAND_BIND_SERVICE = 3;
    public static final int EXTRA_COMMAND_UNBIND_SERVICE = 4;
    private PluginManager mPluginManager;

    public IBinder onBind(Intent intent) {
        return new Binder();
    }

    public void onCreate() {
        super.onCreate();
        this.mPluginManager = PluginManager.getInstance((Context)this);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (null == intent || !intent.hasExtra(EXTRA_TARGET) || !intent.hasExtra(EXTRA_COMMAND)) {
            return 1;
        }
        Intent target = (Intent)intent.getParcelableExtra(EXTRA_TARGET);
        int command = intent.getIntExtra(EXTRA_COMMAND, 0);
        if (null == target || command <= 0) {
            return 1;
        }
        ComponentName component = target.getComponent();
        LoadedPlugin plugin = this.mPluginManager.getLoadedPlugin(component);
        switch (command) {
            case 1: {
                Service service;
                ActivityThread mainThread = (ActivityThread)ReflectUtil.getActivityThread(this.getBaseContext());
                ActivityThread.ApplicationThread appThread = mainThread.getApplicationThread();
                if (this.mPluginManager.getComponentsHandler().isServiceAvailable(component)) {
                    service = this.mPluginManager.getComponentsHandler().getService(component);
                } else {
                    try {
                        service = (Service)plugin.getClassLoader().loadClass(component.getClassName()).newInstance();
                        Application app = plugin.getApplication();
                        IBinder token = appThread.asBinder();
                        Method attach = service.getClass().getMethod("attach", Context.class, ActivityThread.class, String.class, IBinder.class, Application.class, Object.class);
                        IActivityManager am = this.mPluginManager.getActivityManager();
                        attach.invoke((Object)service, plugin.getPluginContext(), mainThread, component.getClassName(), token, app, am);
                        service.onCreate();
                        this.mPluginManager.getComponentsHandler().rememberService(component, service);
                    }
                    catch (Throwable t) {
                        return 1;
                    }
                }
                service.onStartCommand(target, 0, this.mPluginManager.getComponentsHandler().getServiceCounter(service).getAndIncrement());
                break;
            }
            case 3: {
                ActivityThread mainThread = (ActivityThread)ReflectUtil.getActivityThread(this.getBaseContext());
                ActivityThread.ApplicationThread appThread = mainThread.getApplicationThread();
                Service service = null;
                if (this.mPluginManager.getComponentsHandler().isServiceAvailable(component)) {
                    service = this.mPluginManager.getComponentsHandler().getService(component);
                } else {
                    try {
                        service = (Service)plugin.getClassLoader().loadClass(component.getClassName()).newInstance();
                        Application app = plugin.getApplication();
                        IBinder token = appThread.asBinder();
                        Method attach = service.getClass().getMethod("attach", Context.class, ActivityThread.class, String.class, IBinder.class, Application.class, Object.class);
                        IActivityManager am = this.mPluginManager.getActivityManager();
                        attach.invoke((Object)service, plugin.getPluginContext(), mainThread, component.getClassName(), token, app, am);
                        service.onCreate();
                        this.mPluginManager.getComponentsHandler().rememberService(component, service);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                try {
                    IBinder binder = service.onBind(target);
                    IBinder serviceConnection = PluginUtil.getBinder(intent.getExtras(), "sc");
                    IServiceConnection iServiceConnection = IServiceConnection.Stub.asInterface((IBinder)serviceConnection);
                    iServiceConnection.connected(component, binder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                Service service = this.mPluginManager.getComponentsHandler().forgetService(component);
                if (null != service) {
                    try {
                        service.onDestroy();
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)("Unable to stop service " + service + ": " + e.toString()));
                    }
                    break;
                }
                Log.i((String)TAG, (String)(component + " not found"));
                break;
            }
            case 4: {
                Service service = this.mPluginManager.getComponentsHandler().forgetService(component);
                if (null != service) {
                    try {
                        service.onUnbind(target);
                        service.onDestroy();
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)("Unable to unbind service " + service + ": " + e.toString()));
                    }
                    break;
                }
                Log.i((String)TAG, (String)(component + " not found"));
                break;
            }
        }
        return 1;
    }
}

