/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk.delegate;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.app.IApplicationThread;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.didi.virtualapk.PluginManager;
import com.didi.virtualapk.delegate.LocalService;
import com.didi.virtualapk.delegate.RemoteService;
import com.didi.virtualapk.utils.PluginUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ActivityManagerProxy
implements InvocationHandler {
    private static final String TAG = "IActivityManagerProxy";
    public static final int INTENT_SENDER_BROADCAST = 1;
    public static final int INTENT_SENDER_ACTIVITY = 2;
    public static final int INTENT_SENDER_ACTIVITY_RESULT = 3;
    public static final int INTENT_SENDER_SERVICE = 4;
    private PluginManager mPluginManager;
    private IActivityManager mActivityManager;

    public static IActivityManager newInstance(PluginManager pluginManager, IActivityManager activityManager) {
        return (IActivityManager)Proxy.newProxyInstance(activityManager.getClass().getClassLoader(), new Class[]{IActivityManager.class}, (InvocationHandler)new ActivityManagerProxy(pluginManager, activityManager));
    }

    public ActivityManagerProxy(PluginManager pluginManager, IActivityManager activityManager) {
        this.mPluginManager = pluginManager;
        this.mActivityManager = activityManager;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        block26: {
            if ("startService".equals(method.getName())) {
                try {
                    return this.startService(proxy, method, args);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)"Start service error", (Throwable)e);
                    break block26;
                }
            }
            if ("stopService".equals(method.getName())) {
                try {
                    return this.stopService(proxy, method, args);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)"Stop Service error", (Throwable)e);
                    break block26;
                }
            }
            if ("stopServiceToken".equals(method.getName())) {
                try {
                    return this.stopServiceToken(proxy, method, args);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)"Stop service token error", (Throwable)e);
                    break block26;
                }
            }
            if ("bindService".equals(method.getName())) {
                try {
                    return this.bindService(proxy, method, args);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    break block26;
                }
            }
            if ("unbindService".equals(method.getName())) {
                try {
                    return this.unbindService(proxy, method, args);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    break block26;
                }
            }
            if ("getIntentSender".equals(method.getName())) {
                try {
                    this.getIntentSender(method, args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("overridePendingTransition".equals(method.getName())) {
                try {
                    this.overridePendingTransition(method, args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            return method.invoke((Object)this.mActivityManager, args);
        }
        catch (Throwable th) {
            IBinder ams;
            Throwable c = th.getCause();
            if (c != null && c instanceof DeadObjectException && (ams = ServiceManager.getService((String)"activity")) != null) {
                IActivityManager am;
                this.mActivityManager = am = ActivityManagerNative.asInterface((IBinder)ams);
            }
            Throwable cause = th;
            do {
                if (!(cause instanceof RemoteException)) continue;
                throw cause;
            } while ((cause = cause.getCause()) != null);
            throw c != null ? c : th;
        }
    }

    private Object startService(Object proxy, Method method, Object[] args) throws Throwable {
        IApplicationThread appThread = (IApplicationThread)args[0];
        Intent target = (Intent)args[1];
        ResolveInfo resolveInfo = this.mPluginManager.resolveService(target, 0);
        if (null == resolveInfo || null == resolveInfo.serviceInfo) {
            return method.invoke((Object)this.mActivityManager, args);
        }
        return this.startDelegateServiceForTarget(target, resolveInfo.serviceInfo, null, 1);
    }

    private Object stopService(Object proxy, Method method, Object[] args) throws Throwable {
        Intent target = (Intent)args[1];
        ResolveInfo resolveInfo = this.mPluginManager.resolveService(target, 0);
        if (null == resolveInfo || null == resolveInfo.serviceInfo) {
            return method.invoke((Object)this.mActivityManager, args);
        }
        this.startDelegateServiceForTarget(target, resolveInfo.serviceInfo, null, 2);
        return 1;
    }

    private Object stopServiceToken(Object proxy, Method method, Object[] args) throws Throwable {
        ComponentName component = (ComponentName)args[0];
        Intent target = new Intent().setComponent(component);
        ResolveInfo resolveInfo = this.mPluginManager.resolveService(target, 0);
        if (null == resolveInfo || null == resolveInfo.serviceInfo) {
            return method.invoke((Object)this.mActivityManager, args);
        }
        this.startDelegateServiceForTarget(target, resolveInfo.serviceInfo, null, 2);
        return true;
    }

    private Object bindService(Object proxy, Method method, Object[] args) throws Throwable {
        Intent target = (Intent)args[2];
        ResolveInfo resolveInfo = this.mPluginManager.resolveService(target, 0);
        if (null == resolveInfo || null == resolveInfo.serviceInfo) {
            return method.invoke((Object)this.mActivityManager, args);
        }
        Bundle bundle = new Bundle();
        PluginUtil.putBinder(bundle, "sc", (IBinder)args[4]);
        this.startDelegateServiceForTarget(target, resolveInfo.serviceInfo, bundle, 3);
        this.mPluginManager.getComponentsHandler().remberIServiceConnection((IBinder)args[4], target);
        return 1;
    }

    private Object unbindService(Object proxy, Method method, Object[] args) throws Throwable {
        IBinder iServiceConnection = (IBinder)args[0];
        Intent target = this.mPluginManager.getComponentsHandler().forgetIServiceConnection(iServiceConnection);
        if (target == null) {
            return method.invoke((Object)this.mActivityManager, args);
        }
        ResolveInfo resolveInfo = this.mPluginManager.resolveService(target, 0);
        this.startDelegateServiceForTarget(target, resolveInfo.serviceInfo, null, 4);
        return true;
    }

    private ComponentName startDelegateServiceForTarget(Intent target, ServiceInfo serviceInfo, Bundle extras, int command) {
        Intent wrapperIntent = this.wrapperTargetIntent(target, serviceInfo, extras, command);
        return this.mPluginManager.getHostContext().startService(wrapperIntent);
    }

    private Intent wrapperTargetIntent(Intent target, ServiceInfo serviceInfo, Bundle extras, int command) {
        target.setComponent(new ComponentName(serviceInfo.packageName, serviceInfo.name));
        String pluginLocation = this.mPluginManager.getLoadedPlugin(target.getComponent()).getLocation();
        boolean local = PluginUtil.isLocalService(serviceInfo);
        Class delegate = local ? LocalService.class : RemoteService.class;
        Intent intent = new Intent();
        intent.setClass(this.mPluginManager.getHostContext(), delegate);
        intent.putExtra("target", (Parcelable)target);
        intent.putExtra("command", command);
        intent.putExtra("plugin_location", pluginLocation);
        if (extras != null) {
            intent.putExtras(extras);
        }
        return intent;
    }

    private void getIntentSender(Method method, Object[] args) {
        String hostPackageName = this.mPluginManager.getHostContext().getPackageName();
        args[1] = hostPackageName;
        Intent target = ((Intent[])args[5])[0];
        int intentSenderType = (Integer)args[0];
        if (intentSenderType == 2) {
            this.mPluginManager.getComponentsHandler().transformIntentToExplicitAsNeeded(target);
            this.mPluginManager.getComponentsHandler().markIntentIfNeeded(target);
        } else if (intentSenderType == 4) {
            ResolveInfo resolveInfo = this.mPluginManager.resolveService(target, 0);
            if (resolveInfo != null && resolveInfo.serviceInfo != null) {
                Intent wrapperIntent;
                ((Intent[])args[5])[0] = wrapperIntent = this.wrapperTargetIntent(target, resolveInfo.serviceInfo, null, 1);
            }
        } else if (intentSenderType == 1) {
            // empty if block
        }
    }

    private void overridePendingTransition(Method method, Object[] args) {
        String hostPackageName = this.mPluginManager.getHostContext().getPackageName();
        args[1] = hostPackageName;
    }
}

