/*
 * Decompiled with CFR 0.152.
 */
package com.didi.virtualapk;

import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.Application;
import android.app.IActivityManager;
import android.app.Instrumentation;
import android.content.ComponentName;
import android.content.Context;
import android.content.IContentProvider;
import android.content.Intent;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.util.Log;
import android.util.Singleton;
import com.didi.virtualapk.Systems;
import com.didi.virtualapk.delegate.ActivityManagerProxy;
import com.didi.virtualapk.delegate.IContentProviderProxy;
import com.didi.virtualapk.internal.ComponentsHandler;
import com.didi.virtualapk.internal.LoadedPlugin;
import com.didi.virtualapk.internal.PluginContentResolver;
import com.didi.virtualapk.internal.VAInstrumentation;
import com.didi.virtualapk.utils.PluginUtil;
import com.didi.virtualapk.utils.ReflectUtil;
import com.didi.virtualapk.utils.RunUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PluginManager {
    public static final String TAG = "PluginManager";
    private static volatile PluginManager sInstance = null;
    private Context mContext;
    private ComponentsHandler mComponentsHandler;
    private Map<String, LoadedPlugin> mPlugins = new ConcurrentHashMap<String, LoadedPlugin>();
    private Instrumentation mInstrumentation;
    private IActivityManager mActivityManager;
    private IContentProvider mIContentProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PluginManager getInstance(Context base) {
        if (sInstance != null) return sInstance;
        Class<PluginManager> clazz = PluginManager.class;
        synchronized (PluginManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new PluginManager(base);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private PluginManager(Context context) {
        Context app = context.getApplicationContext();
        this.mContext = app == null ? context : ((Application)app).getBaseContext();
        this.prepare();
    }

    private void prepare() {
        Systems.sHostContext = this.getHostContext();
        this.hookInstrumentationAndHandler();
        this.hookSystemServices();
    }

    public void init() {
        this.mComponentsHandler = new ComponentsHandler(this);
        RunUtil.getThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                PluginManager.this.doInWorkThread();
            }
        });
    }

    private void doInWorkThread() {
    }

    private void hookSystemServices() {
        try {
            Singleton defaultSingleton = (Singleton)ReflectUtil.getField(ActivityManagerNative.class, null, "gDefault");
            IActivityManager activityManagerProxy = ActivityManagerProxy.newInstance(this, (IActivityManager)defaultSingleton.get());
            ReflectUtil.setField(defaultSingleton.getClass().getSuperclass(), defaultSingleton, "mInstance", activityManagerProxy);
            if (defaultSingleton.get() == activityManagerProxy) {
                this.mActivityManager = activityManagerProxy;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hookInstrumentationAndHandler() {
        try {
            Instrumentation baseInstrumentation = ReflectUtil.getInstrumentation(this.mContext);
            if (baseInstrumentation.getClass().getName().contains("lbe")) {
                System.exit(0);
            }
            VAInstrumentation instrumentation = new VAInstrumentation(this, baseInstrumentation);
            Object activityThread = ReflectUtil.getActivityThread(this.mContext);
            ReflectUtil.setInstrumentation(activityThread, instrumentation);
            ReflectUtil.setHandlerCallback(this.mContext, instrumentation);
            this.mInstrumentation = instrumentation;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hookIContentProviderAsNeeded() {
        Uri uri = Uri.parse((String)PluginContentResolver.getUri(this.mContext));
        this.mContext.getContentResolver().call(uri, "wakeup", null, null);
        try {
            Field authority = null;
            Field mProvider = null;
            ActivityThread activityThread = (ActivityThread)ReflectUtil.getActivityThread(this.mContext);
            Map mProviderMap = (Map)ReflectUtil.getField(activityThread.getClass(), activityThread, "mProviderMap");
            for (Map.Entry entry : mProviderMap.entrySet()) {
                IContentProvider proxy;
                String auth;
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (key instanceof String) {
                    auth = (String)key;
                } else {
                    if (authority == null) {
                        authority = key.getClass().getDeclaredField("authority");
                        authority.setAccessible(true);
                    }
                    auth = (String)authority.get(key);
                }
                if (!auth.equals(PluginContentResolver.getAuthority(this.mContext))) continue;
                if (mProvider == null) {
                    mProvider = val.getClass().getDeclaredField("mProvider");
                    mProvider.setAccessible(true);
                }
                IContentProvider rawProvider = (IContentProvider)mProvider.get(val);
                this.mIContentProvider = proxy = IContentProviderProxy.newInstance(this.mContext, rawProvider);
                Log.d((String)TAG, (String)("hookIContentProvider succeed : " + this.mIContentProvider));
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadPlugin(File apk) throws Exception {
        if (null == apk) {
            throw new IllegalArgumentException("error : apk is null.");
        }
        if (!apk.exists()) {
            throw new FileNotFoundException(apk.getAbsolutePath());
        }
        LoadedPlugin plugin = LoadedPlugin.create(this, this.mContext, apk);
        if (null == plugin) {
            throw new RuntimeException("Can't load plugin which is invalid: " + apk.getAbsolutePath());
        }
        this.mPlugins.put(plugin.getPackageName(), plugin);
        plugin.invokeApplication();
    }

    public LoadedPlugin getLoadedPlugin(Intent intent) {
        ComponentName component = PluginUtil.getComponent(intent);
        return this.getLoadedPlugin(component.getPackageName());
    }

    public LoadedPlugin getLoadedPlugin(ComponentName component) {
        return this.getLoadedPlugin(component.getPackageName());
    }

    public LoadedPlugin getLoadedPlugin(String packageName) {
        return this.mPlugins.get(packageName);
    }

    public List<LoadedPlugin> getAllLoadedPlugins() {
        ArrayList<LoadedPlugin> list = new ArrayList<LoadedPlugin>();
        list.addAll(this.mPlugins.values());
        return list;
    }

    public Context getHostContext() {
        return this.mContext;
    }

    public Instrumentation getInstrumentation() {
        return this.mInstrumentation;
    }

    public IActivityManager getActivityManager() {
        return this.mActivityManager;
    }

    public synchronized IContentProvider getIContentProvider() {
        if (this.mIContentProvider == null) {
            this.hookIContentProviderAsNeeded();
        }
        return this.mIContentProvider;
    }

    public ComponentsHandler getComponentsHandler() {
        return this.mComponentsHandler;
    }

    public ResolveInfo resolveActivity(Intent intent) {
        return this.resolveActivity(intent, 0);
    }

    public ResolveInfo resolveActivity(Intent intent, int flags) {
        for (LoadedPlugin plugin : this.mPlugins.values()) {
            ResolveInfo resolveInfo = plugin.resolveActivity(intent, flags);
            if (null == resolveInfo) continue;
            return resolveInfo;
        }
        return null;
    }

    public ResolveInfo resolveService(Intent intent, int flags) {
        for (LoadedPlugin plugin : this.mPlugins.values()) {
            ResolveInfo resolveInfo = plugin.resolveService(intent, flags);
            if (null == resolveInfo) continue;
            return resolveInfo;
        }
        return null;
    }

    public ProviderInfo resolveContentProvider(String name, int flags) {
        for (LoadedPlugin plugin : this.mPlugins.values()) {
            ProviderInfo providerInfo = plugin.resolveContentProvider(name, flags);
            if (null == providerInfo) continue;
            return providerInfo;
        }
        return null;
    }

    @Deprecated
    public List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        for (LoadedPlugin plugin : this.mPlugins.values()) {
            List<ResolveInfo> result = plugin.queryIntentActivities(intent, flags);
            if (null == result || result.size() <= 0) continue;
            resolveInfos.addAll(result);
        }
        return resolveInfos;
    }

    @Deprecated
    public List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        for (LoadedPlugin plugin : this.mPlugins.values()) {
            List<ResolveInfo> result = plugin.queryIntentServices(intent, flags);
            if (null == result || result.size() <= 0) continue;
            resolveInfos.addAll(result);
        }
        return resolveInfos;
    }

    @Deprecated
    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        for (LoadedPlugin plugin : this.mPlugins.values()) {
            List<ResolveInfo> result = plugin.queryBroadcastReceivers(intent, flags);
            if (null == result || result.size() <= 0) continue;
            resolveInfos.addAll(result);
        }
        return resolveInfos;
    }
}

