/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.service;

import android.arch.lifecycle.LifecycleOwner;
import android.support.annotation.NonNull;
import com.didi.drouter.service.ServiceAgent;
import java.util.List;

public class ServiceLoader<T> {
    final ServiceAgent<T> serviceAgent;

    private ServiceLoader(Class<T> function) {
        this.serviceAgent = new ServiceAgent<T>(function);
    }

    @NonNull
    public static <T> ServiceLoader<T> build(Class<T> function) {
        if (function == null) {
            throw new RuntimeException("DRouter function class can't be null");
        }
        return new ServiceLoader<T>(function);
    }

    public ServiceLoader<T> setAlias(String alias) {
        this.serviceAgent.setAlias(alias);
        return this;
    }

    public ServiceLoader<T> setFeature(Object feature) {
        this.serviceAgent.setFeature(feature);
        return this;
    }

    public ServiceLoader<T> setRemoteAuthority(String authority) {
        this.serviceAgent.setRemoteAuthority(authority);
        return this;
    }

    public ServiceLoader<T> setRemoteDeadResend(int strategy) {
        this.serviceAgent.setRemoteDeadResend(strategy);
        return this;
    }

    public ServiceLoader<T> setLifecycleOwner(LifecycleOwner owner) {
        this.serviceAgent.setLifecycleOwner(owner);
        return this;
    }

    public ServiceLoader<T> setDefaultIfEmpty(T defaultService) {
        this.serviceAgent.setDefaultIfEmpty(defaultService);
        return this;
    }

    public T getService(Object ... parameter) {
        return this.serviceAgent.getService(parameter);
    }

    @NonNull
    public List<T> getAllService(Object ... parameter) {
        return this.serviceAgent.getAllService(parameter);
    }

    public Class<? extends T> getServiceClass() {
        return this.serviceAgent.getServiceClass();
    }

    @NonNull
    public List<Class<? extends T>> getAllServiceClass() {
        return this.serviceAgent.getAllServiceClass();
    }
}

