/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.router;

import android.arch.lifecycle.LifecycleOwner;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.didi.drouter.api.DRouter;
import com.didi.drouter.router.DataExtras;
import com.didi.drouter.router.IRouterInterceptor;
import com.didi.drouter.router.InterceptorHandler;
import com.didi.drouter.router.RouterCallback;
import com.didi.drouter.router.RouterLoader;
import java.util.concurrent.atomic.AtomicInteger;

public class Request
extends DataExtras<Request> {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final Uri uri;
    Context context;
    LifecycleOwner lifecycleOwner;
    String authority;
    int routerType;
    int resendStrategy;
    long holdTimeout;
    String serialNumber;
    IRouterInterceptor.IInterceptor interceptor;

    private Request(@NonNull Uri uri) {
        this.uri = uri;
        this.serialNumber = String.valueOf(counter.getAndIncrement());
        this.putExtra("DRouter_request_build_uri", uri.toString());
    }

    public static Request build(String uri) {
        return new Request(uri == null ? Uri.EMPTY : Uri.parse((String)uri));
    }

    public void start() {
        this.start(null, null);
    }

    public void start(Context context) {
        this.start(context, null);
    }

    public void start(Context context, RouterCallback callback) {
        this.context = context == null ? DRouter.getContext() : context;
        RouterLoader.build(this, callback).start();
    }

    public Context getContext() {
        return this.context;
    }

    @NonNull
    public Uri getUri() {
        return this.uri;
    }

    public int getRouterType() {
        return this.routerType;
    }

    @NonNull
    public String getNumber() {
        return this.serialNumber;
    }

    public Request setHoldTimeout(long millisecond) {
        this.holdTimeout = millisecond;
        return this;
    }

    public Request setRemoteAuthority(String authority) {
        this.authority = authority;
        return this;
    }

    public Request setRemoteDeadResend(int strategy) {
        this.resendStrategy = strategy;
        return this;
    }

    public Request setLifecycleOwner(LifecycleOwner owner) {
        this.lifecycleOwner = owner;
        return this;
    }

    @NonNull
    public IRouterInterceptor.IInterceptor getInterceptor() {
        if (this.interceptor == null) {
            return new InterceptorHandler.Default();
        }
        return this.interceptor;
    }
}

