/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.store;

import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.didi.drouter.router.IRouterHandler;
import com.didi.drouter.router.IRouterInterceptor;
import com.didi.drouter.service.IFeatureMatcher;
import com.didi.drouter.store.IRouterProxy;
import com.didi.drouter.store.RouterKey;
import com.didi.drouter.store.ServiceKey;
import com.didi.drouter.utils.TextUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class RouterMeta {
    public static int ACTIVITY = 1;
    public static int FRAGMENT = 2;
    public static int VIEW = 3;
    public static int HANDLER = 4;
    public static int INTERCEPTOR = 5;
    public static int SERVICE = 6;
    private int routerType;
    private Class<?> routerClass;
    private IRouterProxy routerProxy;
    private int priority;
    private boolean isDynamic;
    @NonNull
    private String scheme;
    @NonNull
    private String host;
    @NonNull
    private String path;
    private String activityName;
    @Nullable
    private Class<? extends IRouterInterceptor>[] interceptors;
    private int thread;
    private boolean hold;
    private Intent intent;
    private RouterKey routerKey;
    private IRouterHandler handler;
    private String serviceAlias;
    @Nullable
    private IFeatureMatcher<?> featureMatcher;
    private ServiceKey serviceKey;
    private Object service;
    private boolean global;
    private int cache;

    private RouterMeta(int routerType) {
        this.routerType = routerType;
    }

    public static RouterMeta build(int routerType) {
        return new RouterMeta(routerType);
    }

    public RouterMeta assembleRouter(String scheme, String host, String path, String routerClassName, IRouterProxy routerProxy, Class<? extends IRouterInterceptor>[] interceptors, int thread, int priority, boolean hold) {
        this.scheme = scheme;
        this.host = host;
        this.path = path;
        this.activityName = routerClassName;
        this.routerProxy = routerProxy;
        this.interceptors = interceptors;
        this.thread = thread;
        this.priority = priority;
        this.hold = hold;
        return this;
    }

    public RouterMeta assembleRouter(String scheme, String host, String path, Class<?> routerClass, IRouterProxy routerProxy, Class<? extends IRouterInterceptor>[] interceptors, int thread, int priority, boolean hold) {
        this.scheme = scheme;
        this.host = host;
        this.path = path;
        this.routerClass = routerClass;
        this.routerProxy = routerProxy;
        this.interceptors = interceptors;
        this.thread = thread;
        this.priority = priority;
        this.hold = hold;
        return this;
    }

    public RouterMeta assembleRouter(Intent intent) {
        this.intent = intent;
        return this;
    }

    public void setHandler(RouterKey key, @NonNull IRouterHandler handler) {
        this.routerKey = key;
        this.handler = handler;
        this.isDynamic = true;
    }

    public RouterMeta assembleService(Class<?> routerClass, IRouterProxy routerProxy, String alias, IFeatureMatcher<?> featureMatcher, int priority, int cache) {
        this.routerClass = routerClass;
        this.routerProxy = routerProxy;
        this.serviceAlias = alias;
        this.featureMatcher = featureMatcher;
        this.priority = priority;
        this.cache = cache;
        return this;
    }

    public void setService(ServiceKey key, Object service) {
        this.serviceKey = key;
        this.service = service;
        this.isDynamic = true;
    }

    public RouterMeta assembleInterceptor(Class<? extends IRouterInterceptor> routerClass, IRouterProxy routerProxy, int priority, boolean global, int cache) {
        this.routerClass = routerClass;
        this.routerProxy = routerProxy;
        this.priority = priority;
        this.global = global;
        this.cache = cache;
        return this;
    }

    public int getRouterType() {
        return this.routerType;
    }

    public String getActivityClassName() {
        return this.activityName;
    }

    public Class<?> getRouterClass() {
        return this.routerClass;
    }

    @Nullable
    public IRouterProxy getRouterProxy() {
        return this.routerProxy;
    }

    public String getSimpleClassName() {
        if (this.activityName != null) {
            return this.activityName.substring(this.activityName.lastIndexOf(".") + 1);
        }
        if (this.routerClass != null) {
            return this.routerClass.getSimpleName();
        }
        if (this.handler != null) {
            return this.handler.getClass().getName().substring(this.handler.getClass().getName().lastIndexOf(".") + 1);
        }
        return null;
    }

    public Class<? extends IRouterInterceptor>[] getInterceptors() {
        return this.interceptors;
    }

    public int getThread() {
        return this.thread;
    }

    public boolean isHold() {
        return this.hold;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public boolean isRegexMatch(Uri uri) {
        String s = uri.getScheme();
        String h = uri.getHost();
        String p = uri.getPath();
        return s != null && s.matches(this.scheme) && h != null && h.matches(this.host) && p != null && p.matches(this.path);
    }

    public boolean isRegexUri() {
        return TextUtils.isRegex(this.scheme) || TextUtils.isRegex(this.host) || TextUtils.isRegex(this.path);
    }

    public String getLegalUri() {
        return this.scheme + "://" + this.host + this.path;
    }

    public IRouterHandler getHandler() {
        return this.handler;
    }

    public String getServiceAlias() {
        return this.serviceAlias;
    }

    public int getCache() {
        return this.cache;
    }

    public ServiceKey getServiceKey() {
        return this.serviceKey;
    }

    public Object getService() {
        return this.service;
    }

    @Nullable
    public IFeatureMatcher getFeatureMatcher() {
        return this.featureMatcher;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }
}

