/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.router;

import android.arch.lifecycle.LifecycleOwner;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.util.ArraySet;
import android.util.SparseArray;
import com.didi.drouter.remote.RemoteBridge;
import com.didi.drouter.router.IRouterInterceptor;
import com.didi.drouter.router.InterceptorHandler;
import com.didi.drouter.router.Request;
import com.didi.drouter.router.Result;
import com.didi.drouter.router.ResultAgent;
import com.didi.drouter.router.RouterCallback;
import com.didi.drouter.router.RouterDispatcher;
import com.didi.drouter.store.RouterMeta;
import com.didi.drouter.store.RouterStore;
import com.didi.drouter.utils.RouterLogger;
import com.didi.drouter.utils.TextUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RouterLoader {
    private Request primaryRequest;
    private RouterCallback callback;

    private RouterLoader() {
    }

    @NonNull
    static RouterLoader build(Request request, RouterCallback callback) {
        RouterLoader loader = new RouterLoader();
        loader.primaryRequest = request;
        loader.callback = callback;
        return loader;
    }

    void start() {
        RouterLogger.getCoreLogger().d("---------------------------------------------------------------------------", new Object[0]);
        RouterLogger.getCoreLogger().d("primary request \"%s\", router uri \"%s\", need callback \"%s\"", this.primaryRequest.getNumber(), this.primaryRequest.getUri(), this.callback != null);
        if (TextUtils.isEmpty(this.primaryRequest.authority)) {
            this.startLocal();
        } else {
            this.startRemote();
        }
    }

    private void startLocal() {
        TextUtils.appendExtra(this.primaryRequest.getExtra(), TextUtils.getQuery(this.primaryRequest.getUri()));
        Map<Request, RouterMeta> requestMap = this.makeRequest();
        if (requestMap.isEmpty()) {
            RouterLogger.getCoreLogger().w("warning: there is no request target match", new Object[0]);
            new Result(this.primaryRequest, null, this.callback);
            ResultAgent.release(this.primaryRequest, "not_found");
            return;
        }
        final Result result = new Result(this.primaryRequest, requestMap.keySet(), this.callback);
        if (requestMap.size() > 1) {
            RouterLogger.getCoreLogger().w("warning: request match %s targets", requestMap.size());
        }
        ArrayList<Map.Entry<Request, RouterMeta>> requestList = new ArrayList<Map.Entry<Request, RouterMeta>>(requestMap.entrySet());
        Collections.sort(requestList, new RouterComparator());
        final boolean[] stopByRouterTarget = new boolean[]{false};
        for (final Map.Entry entry : requestList) {
            if (stopByRouterTarget[0]) {
                ResultAgent.release((Request)entry.getKey(), "stop_by_router_target");
                continue;
            }
            InterceptorHandler.handle((Request)entry.getKey(), (RouterMeta)entry.getValue(), new IRouterInterceptor.IInterceptor(){

                @Override
                public void onContinue() {
                    ((Request)entry.getKey()).interceptor = new IRouterInterceptor.IInterceptor(){

                        @Override
                        public void onContinue() {
                        }

                        @Override
                        public void onInterrupt() {
                            RouterLogger.getCoreLogger().w("request \"%s\" stop all remains requests", ((Request)entry.getKey()).getNumber());
                            stopByRouterTarget[0] = true;
                        }
                    };
                    RouterDispatcher.start((Request)entry.getKey(), (RouterMeta)entry.getValue(), result, RouterLoader.this.callback);
                    ((Request)entry.getKey()).interceptor = null;
                }

                @Override
                public void onInterrupt() {
                    ResultAgent.release((Request)entry.getKey(), "stop_by_interceptor");
                }
            });
        }
    }

    @NonNull
    private Map<Request, RouterMeta> makeRequest() {
        HashMap<Request, RouterMeta> requestMap = new HashMap<Request, RouterMeta>();
        Parcelable parcelable = this.primaryRequest.getParcelable("DRouter_start_activity_via_intent");
        if (parcelable instanceof Intent) {
            this.primaryRequest.getExtra().remove("DRouter_start_activity_via_intent");
            Intent intent = (Intent)parcelable;
            RouterLogger.getCoreLogger().d("request %s, intent \"%s\"", this.primaryRequest.getNumber(), intent);
            PackageManager pm = this.primaryRequest.getContext().getPackageManager();
            List activities = pm.queryIntentActivities(intent, 65536);
            if (!activities.isEmpty()) {
                this.primaryRequest.routerType = 1;
                RouterLogger.getCoreLogger().d("request \"%s\" find target class \"%s\", type \"%s\"", this.primaryRequest.getNumber(), ((ResolveInfo)activities.get((int)0)).activityInfo.name, this.primaryRequest.routerType);
                requestMap.put(this.primaryRequest, RouterMeta.build(1).assembleRouter(intent));
            }
        } else {
            Set<RouterMeta> metas = this.getAllRouterMetas();
            int index = 0;
            for (RouterMeta routerMeta : metas) {
                Request request = RouterLoader.createBranchRequest(this.primaryRequest, metas.size() > 1, routerMeta.getRouterType(), index++);
                RouterLogger.getCoreLogger().d("request \"%s\" find target class \"%s\", type \"%s\", priority \"%s\"", request.getNumber(), routerMeta.getSimpleClassName(), routerMeta.getRouterType(), routerMeta.getPriority());
                requestMap.put(request, routerMeta);
            }
        }
        return requestMap;
    }

    @NonNull
    private Set<RouterMeta> getAllRouterMetas() {
        Set<RouterMeta> matchMetas = RouterStore.getRouterMetas(TextUtils.getUriKey(this.primaryRequest.getUri()));
        String schemeHost = this.primaryRequest.getString("DRouter_start_activity_with_default_scheme_host");
        if (!TextUtils.isEmpty(schemeHost) && this.primaryRequest.getUri().toString().startsWith(schemeHost.toLowerCase())) {
            Set<RouterMeta> degradeMetas = RouterStore.getRouterMetas(TextUtils.getUriKey(this.primaryRequest.getUri().getPath()));
            for (RouterMeta meta : degradeMetas) {
                if (meta.getRouterType() != 1) continue;
                matchMetas.add(meta);
            }
        }
        SparseArray sparseArray = new SparseArray();
        ArraySet output = new ArraySet();
        for (RouterMeta meta : matchMetas) {
            if (meta.getRouterType() == 1) {
                if (sparseArray.get(0) != null) {
                    RouterLogger.getCoreLogger().w("warning: request match more than one activity and this \"%s\" will be ignored", meta.getSimpleClassName());
                    continue;
                }
                sparseArray.put(0, (Object)meta);
                continue;
            }
            if (meta.getRouterType() == 2) {
                if (sparseArray.get(1) != null) {
                    RouterLogger.getCoreLogger().w("warning: request match more than one fragment and this \"%s\" will be ignored", meta.getSimpleClassName());
                    continue;
                }
                sparseArray.put(1, (Object)meta);
                continue;
            }
            if (meta.getRouterType() == 3) {
                if (sparseArray.get(2) != null) {
                    RouterLogger.getCoreLogger().w("warning: request match more than one view and this \"%s\" will be ignored", meta.getSimpleClassName());
                    continue;
                }
                sparseArray.put(2, (Object)meta);
                continue;
            }
            if (meta.getRouterType() != 4) continue;
            output.add(meta);
        }
        if (sparseArray.get(0) != null) {
            output.add(sparseArray.get(0));
        } else if (sparseArray.get(1) != null) {
            output.add(sparseArray.get(1));
        } else if (sparseArray.get(2) != null) {
            output.add(sparseArray.get(2));
        }
        return output;
    }

    private void startRemote() {
        Result result = new Result(this.primaryRequest, Collections.singleton(this.primaryRequest), this.callback);
        RemoteBridge.load(this.primaryRequest.authority, this.primaryRequest.resendStrategy, this.primaryRequest.lifecycleOwner != null ? new WeakReference<LifecycleOwner>(this.primaryRequest.lifecycleOwner) : null).start(this.primaryRequest, result, this.callback);
    }

    private static Request createBranchRequest(Request primaryRequest, boolean isBranch, int type, int branchIndex) {
        int n = primaryRequest.routerType = isBranch ? -1 : type;
        if (isBranch) {
            Request branchRequest = Request.build(primaryRequest.getUri().toString());
            branchRequest.extra = primaryRequest.extra;
            branchRequest.addition = primaryRequest.addition;
            branchRequest.context = primaryRequest.context;
            branchRequest.lifecycleOwner = primaryRequest.lifecycleOwner;
            branchRequest.authority = primaryRequest.authority;
            branchRequest.resendStrategy = primaryRequest.resendStrategy;
            branchRequest.holdTimeout = primaryRequest.holdTimeout;
            branchRequest.serialNumber = primaryRequest.getNumber() + "_" + branchIndex;
            branchRequest.routerType = type;
            return branchRequest;
        }
        return primaryRequest;
    }

    private static class RouterComparator
    implements Comparator<Map.Entry<Request, RouterMeta>> {
        private RouterComparator() {
        }

        @Override
        public int compare(Map.Entry<Request, RouterMeta> o1, Map.Entry<Request, RouterMeta> o2) {
            return o2.getValue().getPriority() - o1.getValue().getPriority();
        }
    }
}

