/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.remote;

import android.arch.lifecycle.LifecycleOwner;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.didi.drouter.remote.RemoteBridge;
import com.didi.drouter.remote.RemoteStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;

class RemoteCommand
implements Parcelable {
    static final int REQUEST = 0;
    static final int REQUEST_RESULT = 1;
    static final int SERVICE = 2;
    static final int SERVICE_CALLBACK = 3;
    private final int type;
    int resendStrategy;
    RemoteBridge bridge;
    WeakReference<LifecycleOwner> lifecycle;
    String uri;
    IBinder binder;
    boolean isActivityStarted;
    int routerSize;
    Bundle extra;
    Map<String, Object> addition;
    Class<?> serviceClass;
    String alias;
    Object feature;
    String methodName;
    @Nullable
    Object[] constructor;
    @Nullable
    Object[] parameters;
    Object[] callbackData;
    public static final Parcelable.Creator<RemoteCommand> CREATOR = new Parcelable.Creator<RemoteCommand>(){

        public RemoteCommand createFromParcel(Parcel in) {
            return new RemoteCommand(in);
        }

        public RemoteCommand[] newArray(int size) {
            return new RemoteCommand[size];
        }
    };

    RemoteCommand(int type) {
        this.type = type;
    }

    RemoteCommand(Parcel in) {
        this.type = in.readInt();
        if (this.type == 0) {
            this.uri = in.readString();
            this.binder = in.readStrongBinder();
            this.extra = in.readBundle(this.getClass().getClassLoader());
            this.addition = (Map)RemoteStream.reverse(in.readValue(this.getClass().getClassLoader()));
        }
        if (this.type == 1) {
            this.isActivityStarted = in.readInt() == 1;
            this.routerSize = in.readInt();
            this.extra = in.readBundle(this.getClass().getClassLoader());
            this.addition = (Map)RemoteStream.reverse(in.readValue(this.getClass().getClassLoader()));
        }
        if (this.type == 2) {
            this.serviceClass = (Class)in.readSerializable();
            this.alias = in.readString();
            this.feature = RemoteStream.reverse(in.readValue(this.getClass().getClassLoader()));
            this.methodName = in.readString();
            this.constructor = (Object[])RemoteStream.reverse(in.readValue(this.getClass().getClassLoader()));
            this.parameters = (Object[])RemoteStream.reverse(in.readValue(this.getClass().getClassLoader()));
        }
        if (this.type == 3) {
            this.callbackData = (Object[])RemoteStream.reverse(in.readValue(this.getClass().getClassLoader()));
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.type);
        if (this.type == 0) {
            dest.writeString(this.uri);
            dest.writeStrongBinder(this.binder);
            dest.writeBundle(this.extra);
            dest.writeValue(RemoteStream.transform(this.addition));
        }
        if (this.type == 1) {
            dest.writeInt(this.isActivityStarted ? 1 : 0);
            dest.writeInt(this.routerSize);
            dest.writeBundle(this.extra);
            dest.writeValue(RemoteStream.transform(this.addition));
        }
        if (this.type == 2) {
            dest.writeSerializable(this.serviceClass);
            dest.writeString(this.alias);
            dest.writeValue(RemoteStream.transform(this.feature));
            dest.writeString(this.methodName);
            dest.writeValue(RemoteStream.transform(this.constructor));
            dest.writeValue(RemoteStream.transform(this.parameters));
        }
        if (this.type == 3) {
            dest.writeValue(RemoteStream.transform(this.callbackData));
        }
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteCommand)) {
            return false;
        }
        RemoteCommand command = (RemoteCommand)o;
        return this.type == command.type && RemoteCommand.equals(this.uri, command.uri) && RemoteCommand.equals(this.serviceClass, command.serviceClass) && RemoteCommand.equals(this.alias, command.alias) && RemoteCommand.equals(this.feature, command.feature) && RemoteCommand.equals(this.methodName, command.methodName) && RemoteCommand.equals(this.bridge, command.bridge);
    }

    private static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.type, this.uri, this.serviceClass, this.alias, this.feature, this.methodName, this.bridge});
    }

    public String toString() {
        if (this.type == 0) {
            return "request uri: " + this.uri;
        }
        if (this.type == 1) {
            return "request result";
        }
        if (this.type == 2) {
            return "service:" + this.serviceClass.getSimpleName() + " methodName:" + this.methodName;
        }
        if (this.type == 3) {
            return "service_callback";
        }
        return super.toString();
    }
}

