/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.didi.drouter.utils.RouterLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ReflectUtil {
    public static Object getInstance(@NonNull Class<?> implClass, Object ... params) {
        try {
            if (params == null) {
                params = new Object[]{null};
            }
            RouterLogger.getCoreLogger().w("ReflectUtil create instance \"%s\" with params number %s by reflect", implClass.getSimpleName(), params.length);
            if (params.length == 0) {
                return implClass.newInstance();
            }
            Constructor<?>[] constructors = implClass.getConstructors();
            if (constructors != null) {
                for (Constructor<?> constructor : constructors) {
                    Class<?>[] classes = constructor.getParameterTypes();
                    if (!ReflectUtil.isParameterTypeMatch(classes, params)) continue;
                    return constructor.newInstance(params);
                }
            }
            RouterLogger.getCoreLogger().e("ReflectUtil \"%s\" getInstance no match and return \"null\"", implClass);
        }
        catch (Exception e) {
            RouterLogger.getCoreLogger().e("ReflectUtil \"%s\" getInstance Exception: %s", implClass, e);
        }
        return null;
    }

    public static Object invokeMethod(Object instance, String methodName, @Nullable Object[] params) throws Exception {
        Method[] methods;
        RouterLogger.getCoreLogger().w("ReflectUtil invoke method \"%s\" by reflect", methodName);
        if (params == null || params.length == 0) {
            Method method = instance.getClass().getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method.invoke(instance, new Object[0]);
        }
        for (Method method : methods = instance.getClass().getDeclaredMethods()) {
            Class<?>[] classes;
            if (!method.getName().equals(methodName) || !ReflectUtil.isParameterTypeMatch(classes = method.getParameterTypes(), params)) continue;
            method.setAccessible(true);
            return method.invoke(instance, params);
        }
        throw new Exception("ReflectUtil invokeMethod no match");
    }

    private static boolean isParameterTypeMatch(@NonNull Class<?>[] target, @NonNull Object[] params) {
        if (target.length != params.length) {
            return false;
        }
        for (int i = 0; i < target.length; ++i) {
            boolean typeMatch;
            Class<?> client;
            Class<?> host = target[i];
            Class<?> clazz = client = params[i] != null ? params[i].getClass() : null;
            if (client == null) {
                typeMatch = !host.isPrimitive();
            } else {
                boolean bl = typeMatch = host == client || host.isAssignableFrom(client) || ReflectUtil.transform(host) == ReflectUtil.transform(client);
            }
            if (typeMatch) continue;
            return false;
        }
        return true;
    }

    private static Class<?> transform(Class<?> clz) {
        if (clz == Byte.class) {
            clz = Byte.TYPE;
        } else if (clz == Short.class) {
            clz = Short.TYPE;
        } else if (clz == Integer.class) {
            clz = Integer.TYPE;
        } else if (clz == Long.class) {
            clz = Long.TYPE;
        } else if (clz == Float.class) {
            clz = Float.TYPE;
        } else if (clz == Double.class) {
            clz = Double.TYPE;
        } else if (clz == Character.class) {
            clz = Character.TYPE;
        } else if (clz == Boolean.class) {
            clz = Boolean.TYPE;
        }
        return clz;
    }
}

