/*
 * Decompiled with CFR 0.152.
 */
package com.didi.drouter.remote;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.didi.drouter.remote.IHostService;
import com.didi.drouter.remote.RemoteCommand;
import com.didi.drouter.remote.RemoteDispatcher;
import com.didi.drouter.remote.RemoteResult;
import com.didi.drouter.utils.RouterLogger;
import com.didi.drouter.utils.SystemUtil;

public class RemoteProvider
extends ContentProvider {
    static final String FIELD_REMOTE_BINDER = "field_remote_binder";
    static final String FIELD_REMOTE_PROCESS = "field_remote_process";
    static final String FIELD_REMOTE_LAUNCH_ACTION = "field_remote_launch_action";
    static final String BROADCAST_ACTION = "drouter.process.action.";
    private static boolean hasSendBroadcast;
    private static final IHostService.Stub stub;

    public boolean onCreate() {
        String process = SystemUtil.getProcessName();
        if (this.getContext() instanceof Application) {
            SystemUtil.setApplication((Application)this.getContext());
            RouterLogger.getCoreLogger().d("[%s] onCreate | Context: %s | Process: \"%s\"", ((Object)((Object)this)).getClass().getSimpleName(), this.getContext(), process);
            if (!hasSendBroadcast) {
                Intent intent = new Intent(BROADCAST_ACTION + process);
                intent.putExtra(FIELD_REMOTE_LAUNCH_ACTION, process);
                this.getContext().sendBroadcast(intent);
                hasSendBroadcast = true;
            }
        } else {
            Log.e((String)"DRouterCore", (String)String.format("[%s] onCreate | Context: %s | Process: \"%s\"", ((Object)((Object)this)).getClass().getSimpleName(), this.getContext(), process));
        }
        return true;
    }

    @TargetApi(value=11)
    public Bundle call(@NonNull String method, @Nullable String arg, @Nullable Bundle extras) {
        RouterLogger.getCoreLogger().d("[%s] is called by client to get binder, process: \"%s\"", ((Object)((Object)this)).getClass().getSimpleName(), SystemUtil.getProcessName());
        Bundle bundle = new Bundle();
        bundle.putParcelable(FIELD_REMOTE_BINDER, (Parcelable)new BinderParcel((IBinder)stub));
        bundle.putString(FIELD_REMOTE_PROCESS, SystemUtil.getProcessName());
        return bundle;
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    static {
        stub = new IHostService.Stub(){

            @Override
            public RemoteResult execute(RemoteCommand command) {
                try {
                    return new RemoteDispatcher().execute(command);
                }
                catch (RuntimeException e) {
                    RouterLogger.getCoreLogger().e("[Service] exception: %s", e);
                    throw e;
                }
            }
        };
    }

    static class BinderParcel
    implements Parcelable {
        private final IBinder mBinder;
        public static final Parcelable.Creator<BinderParcel> CREATOR = new Parcelable.Creator<BinderParcel>(){

            public BinderParcel createFromParcel(Parcel in) {
                return new BinderParcel(in);
            }

            public BinderParcel[] newArray(int size) {
                return new BinderParcel[size];
            }
        };

        BinderParcel(Parcel in) {
            this.mBinder = in.readStrongBinder();
        }

        BinderParcel(IBinder binder) {
            this.mBinder = binder;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeStrongBinder(this.mBinder);
        }

        IBinder getBinder() {
            return this.mBinder;
        }
    }
}

