/*
 * Decompiled with CFR 0.152.
 */
package com.didi.aoe.runtime.tensorflow.lite;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.didi.aoe.library.api.AoeModelOption;
import com.didi.aoe.library.api.AoeProcessor;
import com.didi.aoe.library.api.SingleInterpreterComponent;
import com.didi.aoe.library.logging.Logger;
import com.didi.aoe.library.logging.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.tensorflow.lite.Interpreter;
import org.tensorflow.lite.Tensor;

public abstract class TensorFlowLiteMultipleInputsOutputsInterpreter<TInput, TOutput, TModelInput, TModelOutput>
extends SingleInterpreterComponent<TInput, TOutput>
implements AoeProcessor.MultiConvertor<TInput, TOutput, Object, TModelOutput> {
    private final Logger mLogger = LoggerFactory.getLogger((String)"TensorFlowLite.Interpreter");
    private Interpreter mInterpreter;
    private Map<Integer, Object> outputPlaceholder;

    public void init(@NonNull Context context, @NonNull AoeModelOption modelOptions, @Nullable AoeProcessor.OnInitListener listener) {
        String modelFilePath = modelOptions.getModelDir() + File.separator + modelOptions.getModelName() + ".tflite";
        ByteBuffer bb = this.loadFromAssets(context, modelFilePath);
        if (bb != null) {
            this.mInterpreter = new Interpreter(bb);
            this.outputPlaceholder = this.generalOutputPlaceholder(this.mInterpreter);
            if (listener != null) {
                listener.onInitResult(AoeProcessor.InitResult.create((int)0));
            }
            return;
        }
        if (listener != null) {
            listener.onInitResult(AoeProcessor.InitResult.create((int)-2));
        }
    }

    private Map<Integer, Object> generalOutputPlaceholder(@NonNull Interpreter interpreter) {
        HashMap<Integer, Object> out = new HashMap<Integer, Object>(interpreter.getOutputTensorCount());
        for (int i = 0; i < interpreter.getOutputTensorCount(); ++i) {
            Tensor tensor = interpreter.getOutputTensor(i);
            Object data = null;
            switch (tensor.dataType()) {
                case FLOAT32: {
                    data = Array.newInstance(Float.TYPE, tensor.shape());
                    break;
                }
                case INT32: {
                    data = Array.newInstance(Integer.TYPE, tensor.shape());
                    break;
                }
                case UINT8: {
                    data = Array.newInstance(Byte.TYPE, tensor.shape());
                    break;
                }
                case INT64: {
                    data = Array.newInstance(Long.TYPE, tensor.shape());
                    break;
                }
                case STRING: {
                    data = Array.newInstance(String.class, tensor.shape());
                    break;
                }
            }
            out.put(i, data);
        }
        return out;
    }

    @Nullable
    public TOutput run(@NonNull TInput input) {
        Object[] modelInput;
        if (this.isReady() && (modelInput = this.preProcessMulti(input)) != null) {
            this.mInterpreter.runForMultipleInputsOutputs(modelInput, this.outputPlaceholder);
            return (TOutput)this.postProcessMulti(this.outputPlaceholder);
        }
        return null;
    }

    public void release() {
        this.mInterpreter.close();
    }

    public boolean isReady() {
        return this.mInterpreter != null && this.outputPlaceholder != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer loadFromAssets(Context context, String modelFilePath) {
        block16: {
            ByteBuffer byteBuffer;
            InputStream is = null;
            try {
                is = context.getAssets().open(modelFilePath);
                byte[] bytes = this.read(is);
                if (bytes == null) {
                    ByteBuffer byteBuffer2 = null;
                    return byteBuffer2;
                }
                ByteBuffer bf = ByteBuffer.allocateDirect(bytes.length);
                bf.order(ByteOrder.nativeOrder());
                bf.put(bytes);
                byteBuffer = bf;
            }
            catch (IOException e) {
                this.mLogger.error("loadFromAssets error", (Throwable)e);
                break block16;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return byteBuffer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] read(InputStream is) {
        BufferedInputStream bis = null;
        ByteArrayOutputStream baos = null;
        try {
            int len;
            bis = new BufferedInputStream(is);
            baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = bis.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            this.mLogger.error("read InputStream error: ", (Throwable)e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new byte[0];
    }
}

