/*
 * Decompiled with CFR 0.152.
 */
package com.didi.aoe.library.api.interpreter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.didi.aoe.library.api.AoeModelOption;
import com.didi.aoe.library.api.AoeProcessor;
import com.didi.aoe.library.api.interpreter.InterpreterInitResult;
import com.didi.aoe.library.api.interpreter.OnInterpreterInitListener;
import com.didi.aoe.library.api.interpreter.SingleInterpreterComponent;
import com.didi.aoe.library.lang.AoeRuntimeException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MultiInterpreterComponent<TInput, TOutput>
implements AoeProcessor.InterpreterComponent<TInput, TOutput> {
    private List<SingleInterpreterComponent> mSubInterpreters;

    @NonNull
    public abstract List<SingleInterpreterComponent> provideSubInterpreters();

    @Override
    public final void init(@NonNull Context context, @Nullable AoeProcessor.InterpreterComponent.Options interpreterOptions, @NonNull List<AoeModelOption> modelOptions, @Nullable OnInterpreterInitListener listener) {
        this.mSubInterpreters = this.provideSubInterpreters();
        if (this.mSubInterpreters.size() != modelOptions.size()) {
            throw new AoeRuntimeException("Size of model options no match with interpreters");
        }
        final CountDownLatch latch = new CountDownLatch(this.mSubInterpreters.size());
        final AtomicInteger statusCode = new AtomicInteger(0);
        for (SingleInterpreterComponent interpreter : this.mSubInterpreters) {
            interpreter.init(context, interpreterOptions, modelOptions, new OnInterpreterInitListener(){

                @Override
                public void onInitResult(@NonNull InterpreterInitResult result) {
                    if (0 != result.getCode()) {
                        statusCode.set(result.getCode());
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (listener != null) {
            listener.onInitResult(InterpreterInitResult.create(statusCode.get()));
        }
    }

    @Override
    @Nullable
    public TOutput run(@NonNull TInput tInput) {
        TInput input = tInput;
        TOutput result = null;
        for (SingleInterpreterComponent interpreter : this.mSubInterpreters) {
            result = interpreter.run(input);
            input = result;
        }
        return result;
    }

    @Override
    public void release() {
        for (SingleInterpreterComponent interpreter : this.mSubInterpreters) {
            interpreter.release();
        }
    }

    @Override
    public boolean isReady() {
        SingleInterpreterComponent interpreter;
        boolean resultOk = true;
        Iterator<SingleInterpreterComponent> iterator = this.mSubInterpreters.iterator();
        while (iterator.hasNext() && (resultOk = (interpreter = iterator.next()).isReady())) {
        }
        return resultOk;
    }
}

