/*
 * Decompiled with CFR 0.152.
 */
package com.dhh.websocket;

import android.annotation.SuppressLint;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import com.dhh.websocket.WebSocketSubscriber;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class WebSocketSubscriber2<T>
extends WebSocketSubscriber {
    private static final Gson GSON = new Gson();
    protected Type type;

    public WebSocketSubscriber2() {
        this.analysisType();
    }

    private void analysisType() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("No generics found!");
        }
        ParameterizedType type = (ParameterizedType)superclass;
        this.type = type.getActualTypeArguments()[0];
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    @CallSuper
    protected void onMessage(@NonNull String text) {
        Observable.just((Object)text).map(new Function<String, T>(){

            public T apply(String s) throws Exception {
                try {
                    return GSON.fromJson(s, WebSocketSubscriber2.this.type);
                }
                catch (JsonSyntaxException e) {
                    return GSON.fromJson((String)GSON.fromJson(s, String.class), WebSocketSubscriber2.this.type);
                }
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Consumer<T>(){

            public void accept(T t) throws Exception {
                WebSocketSubscriber2.this.onMessage(t);
            }
        });
    }

    protected abstract void onMessage(T var1);
}

