/*
 * Decompiled with CFR 0.152.
 */
package com.dhh.websocket;

import com.dhh.websocket.WebSocketInfo;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import okhttp3.WebSocket;
import okio.ByteString;

public abstract class WebSocketSubscriber
implements Observer<WebSocketInfo> {
    private boolean hasOpened;
    protected Disposable disposable;

    public final void onNext(@NonNull WebSocketInfo webSocketInfo) {
        if (webSocketInfo.isOnOpen()) {
            this.hasOpened = true;
            this.onOpen(webSocketInfo.getWebSocket());
        } else if (webSocketInfo.getString() != null) {
            this.onMessage(webSocketInfo.getString());
        } else if (webSocketInfo.getByteString() != null) {
            this.onMessage(webSocketInfo.getByteString());
        } else if (webSocketInfo.isOnReconnect()) {
            this.onReconnect();
        }
    }

    protected void onOpen(@NonNull WebSocket webSocket) {
    }

    protected void onMessage(@NonNull String text) {
    }

    protected void onMessage(@NonNull ByteString byteString) {
    }

    protected void onReconnect() {
    }

    protected void onClose() {
    }

    public final void onSubscribe(Disposable disposable) {
        this.disposable = disposable;
    }

    public final void dispose() {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }

    public final void onComplete() {
        if (this.hasOpened) {
            this.onClose();
        }
    }

    public void onError(Throwable e) {
        e.printStackTrace();
    }
}

