/*
 * Decompiled with CFR 0.152.
 */
package com.dhh.websocket;

import com.dhh.websocket.Config;
import com.dhh.websocket.RxWebSocketUtil;
import com.dhh.websocket.WebSocketInfo;
import io.reactivex.Observable;
import java.util.concurrent.TimeUnit;
import okio.ByteString;

public final class RxWebSocket {
    public static void setConfig(Config config) {
        RxWebSocketUtil instance = RxWebSocketUtil.getInstance();
        instance.setShowLog(config.showLog, config.logTag);
        instance.setClient(config.client);
        instance.setReconnectInterval(config.reconnectInterval, config.reconnectIntervalTimeUnit);
        if (config.sslSocketFactory != null && config.trustManager != null) {
            instance.setSSLSocketFactory(config.sslSocketFactory, config.trustManager);
        }
    }

    public static Observable<WebSocketInfo> get(String url) {
        return RxWebSocketUtil.getInstance().getWebSocketInfo(url);
    }

    public static Observable<WebSocketInfo> get(String url, long timeout, TimeUnit timeUnit) {
        return RxWebSocketUtil.getInstance().getWebSocketInfo(url, timeout, timeUnit);
    }

    public static void send(String url, String msg) {
        RxWebSocketUtil.getInstance().send(url, msg);
    }

    public static void send(String url, ByteString byteString) {
        RxWebSocketUtil.getInstance().send(url, byteString);
    }

    public static void asyncSend(String url, String msg) {
        RxWebSocketUtil.getInstance().asyncSend(url, msg);
    }

    public static void asyncSend(String url, ByteString byteString) {
        RxWebSocketUtil.getInstance().asyncSend(url, byteString);
    }
}

