/*
 * Decompiled with CFR 0.152.
 */
package com.dhh.websocket;

import android.support.annotation.CallSuper;
import com.dhh.websocket.WebSocketInfo;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import okhttp3.WebSocket;
import okio.ByteString;

public abstract class WebSocketSubscriber
implements Observer<WebSocketInfo> {
    @CallSuper
    public void onNext(@NonNull WebSocketInfo webSocketInfo) {
        if (webSocketInfo.isOnOpen()) {
            this.onOpen(webSocketInfo.getWebSocket());
        } else if (webSocketInfo.getString() != null) {
            this.onMessage(webSocketInfo.getString());
        } else if (webSocketInfo.getByteString() != null) {
            this.onMessage(webSocketInfo.getByteString());
        }
    }

    public abstract void onOpen(@NonNull WebSocket var1);

    public abstract void onMessage(@NonNull String var1);

    public abstract void onMessage(@NonNull ByteString var1);

    public void onError(@NonNull Throwable e) {
    }

    public void onComplete() {
    }
}

