/*
 * Decompiled with CFR 0.152.
 */
package com.dhh.websocket;

import android.os.SystemClock;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.dhh.websocket.WebSocketInfo;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Action;
import io.reactivex.functions.Cancellable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class RxWebSocketUtil {
    private static RxWebSocketUtil instance;
    private OkHttpClient client;
    private Map<String, Observable<WebSocketInfo>> observableMap;
    private Map<String, WebSocket> webSocketMap;
    private boolean showLog;

    private RxWebSocketUtil() {
        try {
            Class.forName("okhttp3.OkHttpClient");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Must be dependency okhttp3 !");
        }
        try {
            Class.forName("io.reactivex.Observable");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Must be dependency rxjava 2.x");
        }
        try {
            Class.forName("io.reactivex.android.schedulers.AndroidSchedulers");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Must be dependency rxandroid 2.x");
        }
        this.observableMap = new ArrayMap();
        this.webSocketMap = new ArrayMap();
        this.client = new OkHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RxWebSocketUtil getInstance() {
        if (instance != null) return instance;
        Class<RxWebSocketUtil> clazz = RxWebSocketUtil.class;
        synchronized (RxWebSocketUtil.class) {
            if (instance != null) return instance;
            instance = new RxWebSocketUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setClient(OkHttpClient client) {
        if (client == null) {
            throw new NullPointerException(" Are you kidding me ? client == null");
        }
        this.client = client;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        this.client = this.client.newBuilder().sslSocketFactory(sslSocketFactory, trustManager).build();
    }

    public void setShowLog(boolean showLog) {
        this.showLog = showLog;
    }

    public Observable<WebSocketInfo> getWebSocketInfo(final String url, long timeout, TimeUnit timeUnit) {
        Observable observable = this.observableMap.get(url);
        if (observable == null) {
            observable = Observable.create((ObservableOnSubscribe)new WebSocketOnSubscribe(url)).timeout(timeout, timeUnit).retry().doOnDispose(new Action(){

                public void run() throws Exception {
                    RxWebSocketUtil.this.observableMap.remove(url);
                    RxWebSocketUtil.this.webSocketMap.remove(url);
                    if (RxWebSocketUtil.this.showLog) {
                        Log.d((String)"RxWebSocketUtil", (String)"\u6ce8\u9500");
                    }
                }
            }).doOnNext((Consumer)new Consumer<WebSocketInfo>(){

                public void accept(WebSocketInfo webSocketInfo) throws Exception {
                    if (webSocketInfo.isOnOpen()) {
                        RxWebSocketUtil.this.webSocketMap.put(url, webSocketInfo.getWebSocket());
                    }
                }
            }).share().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
            this.observableMap.put(url, (Observable<WebSocketInfo>)observable);
        } else {
            observable = Observable.merge((ObservableSource)Observable.just((Object)new WebSocketInfo(this.webSocketMap.get(url), true)), observable);
        }
        return observable;
    }

    public Observable<WebSocketInfo> getWebSocketInfo(String url) {
        return this.getWebSocketInfo(url, 30L, TimeUnit.DAYS);
    }

    public Observable<String> getWebSocketString(String url) {
        return this.getWebSocketInfo(url).filter((Predicate)new Predicate<WebSocketInfo>(){

            public boolean test(@NonNull WebSocketInfo webSocketInfo) throws Exception {
                return webSocketInfo.getString() != null;
            }
        }).map((Function)new Function<WebSocketInfo, String>(){

            public String apply(@NonNull WebSocketInfo webSocketInfo) throws Exception {
                return webSocketInfo.getString();
            }
        });
    }

    public Observable<ByteString> getWebSocketByteString(String url) {
        return this.getWebSocketInfo(url).filter((Predicate)new Predicate<WebSocketInfo>(){

            public boolean test(@NonNull WebSocketInfo webSocketInfo) throws Exception {
                return webSocketInfo.getByteString() != null;
            }
        }).map((Function)new Function<WebSocketInfo, ByteString>(){

            public ByteString apply(WebSocketInfo webSocketInfo) throws Exception {
                return webSocketInfo.getByteString();
            }
        });
    }

    public Observable<WebSocket> getWebSocket(String url) {
        return this.getWebSocketInfo(url).map((Function)new Function<WebSocketInfo, WebSocket>(){

            public WebSocket apply(@NonNull WebSocketInfo webSocketInfo) throws Exception {
                return webSocketInfo.getWebSocket();
            }
        });
    }

    public void send(String url, String msg) {
        WebSocket webSocket = this.webSocketMap.get(url);
        if (webSocket == null) {
            throw new IllegalStateException("The WebSokcet not open");
        }
        webSocket.send(msg);
    }

    public void send(String url, ByteString byteString) {
        WebSocket webSocket = this.webSocketMap.get(url);
        if (webSocket == null) {
            throw new IllegalStateException("The WebSokcet not open");
        }
        webSocket.send(byteString);
    }

    public void asyncSend(String url, final String msg) {
        this.getWebSocket(url).take(1L).subscribe((Consumer)new Consumer<WebSocket>(){

            public void accept(WebSocket webSocket) throws Exception {
                webSocket.send(msg);
            }
        });
    }

    public void asyncSend(String url, final ByteString byteString) {
        this.getWebSocket(url).take(1L).subscribe((Consumer)new Consumer<WebSocket>(){

            public void accept(WebSocket webSocket) throws Exception {
                webSocket.send(byteString);
            }
        });
    }

    private Request getRequest(String url) {
        return new Request.Builder().get().url(url).build();
    }

    private final class WebSocketOnSubscribe
    implements ObservableOnSubscribe<WebSocketInfo> {
        private String url;
        private WebSocket webSocket;

        public WebSocketOnSubscribe(String url) {
            this.url = url;
        }

        public void subscribe(@NonNull ObservableEmitter<WebSocketInfo> e) throws Exception {
            if (this.webSocket != null && !"main".equals(Thread.currentThread().getName())) {
                SystemClock.sleep((long)2000L);
            }
            this.initWebSocket(e);
        }

        private void initWebSocket(final ObservableEmitter<WebSocketInfo> emitter) {
            this.webSocket = RxWebSocketUtil.this.client.newWebSocket(RxWebSocketUtil.this.getRequest(this.url), new WebSocketListener(){

                public void onOpen(WebSocket webSocket, Response response) {
                    if (RxWebSocketUtil.this.showLog) {
                        Log.d((String)"RxWebSocketUtil", (String)(WebSocketOnSubscribe.this.url + " --> onOpen"));
                    }
                    RxWebSocketUtil.this.webSocketMap.put(WebSocketOnSubscribe.this.url, webSocket);
                    if (!emitter.isDisposed()) {
                        emitter.onNext((Object)new WebSocketInfo(webSocket, true));
                    }
                }

                public void onMessage(WebSocket webSocket, String text) {
                    if (!emitter.isDisposed()) {
                        emitter.onNext((Object)new WebSocketInfo(webSocket, text));
                    }
                }

                public void onMessage(WebSocket webSocket, ByteString bytes) {
                    if (!emitter.isDisposed()) {
                        emitter.onNext((Object)new WebSocketInfo(webSocket, bytes));
                    }
                }

                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    if (RxWebSocketUtil.this.showLog) {
                        Log.e((String)"RxWebSocketUtil", (String)(t.toString() + webSocket.request().url().uri().getPath()));
                    }
                    if (!emitter.isDisposed()) {
                        emitter.onError(t);
                    }
                }

                public void onClosing(WebSocket webSocket, int code, String reason) {
                    webSocket.close(1000, null);
                }

                public void onClosed(WebSocket webSocket, int code, String reason) {
                    if (RxWebSocketUtil.this.showLog) {
                        Log.d((String)"RxWebSocketUtil", (String)(WebSocketOnSubscribe.this.url + " --> onClosed:code= " + code));
                    }
                }
            });
            emitter.setCancellable(new Cancellable(){

                public void cancel() throws Exception {
                    WebSocketOnSubscribe.this.webSocket.close(3000, "\u624b\u52a8\u5173\u95ed");
                }
            });
        }
    }
}

