/*
 * Decompiled with CFR 0.152.
 */
package com.dhh.websocket;

import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;

public final class Config {
    protected long reconnectInterval = 1L;
    protected TimeUnit reconnectIntervalTimeUnit = TimeUnit.SECONDS;
    protected boolean showLog = false;
    protected String logTag = "RxWebSocket";
    protected OkHttpClient client = new OkHttpClient();
    protected SSLSocketFactory sslSocketFactory;
    protected X509TrustManager trustManager;

    private Config() {
    }

    public static final class Builder {
        private Config config = new Config();

        public Builder setClient(OkHttpClient client) {
            this.config.client = client;
            return this;
        }

        public Builder setSSLSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
            this.config.sslSocketFactory = sslSocketFactory;
            this.config.trustManager = trustManager;
            return this;
        }

        public Builder setReconnectInterval(long Interval, TimeUnit timeUnit) {
            this.config.reconnectInterval = Interval;
            this.config.reconnectIntervalTimeUnit = timeUnit;
            return this;
        }

        public Builder setShowLog(boolean showLog) {
            this.config.showLog = showLog;
            return this;
        }

        public Builder setShowLog(boolean showLog, String logTag) {
            this.config.showLog = showLog;
            this.config.logTag = logTag;
            return this;
        }

        public Config build() {
            return this.config;
        }
    }
}

