/*
 * Decompiled with CFR 0.152.
 */
package com.dhh.websocket;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import com.dhh.websocket.WebSocketInfo;
import okhttp3.WebSocket;
import okio.ByteString;
import rx.Subscriber;

public abstract class WebSocketSubscriber
extends Subscriber<WebSocketInfo> {
    @CallSuper
    public void onNext(@NonNull WebSocketInfo webSocketInfo) {
        if (webSocketInfo.isOnOpen()) {
            this.onOpen(webSocketInfo.getWebSocket());
        } else if (webSocketInfo.getString() != null) {
            this.onMessage(webSocketInfo.getString());
        } else if (webSocketInfo.getByteString() != null) {
            this.onMessage(webSocketInfo.getByteString());
        }
    }

    public abstract void onOpen(@NonNull WebSocket var1);

    public abstract void onMessage(@NonNull String var1);

    public abstract void onMessage(@NonNull ByteString var1);

    public void onCompleted() {
    }

    public void onError(Throwable e) {
        e.printStackTrace();
    }
}

