/*
 * Decompiled with CFR 0.152.
 */
package com.dewarder.holdinglibrary;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.animation.AccelerateInterpolator;
import com.dewarder.holdinglibrary.ColorUtils;
import com.dewarder.holdinglibrary.HoldingDrawableListener;

public class HoldingDrawable
extends Drawable {
    private static final float MIN_EXPANDED_RADIUS_MULTIPLIER = 0.3f;
    private static final long DEFAULT_ANIMATION_DURATION_EXPAND = 150L;
    private static final long DEFAULT_ANIMATION_DURATION_COLLAPSE = 150L;
    private static final long DEFAULT_ANIMATION_DURATION_CANCEL = 200L;
    private static final long DEFAULT_ANIMATION_DURATION_ICON = 200L;
    private Paint mPaint;
    private Paint mSecondPaint;
    private int mIconWidth;
    private int mIconHeight;
    private Matrix mIconMatrix = new Matrix();
    private BitmapShader mIconShader;
    private Paint mIconPaint;
    private int mCancelIconWidth;
    private int mCancelIconHeight;
    private Matrix mCancelIconMatrix = new Matrix();
    private BitmapShader mCancelIconShader;
    private Paint mCancelIconPaint;
    private boolean mIsExpanded = false;
    private boolean mIsCancel = false;
    private ValueAnimator mAnimator;
    private ValueAnimator mCancelAnimator;
    private ValueAnimator mIconAnimator;
    private float mRadius = 120.0f;
    private float mSecondRadius = 20.0f;
    private float[] mIconScaleFactor = new float[]{1.0f};
    private float[] mExpandedScaleFactor = new float[]{0.0f};
    private int mDefaultColor = Color.parseColor((String)"#3949AB");
    private int mCancelColor = Color.parseColor((String)"#e53935");
    private int mSecondAlpha = 100;
    private HoldingDrawableListener mListener;

    public HoldingDrawable() {
        this.mPaint = new Paint(1);
        this.mPaint.setColor(this.mDefaultColor);
        this.mSecondPaint = new Paint(1);
        this.mSecondPaint.setColor(this.mDefaultColor);
        this.mSecondPaint.setAlpha(this.mSecondAlpha);
    }

    public void draw(@NonNull Canvas canvas) {
        float centerX = (float)canvas.getWidth() / 2.0f;
        float centerY = (float)canvas.getHeight() / 2.0f;
        if (this.mIsExpanded) {
            if (this.mSecondRadius > 0.0f) {
                canvas.drawCircle(centerX, centerY, this.mRadius + this.mSecondRadius, this.mSecondPaint);
            }
            float currentRadius = this.mRadius * (0.3f + 0.7f * this.mExpandedScaleFactor[0]);
            canvas.drawCircle(centerX, centerY, currentRadius, this.mPaint);
            if (this.mIconPaint != null) {
                Paint iconPaint;
                if (this.mIsCancel && this.mCancelIconPaint != null) {
                    iconPaint = this.mCancelIconPaint;
                    this.invalidateMatrix(this.mCancelIconMatrix, centerX, centerY, this.mCancelIconWidth, this.mCancelIconHeight);
                    this.mCancelIconShader.setLocalMatrix(this.mCancelIconMatrix);
                } else {
                    iconPaint = this.mIconPaint;
                    this.invalidateMatrix(this.mIconMatrix, centerX, centerY, this.mIconWidth, this.mIconHeight);
                    this.mIconShader.setLocalMatrix(this.mIconMatrix);
                }
                canvas.drawRect(centerX - (float)(this.mIconWidth / 2), centerY - (float)(this.mIconHeight / 2), centerX + (float)(this.mIconWidth / 2), centerY + (float)(this.mIconHeight / 2), iconPaint);
            }
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.mPaint.setAlpha(alpha);
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -1;
    }

    public int getIntrinsicHeight() {
        return (int)(this.mRadius * 2.0f + this.mSecondRadius * 2.0f);
    }

    public int getIntrinsicWidth() {
        return (int)(this.mRadius * 2.0f + this.mSecondRadius * 2.0f);
    }

    public void expand() {
        this.notifyOnBeforeExpand();
        this.mIsExpanded = true;
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
        }
        this.mAnimator = this.createExpandValueAnimator();
        this.mAnimator.start();
    }

    public void collapse() {
        this.notifyOnBeforeCollapse();
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
        }
        this.mAnimator = this.createCollapseValueAnimator();
        this.mAnimator.start();
    }

    public void reset() {
        this.mIsExpanded = false;
        this.mIsCancel = false;
        this.mPaint.setColor(this.mDefaultColor);
        this.mSecondPaint.setColor(this.mDefaultColor);
        this.mSecondPaint.setAlpha(this.mSecondAlpha);
    }

    public void setCancel(boolean isCancel) {
        if (this.mIsCancel != isCancel) {
            this.mIsCancel = isCancel;
            if (this.mCancelAnimator != null) {
                this.mCancelAnimator.cancel();
            }
            this.mCancelAnimator = this.createCancelValueAnimator();
            this.mCancelAnimator.start();
            if (this.mIconAnimator != null) {
                this.mIconAnimator.cancel();
            }
            this.mIconAnimator = this.createIconValueAnimator();
            this.mIconAnimator.start();
        }
    }

    public void setRadius(float radius) {
        this.mRadius = radius;
        this.invalidateSelf();
    }

    public float getRadius() {
        return this.mRadius;
    }

    @ColorInt
    public int getColor() {
        return this.mDefaultColor;
    }

    public void setColor(@ColorInt int color) {
        this.mDefaultColor = color;
        if (!this.mIsCancel) {
            this.mPaint.setColor(color);
            this.mSecondPaint.setColor(color);
            this.mSecondPaint.setAlpha(this.mSecondAlpha);
        }
        this.invalidateSelf();
    }

    @ColorInt
    public int getCancelColor() {
        return this.mCancelColor;
    }

    public void setCancelColor(int color) {
        this.mCancelColor = color;
        if (this.mIsCancel) {
            this.mPaint.setColor(color);
        }
        this.invalidateSelf();
    }

    public void setIcon(Bitmap bitmap) {
        if (bitmap != null) {
            this.mIconWidth = bitmap.getWidth();
            this.mIconHeight = bitmap.getHeight();
            this.mIconShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mIconShader.setLocalMatrix(this.mIconMatrix);
            this.mIconPaint = new Paint(1);
            this.mIconPaint.setShader((Shader)this.mIconShader);
            this.mIconPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(-1, PorterDuff.Mode.SRC_IN));
            this.invalidateSelf();
        } else {
            this.mIconWidth = 0;
            this.mIconHeight = 0;
            this.mIconShader = null;
            this.mIconMatrix = null;
            this.mIconPaint = null;
        }
    }

    public void setCancelIcon(Bitmap bitmap) {
        if (bitmap != null) {
            this.mCancelIconWidth = bitmap.getWidth();
            this.mCancelIconHeight = bitmap.getHeight();
            this.mCancelIconShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mCancelIconShader.setLocalMatrix(this.mCancelIconMatrix);
            this.mCancelIconPaint = new Paint(1);
            this.mCancelIconPaint.setShader((Shader)this.mCancelIconShader);
            this.mCancelIconPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(-1, PorterDuff.Mode.SRC_IN));
            this.invalidateSelf();
        } else {
            this.mCancelIconWidth = 0;
            this.mCancelIconHeight = 0;
            this.mCancelIconMatrix = null;
            this.mCancelIconPaint = null;
        }
    }

    @IntRange(from=0L, to=255L)
    public int getSecondAlpha() {
        return this.mSecondAlpha;
    }

    public void setSecondAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.mSecondAlpha = alpha;
        this.invalidateSelf();
    }

    public float getSecondRadius() {
        return this.mSecondRadius;
    }

    public void setSecondRadius(float radius) {
        this.mSecondRadius = radius;
        this.invalidateSelf();
    }

    public void setListener(HoldingDrawableListener listener) {
        this.mListener = listener;
    }

    private void invalidateMatrix(Matrix matrix, float centerX, float centerY, float width, float height) {
        matrix.reset();
        matrix.setScale(this.mIconScaleFactor[0], this.mIconScaleFactor[0]);
        float inverseScaleFactor = 1.0f - this.mIconScaleFactor[0];
        matrix.postTranslate(centerX - width / 2.0f + width / 2.0f * inverseScaleFactor, centerY - height / 2.0f + height / 2.0f * inverseScaleFactor);
    }

    private ValueAnimator createExpandValueAnimator() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setDuration(150L);
        animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ((HoldingDrawable)HoldingDrawable.this).mExpandedScaleFactor[0] = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                HoldingDrawable.this.invalidateSelf();
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                HoldingDrawable.this.notifyExpanded();
            }
        });
        return animator;
    }

    private ValueAnimator createCollapseValueAnimator() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        animator.setDuration(150L);
        animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ((HoldingDrawable)HoldingDrawable.this).mExpandedScaleFactor[0] = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                HoldingDrawable.this.invalidateSelf();
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                HoldingDrawable.this.notifyCollapsed();
            }
        });
        return animator;
    }

    private ValueAnimator createCancelValueAnimator() {
        final int from = this.mIsCancel ? this.mDefaultColor : this.mCancelColor;
        final int to = this.mIsCancel ? this.mCancelColor : this.mDefaultColor;
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator a) {
                int color = ColorUtils.blend(from, to, ((Float)a.getAnimatedValue()).floatValue());
                HoldingDrawable.this.mPaint.setColor(color);
                HoldingDrawable.this.mSecondPaint.setColor(color);
                HoldingDrawable.this.mSecondPaint.setAlpha(HoldingDrawable.this.mSecondAlpha);
                HoldingDrawable.this.invalidateSelf();
            }
        });
        animator.setDuration(200L);
        return animator;
    }

    private ValueAnimator createIconValueAnimator() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.6f, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ((HoldingDrawable)HoldingDrawable.this).mIconScaleFactor[0] = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            }
        });
        animator.setDuration(200L);
        return animator;
    }

    private void notifyOnBeforeExpand() {
        if (this.mListener != null) {
            this.mListener.onBeforeExpand();
        }
    }

    private void notifyOnBeforeCollapse() {
        if (this.mListener != null) {
            this.mListener.onBeforeCollapse();
        }
    }

    private void notifyCollapsed() {
        if (this.mListener != null) {
            this.mListener.onCollapse();
        }
    }

    private void notifyExpanded() {
        if (this.mListener != null) {
            this.mListener.onExpand();
        }
    }
}

